## Ethereum C++ Client.

By Gav Wood, 2014.

Based on a design by Vitalik Buterin.

Contributors, builders and testers include Eric Lombrozo (cross-compilation), Tim Hughes (MSVC compilation & Dagger testing), Alex Leverington (Clang & Mac building), Marko Simovic (CI) and several others.

### Building

See the [Wiki](https://github.com/ethereum/cpp-ethereum/wiki) for build instructions, compatibility information and build tips. 

### Testing

To run the tests, make sure you clone the tests repository from github.com/ethereum to tests as a sibling to cpp-ethereum.

### Yet To Do

See [TODO](https://github.com/ethereum/cpp-ethereum/wiki/TODO)


### License

See [LICENSE](LICENSE)

### Contributing

All development goes in develop branch - please don't submit pull requests to master.

Please read [CodingStandards.txt](CodingStandards.txt) thoroughly before making alterations to the code base. Please do *NOT* use an editor that automatically reformats whitespace away from astylerc or the formatting guidelines as described in [CodingStandards.txt](CodingStandards.txt).

When altering eth/spec.json, mirror the changes to eth/eth.js. This should simply be cutting and pasting the relevant part from spec.json into eth.js. Don't alter the spec part from eth.js independently.

eth/abstractethstubserver.h is autogenerated from the jsonrpcstub executable that comes with the libjsonrpc library (json-rpc-cpp project). It shouldn't be maually altered.
