CURRENT_SOURCE_DIR=$1
CURRENT_BINARY_DIR=$2
BUILD_TYPE=$3
BUILD_PLATFORM=$4

echo "Current source dir: $CURRENT_SOURCE_DIR"
echo "Current binary dir: $CURRENT_BINARY_DIR"
echo "Build type: $BUILD_TYPE"
echo "Build platform: $BUILD_PLATFORM"

if [[ -e "$CURRENT_SOURCE_DIR/BuildInfo.h" ]]
then
	echo "Using existing BuildInfo.h"
	cp $CURRENT_SOURCE_DIR/BuildInfo.h $CURRENT_BINARY_DIR/BuildInfo.h.tmp
else
	if [[ -e "$CURRENT_SOURCE_DIR/.git" ]]
	then
		ETH_COMMIT_HASH=$(git --git-dir=$CURRENT_SOURCE_DIR/.git --work-tree=$CURRENT_SOURCE_DIR rev-parse HEAD)
		ETH_LOCAL_CHANGES=$(git --git-dir=$CURRENT_SOURCE_DIR/.git --work-tree=$CURRENT_SOURCE_DIR diff --shortstat)
		if [[ -z "$ETH_LOCAL_CHANGES" ]]
		then
			ETH_CLEAN_REPO=1
		else
			ETH_CLEAN_REPO=0
		fi

		echo "Commit hash: ${ETH_COMMIT_HASH} (Clean: ${ETH_CLEAN_REPO} - ${ETH_LOCAL_CHANGES})"
	else
		echo "Unknown repo."
		ETH_COMMIT_HASH=0
		ETH_CLEAN_REPO=1
	fi

	echo "// This file was automatically generated by cmake" > $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "#pragma once" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "#define ETH_COMMIT_HASH $ETH_COMMIT_HASH" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "#define ETH_CLEAN_REPO $ETH_CLEAN_REPO" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "#define ETH_BUILD_TYPE $BUILD_TYPE" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	echo "#define ETH_BUILD_PLATFORM $BUILD_PLATFORM" >> $CURRENT_BINARY_DIR/BuildInfo.h.tmp
fi

if [[ -e "$CURRENT_BINARY_DIR/BuildInfo.h" ]]
then
	DIFF=$(diff $CURRENT_BINARY_DIR/BuildInfo.h $CURRENT_BINARY_DIR/BuildInfo.h.tmp)
	if [[ -z "$DIFF" ]]
	then
		rm $CURRENT_BINARY_DIR/BuildInfo.h.tmp
	else
		mv $CURRENT_BINARY_DIR/BuildInfo.h.tmp $CURRENT_BINARY_DIR/BuildInfo.h
	fi
else
	mv $CURRENT_BINARY_DIR/BuildInfo.h.tmp $CURRENT_BINARY_DIR/BuildInfo.h
fi
