package dyliss.biopax.pattern.miner;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;

import dyliss.biopax.pattern.SpaimSIFEnum;

import org.biopax.paxtools.pattern.Pattern;
import dyliss.biopax.pattern.SpaimPatternBox;

/**
 * Miner for the controls-production-of pattern.
 * @author Ozgun Babur
 */
public class ControlsProductionOfMiner extends ConsumptionControlledByMiner
{
	/**
	 * Constructor that sets name, description and type.
	 */
	public ControlsProductionOfMiner()
	{
		super(SpaimSIFEnum.CONTROLS_PRODUCTION_OF);
	}

	/**
	 * Constructs the pattern.
	 * @return pattern
	 */
	@Override
	public Pattern constructPattern()
	{
		return SpaimPatternBox.controlsMetabolicCatalysis(blacklist, false);
	}

	@Override
	public String getSourceLabel()
	{
		return "controller ER";
	}

	@Override
	public String getTargetLabel()
	{
		return "part SMR";
	}
}
