package dyliss.biopax.pattern.miner;

import org.biopax.paxtools.pattern.Pattern;
import dyliss.biopax.pattern.SpaimPatternBox;
 
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;


import dyliss.biopax.pattern.SpaimSIFEnum;

/**
 * Miner for the catalysis-precedes pattern.
 * @author Ozgun Babur
 */
public class CatalysisPrecedesMiner extends AbstractSIFMiner
{
	/**
	 * Constructor that sets name and description.
	 */
	public CatalysisPrecedesMiner()
	{
		super(SpaimSIFEnum.CATALYSIS_PRECEDES);
	}

	/**
	 * Constructs the pattern.
	 * @return pattern
	 */
	@Override
	public Pattern constructPattern()
	{
		return SpaimPatternBox.catalysisPrecedes(blacklist);
	}

	@Override
	public String getSourceLabel()
	{
		return "first ER";
	}

	@Override
	public String getTargetLabel()
	{
		return "second ER";
	}

	@Override
	public String[] getMediatorLabels()
	{
		return new String[]{"first Control", "first Conversion", "second Control",
			"second Conversion"};
	}

	@Override
	public String[] getSourcePELabels()
	{
		return new String[]{"first simple controller PE", "first controller PE"};
	}

	@Override
	public String[] getTargetPELabels()
	{
		return new String[]{"second simple controller PE", "second controller PE"};
	}
}
