package dyliss.biopax.graph;


import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.apache.commons.lang3.StringEscapeUtils;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.impl.level3.BiochemicalReactionImpl;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexAssemblyImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.ControlImpl;
import org.biopax.paxtools.impl.level3.ConversionImpl;
import org.biopax.paxtools.impl.level3.DegradationImpl;
import org.biopax.paxtools.impl.level3.ModulationImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.ProteinReferenceImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeReferenceImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionRegulationImpl;
import org.biopax.paxtools.impl.level3.TransportImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.SequenceEntity;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;

//import org.biopax.paxtools.pattern.Searcher;
import dyliss.biopax.pattern.PatternSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;

import dyliss.biopax.GraphConfig;
import dyliss.biopax.SpaimEnum;
import dyliss.biopax.app.MainGenerator;
import dyliss.biopax.pattern.SpaimPatternBox;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;



public class GraphmlPaxGraphGenerator {
  
	 
	
	private static final String R2 = "R2";
	private static final String R3 = "R3";
	private static final String R1 = "R1";
	private static final String SUP = "SUP_";
	public static final String R1_CONTROLSEXPRESSIONWITHCONVERSION ="CONTROLSEXPRESSIONWITHCONVERSION"; 
	public static final String R1_CONTROLSEXPRESSIONWITHTEMPLATEREAC ="CONTROLSEXPRESSIONWITHTEMPLATEREAC"; 
	public static final String R2_CONTROLSMETABOLICCATALYSIS ="CONTROLSMETABOLICCATALYSIS"; 
	public static final String R3_REACTSWITH ="REACTSWITH";
	public static final String RX_CONTROLSPHOSPHORYLATION="CONTROLSPHOSPHORYLATION";
	public static final String RX_INCOMPLEXWITH="INCOMPLEXWITH";
	public static final String RX_INSAMECOMPLEX="INSAMECOMPLEX";
	public static final String RX_COMPLEX="COMPLEX";
	
	public boolean EXIT_ON_ISSUE=false;
	
	//private GraphConfig graphConfig;
	
	private   Boolean isAddEntityReference=true;
	
	private   Boolean isAddComplexComponent=true;
	
 
	private HashMap<String, GPaxNode> vmap=null;
	private HashMap<String, GPaxEdge> emap=null;
	
	private DirectedSparseMultigraph gGraph=null;
	private HashMap<String,String> mapBench=null;
	
	
	public DirectedSparseMultigraph getSpaimGraph() {
		return gGraph;
	}

	public void setSpaimGraph(DirectedSparseMultigraph spaimGraph) {
		this.gGraph = spaimGraph;
	}

	public void init() {
	 
		if(gGraph==null){
			gGraph = new DirectedSparseMultigraph<GPaxNode,GPaxEdge>();
		}
		if(vmap==null){
			 vmap=new HashMap<String, GPaxNode>();
		 
		 }
		if(emap==null){
			emap=new HashMap<String, GPaxEdge>();
			 
			 
		 }
	
	}
	
 public GraphmlPaxGraphGenerator(Boolean isAddEntityRef , Boolean isAddComplexComp, HashMap mapBench) {
		super();
		this.isAddEntityReference=isAddEntityRef;
		this.isAddComplexComponent=isAddComplexComp;
		this.init();
		this.mapBench=mapBench;
 	}

	 

	
	//entrypoint
	private void defineGraphFromPattern(Pattern p, 
			Map<BioPAXElement, List<Match>> matches) {
		
		int ct=0;
		for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			ct++;
			BioPAXElement k = ent .getKey();
		 
			List<Match> v = ent.getValue();
			for(Match ma : v){
 
				for(BioPAXElement b:ma.getVariables()){
					try {
					defineGraphFromBE(p, b);
					}
					catch(Exception e) {
				    	e.printStackTrace();	
					}
				}
			 
			}
		 
		}
		 
	}

	private void defineGraphFromBE(Pattern p, BioPAXElement b) throws Exception {
		//System.out.print( b+": "+b.getClass().getSimpleName()+": ");
		if(b instanceof ComplexImpl){
			ComplexImpl complx = (ComplexImpl )b ;
			//System.out.print("|"+ complx.getDisplayName());
			if(complx!=null){
		    	 subGraphComplex( complx, "subGraphComplex", "complex_pattern",null); 
		    	 }
		}
		else if(b instanceof ProteinImpl){
			ProteinImpl o = (ProteinImpl )b ;
			
			//System.out.print( "|"+o.getDisplayName());
		}
		else if(b.getClass().isAssignableFrom(Control.class) || b instanceof Control ){
			Control c = (Control )b ;
			//System.out.print( "|**isa_control: "+c.getControlType().name()+"");
			 processControl(p, c);
		}
		else if(b.getClass().isAssignableFrom(Conversion.class) || b instanceof Conversion ){
			Conversion o = (Conversion )b ;
			//System.out.print( " |**isa_conversion**");
			 
		}
		else if(b instanceof BiochemicalReactionImpl){
			BiochemicalReactionImpl o = (BiochemicalReactionImpl )b ;
			//System.out.print( "|"+o.getDisplayName());
		}
		else {
			BiochemicalReactionImpl o = (BiochemicalReactionImpl )b ;
			LogUtils.info( "==UNCAPTURED:"+o.getDisplayName());
		}

		LogUtils.info("");
	}

	
	public void subGraphControlsExpressionWithConversion(Pattern p, Map<BioPAXElement, List<Match>> matches  ) throws Exception {
		 
		if(matches==null){return;}
		
		 for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			 BioPAXElement k = ent .getKey();
			 List<Match> v = ent.getValue();
		     for(Match ma : v){
		    	 
		    	 Control c = (Control) ma.get("Control", p);
		    	 processControl(p, c);
			} 
		 }
	}

	private void processControl(Pattern p,	Control control ) throws Exception {
		
	 
		 if(control==null){
		 return ;
		 }
		 
		Set<Controller> colr = control.getController();
		ControlType controlType = control.getControlType(); 
		 
		 ArrayList<GPaxNode>clA= new ArrayList<GPaxNode>();
 
		 for(Controller c:colr){
			    boolean validEntity=false;
				if(c instanceof ProteinImpl){
					ProteinImpl o = (ProteinImpl )c ;
					 
					validEntity=true;
				}
				else if(c instanceof ComplexImpl){
					ComplexImpl o = (ComplexImpl )c ;
					 
					validEntity=true;
				}
				if(validEntity==false){
					
			 	
					if(EXIT_ON_ISSUE==true){
						throw new Exception("subGraphControlsExpressionWithConversion: unexpected entity "+c.getClass()+","+c);
					}else{
						System.err.println("subGraphControlsExpressionWithConversion: unexpected entity "+c.getClass()+","+c);
					}
					
				}else{
				 
						
				 
				  GPaxNode ncontrollerEntity = addGPaxNode(gGraph, c,R1);
				  if(ncontrollerEntity!=null){
					  clA.add(ncontrollerEntity);
				  } 
				  
				}
				
		  }

		 
	  

 
		Set<Process> controlledProc = control.getControlled();
   
		for( Process c:controlledProc){
			 boolean validEntity=false;
			 boolean tograph=true;
			if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){
				processConversionFromControl(controlType, clA, c, validEntity, tograph);
			}
 
		}
	}

	private void processConversionFromControl(ControlType controlType, ArrayList<GPaxNode> clA, Process c, boolean validEntity,
			boolean tograph) throws Exception {
		Conversion co =(Conversion) c;
		  String ct = controlType.toString().toUpperCase();
		if(c instanceof BiochemicalReactionImpl ){
			validEntity=true;
			tograph=true;
		}
		else if(c instanceof ComplexAssemblyImpl ){
			validEntity=true;
			tograph=true;
		 
		}
		else if (c instanceof TransportImpl){
			validEntity=true;
			tograph=true;
		}
		else if (c instanceof DegradationImpl){
			validEntity=true;
			tograph=true;
		}
		else if(c instanceof ConversionImpl ){
			validEntity=true;
			tograph=true; 
		}
		else if(c instanceof TemplateReactionImpl ){
			validEntity=true;
			tograph=true;  //will be processed by processToSubGraph
			 
		}
		
		
		if(validEntity==false){
			
			//throw new Exception("unexpected entity "+c.getClass()+","+c);
			if(EXIT_ON_ISSUE==true){
				throw new Exception("subGraphControlsExpressionWithConversion:2: unexpected entity "+c.getClass()+","+c);
			}else{
				System.err.println("subGraphControlsExpressionWithConversion:2: unexpected entity "+c.getClass()+","+c);
			}
			
			
		}else{
		
				if(tograph==true){
					
					Set<PhysicalEntity> outp = co.getRight();
					
					
					for(GPaxNode ncontrollerA:clA){	
			 			if(ct!=null){
							for(PhysicalEntity ou:outp){
								 GPaxNode nProcessProduct = addGPaxNode(gGraph, ou,R1);
								// LogUtils.info( "  >>>>out:"+ou.getDisplayName()+"");
								  GPaxEdge e = addGPaxEdge(gGraph, ncontrollerA, nProcessProduct,R1);
								  e.setInteractionType(ct); 
							}
 
			 			}
							
					}

				}
				
		}
		
 
		 LogUtils.info( "  >>>>processToSubGraph:start");
		 processToSubGraph(co, R3,SUP+R1_CONTROLSEXPRESSIONWITHCONVERSION);
			LogUtils.info( "  >>>>processToSubGraph:end");
	}

	
	private void processToSubGraph( Process  c, String cas, String patc) throws Exception {
		boolean validEntity=false;
		
		boolean tograph=true;
		String msg="";
		
		if (c.getClass().isAssignableFrom(Interaction.class) || c instanceof Interaction ){
			  //BiochemicalReaction|ComplexAssembly|Transport
			if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){
				
			
			
				Conversion co =(Conversion) c;
				if(c instanceof BiochemicalReactionImpl ){
					validEntity=true;
					tograph=true; 
				 
				}
				else if(c instanceof ComplexAssemblyImpl ){
					validEntity=true;
					tograph=true; 
 				}
				else if(c instanceof ConversionImpl ){
					validEntity=true;
					tograph=true; 
 				
				}
				else if (c instanceof TransportImpl){
					validEntity=true;
					tograph=true; 
 				}
				else if (c instanceof DegradationImpl){
					validEntity=true;
					tograph=true; 
				}
				else if(c instanceof ConversionImpl ){
					validEntity=true;
					tograph=true; 
				}
				else if(co instanceof TemplateReactionImpl ){
					validEntity=true;
					tograph=true; 
				}
				if(validEntity==false){
				//	throw new Exception("unexpected entity "+c.getClass()+","+c);
					if(EXIT_ON_ISSUE==true){
						throw new Exception("processToSubGraph: unexpected entity "+c.getClass()+","+c);
					}else{
						System.err.println("processToSubGraph: unexpected entity "+c.getClass()+","+c);
					}
					
				}else{
				
					 if(tograph==true){
						 
 							processConversion(cas, patc, co);	
			

					 }else{
						 LogUtils.info("**WARNING**"+c+"excluded from graph, " +msg);
				 }
				 
				}
				
			}
			
			
			 
			 
			if(validEntity==false){
				//throw new Exception(msg+", unexpected entity "+c.getClass()+","+c +"");
				

				if(EXIT_ON_ISSUE==true){
						 throw new Exception(msg+",processToSubGraph, unexpected entity "+c.getClass()+","+c +"");
				 }else{
						 System.err.println(msg+",processToSubGraph, unexpected entity "+c.getClass()+","+c +"");
				 }
			}
 
			 
			
		}
		
	
	}

	
	private void processConversion(String cas, String patc, Conversion co) throws Exception {
	
		
		if(co instanceof TemplateReactionImpl ){
			 
			 processTemplateReaction(co, cas, patc);

		}else {
			
			Set<PhysicalEntity> inl = co.getLeft();
			Set<PhysicalEntity> outp2 = co.getRight();
			
			for(PhysicalEntity in : inl){
				    	GPaxNode nin = addGPaxNode(gGraph, in,cas);
					 //	e.setInteractionType(SpaimEnum.substrat);	
					 	nin.getSpaimCase().add(cas);
						nin.getPatternTag().add(patc);
						 for(PhysicalEntity ou:outp2){

							 GPaxNode nou = addGPaxNode(gGraph, ou,cas);
							 
							 GPaxEdge ep = addGPaxEdge(gGraph, nin, nou,cas);
							 ep.setInteractionType(SpaimEnum.product);
							 nou.getSpaimCase().add(cas);
							 nou.getPatternTag().add(patc);
							 
						 }
			}
		}
	
	}
	
	private boolean processTemplateReaction(Process c, String cas, String patc) throws Exception {
		boolean validEntity;
		validEntity=true;

		TemplateReactionImpl  co = (TemplateReactionImpl )c ;
		GPaxNode rnode= addGPaxNode(gGraph, co,cas);
		NucleicAcid in = co.getTemplate();
		    //0 to 1
		 if(in==null){
		    	//throw new Exception("unexpected null entity NucleicAcid "+in +" for controlled "+co+co.getParticipant()+" "+co.getProduct());
		 }else{

		    	GPaxNode nin = addGPaxNode(gGraph, in,cas);
		   	  Set<PhysicalEntity> outp2 = co.getProduct();
			 //	e.setInteractionType(SpaimEnum.substrat);	
			 	nin.getSpaimCase().add(cas);
				nin.getPatternTag().add(patc);
				 for(PhysicalEntity ou:outp2){

					 GPaxNode nou = addGPaxNode(gGraph, ou,cas);
					 GPaxEdge ep = addGPaxEdge(gGraph, nin, nou,cas);
					 ep.setInteractionType(SpaimEnum.product);
					 nou.getSpaimCase().add(cas);
					 nou.getPatternTag().add(patc);
					 
				 }

		 }
		return validEntity;
	}


	
  
	
 
	
	public void subGraphsp(Pattern p, Map<BioPAXElement, List<Match>> matches , String cat,String  pc) throws Exception {
	//	LogUtils.info(">>>>>>>>>>>>>>>subGraphsp+<<<<<<<<<<<<<<<<<<<<" );
		if(matches==null){return;}
		 for(Entry<BioPAXElement, List<Match>> ent  : matches.entrySet()){
			 BioPAXElement k = ent .getKey();
			 List<Match> v = ent.getValue();
		     for(Match ma : v){
		         	 
		    	 SmallMoleculeReferenceImpl lpe = (SmallMoleculeReferenceImpl) ma.get("SMR1", p);
				
				// LogUtils.info(">>>>SMR1"+": "+lpe.getDisplayName());
				 SmallMoleculeReferenceImpl rpe = (SmallMoleculeReferenceImpl) ma.get("SMR2", p);
				// LogUtils.info(">>>>SMR2"+": "+rpe.getDisplayName());
				
				 Conversion co = (Conversion) ma.get("Conv", p);
				// System.out.print(">>>>Conversion"+": "+co.getUri());
				 if(co instanceof BiochemicalReactionImpl){
						BiochemicalReactionImpl o = (BiochemicalReactionImpl )co ;
					//	System.out.print( "|BiochemicalReaction:"+o.getDisplayName()+"");
				 }else{
					// System.out.print( "|"+co.getDisplayName()+"");
				 }
				// System.out.print("\n");
				 
				 
				 
				 GPaxNode no = addGPaxNode(gGraph, co,cat);
				 //if(no==null){
				// System.out.print("@@@"+no.getClass().getSimpleName()+" "+co.getDisplayName()+" "+co.getUri());
					 //System.exit(0);
				 //}
				 no.getSpaimCase().add(cat);
				 no.getPatternTag().add(pc);
				// LogUtils.info( " ==>>>0");
				 Set<PhysicalEntity> inp = co.getLeft();
				 for(PhysicalEntity in:inp){
					// LogUtils.info( " ==>>>0.1");
					 
					 GPaxNode n = addGPaxNode(gGraph, in,cat);
					// LogUtils.info( "==>>>0.2");
					 GPaxEdge e = addGPaxEdge(gGraph, n, no,cat);
					 e.setInteractionType(SpaimEnum.substrat);
					 //LogUtils.info( "  >>>>in:"+in.getDisplayName()+","+in.getClass().getSimpleName());
					 
					 
				 }
				// LogUtils.info( "==>>>1");
				 Set<PhysicalEntity> outp = co.getRight();
				 for(PhysicalEntity ou:outp){
				 
					// LogUtils.info( "==>>>1.1");
					 GPaxNode n = addGPaxNode(gGraph, ou,cat);
					 //LogUtils.info( "==>>>1.2");
					 GPaxEdge e = addGPaxEdge(gGraph, no, n,cat);
					 
					 e.setInteractionType(SpaimEnum.product);
					// LogUtils.info( "  >>>>out:"+ou.getDisplayName()+","+ou.getClass().getSimpleName());
				 }
			} 
		 }
	}

 

		
		
	
	
	 
	//TODO
	private void subGraphComplex( ComplexImpl complx, String cat, String patternCase, GPaxNode defcomplxn) throws Exception {
		 
		 GPaxNode complxn = null;
		 
		
		 if(defcomplxn!=null){
			 
		     complxn=defcomplxn;
		   
		 }else{
			 
			 complxn=addGPaxNode(gGraph, complx, cat,false);
		 
		 }
		 Set<Control> ctrll = complx.getControllerOf();
		 Boolean asControl=null;
		 if(ctrll!=null && ctrll.size()>0){
			 //LogUtils.info( "@Complx.getControllerOf.size>0");
			 asControl=true;
			 //R2
			 
			 for(Control cont:ctrll){
				 
				 ControlType controlType = cont.getControlType();
			     Set<Process> col = cont.getControlled();
			     GPaxNode complexAssemblyNode =null;
			      
				//String s="";
				for( Process c:col){
					 boolean validEntity=false;
					if (c.getClass().isAssignableFrom(Conversion.class) || c instanceof Conversion ){
						Conversion co = (Conversion )c ;  //BiochemicalReaction|ComplexAssembly|Transport
					// we dont keep only t complex assembl
						 // can we  keep as well chem react to have more nodes and edges ...? 
						
						if(c instanceof BiochemicalReaction ){
							validEntity=false;
						 
						}
						else if(c instanceof BiochemicalReactionImpl ){
							validEntity=false;
						 
						}
						else  if(c instanceof ComplexAssembly ){
							validEntity=true;
						 
						}
						else if(c instanceof ComplexAssemblyImpl ){
							validEntity=true;
						 
						}
						
						//if(validEntity==false){
						//	throw new Exception("unexpected entity "+c.getClass()+","+c);
						//}
						if(validEntity=true){
							
							
							complexAssemblyNode = addGPaxNode(gGraph, co, cat,false);
							complexAssemblyNode.getSpaimCase().add("R2COMPLX");
							complexAssemblyNode.getPatternTag().add(patternCase);
							 GPaxEdge e0 = addGPaxEdge(gGraph, complexAssemblyNode, complxn,cat);
							 e0.setInteractionType(SpaimEnum.product);
							 //redundante
							 
							
							
							 Set<PhysicalEntity> inp = co.getLeft();
							 for(PhysicalEntity in:inp){
							 
								 
								 GPaxNode n = addGPaxNode(gGraph, in, cat,false);

								 GPaxEdge e = addGPaxEdge(gGraph, n, complexAssemblyNode,cat);
								 e.setInteractionType(SpaimEnum.substrat);
								// LogUtils.info( "  >>>>in:"+in.getDisplayName()+"");
								 
								 
							 }
							 Set<PhysicalEntity> outp = co.getRight();
							 for(PhysicalEntity ou:outp){
						 
								 
								 GPaxNode n = addGPaxNode(gGraph, ou, cat,false);
								 
								 GPaxEdge e = addGPaxEdge(gGraph, complexAssemblyNode, n,cat);
								 e.setInteractionType(SpaimEnum.product);
								// LogUtils.info( "  >>>>out:"+ou.getDisplayName()+"");
							 }
						}

						
					}
			 
				}
	 
				Set<Controller> colr = cont.getController();
				   //String s="";
				 for(Controller controller:colr){
					    boolean validEntity=false;
					    boolean addControler=false;
						if(controller instanceof ProteinImpl){
							ProteinImpl o = (ProteinImpl )controller ;
							//s+=  o.getDisplayName();
							validEntity=true;
							addControler=true;
						}
						else if(controller instanceof ComplexImpl){
							ComplexImpl o = (ComplexImpl )controller ;
							//s+=  o.getDisplayName();
							validEntity=true;
							addControler=true;
						}
						else if(controller instanceof PhysicalEntityImpl){
							PhysicalEntityImpl o = (PhysicalEntityImpl )controller ;
							//s+=  o.getDisplayName();
							//LogUtils.info("[WARNING] "+o.getClass().getName()+" found");
							validEntity=true;
							addControler=true;
						}
						/*java.lang.Exception: unexpected entity class org.biopax.paxtools.impl.level3.PathwayImpl,http://pathwaycommons.org/pc2/Pathway_38f5a54cb2e6a6696b2b27eee66e9370
	at dyliss.biopax.graph.SpaimGraphGenerator.subGraphComplex(SpaimGraphGenerator.java:1025)
						 * 
						 */
						
						//if(validEntity==false){
						//	throw new Exception("unexpected entity "+controller.getClass()+","+controller);
						//}
						 
						 
						 // 	getComponent()
						 //     getMemberReferences()
						 
						 if(complexAssemblyNode==null){
							// throw new Exception("null  complexAssemblyNode "+controller.getClass()+","+controller);
							 
						 }else{
						  
							 if(addControler==true){
								 String ct = SpaimEnum.controlTypeToSpaimCodeValidated(cont,controlType);
							     
							     if(ct!=null){
							    	 GPaxNode controllern = addGPaxNode(gGraph, controller, cat,false);
							    	 GPaxEdge e = addGPaxEdge(gGraph, controllern, complexAssemblyNode,cat);
								     e.setInteractionType(ct);
								} 
							 }
							 
							
						 }
				  }
				
				
			 }
			 
		 }else{
			 asControl=false;
			 //R3 
			// LogUtils.info( "@NEWComplexAssemblyImpl():Complx.getControllerOf.size<0");
			 ComplexAssemblyImpl ca = new ComplexAssemblyImpl();
			 
			//to fix pk issue 
			 //+
			 String  l=complxn.getLabel();
			 if(l==null){
				 l=complxn.getPk();
			 }
 
			 	
			 GPaxNode complexAssemblyNode = addGPaxNodeImpl(
					 gGraph, ca, cat,
					 false,"assembly of "+l);
			 complexAssemblyNode.setPk(complexAssemblyNode.getLabel()+"|"+complxn.getPk());
			//-
				
			 
			 if(complexAssemblyNode!=null){
				 
				 complexAssemblyNode.getSpaimCase().add("R3COMPLX");
				 complexAssemblyNode.getPatternTag().add(patternCase);
				 Set<PhysicalEntity> inp = complx.getComponent();
				 for(PhysicalEntity in:inp){
				 
					 
					 GPaxNode n = addGPaxNode(gGraph, in, cat,false);
	
					 GPaxEdge e = addGPaxEdge(gGraph, n, complexAssemblyNode,cat);
					 e.setInteractionType(SpaimEnum.substrat);
					// LogUtils.info( "  >>>>in:"+in.getDisplayName()+"");
	 	 
				 }
	 
					 GPaxEdge e = addGPaxEdge(gGraph, complexAssemblyNode, complxn,cat);
					 e.setInteractionType(SpaimEnum.product);
	 
			 }
		 }
 
	}
	
		

		
	private GPaxEdge addGPaxEdge(DirectedSparseMultigraph<GPaxNode, GPaxEdge> g,  GPaxNode source,GPaxNode target, String spaimTag) {
		
		GPaxEdge  e = new GPaxEdge();
		 
		if(source!=null && target!=null){
			
		
		 
		 e.setPkFromNodes(source, target);
		 e.setSpaimTag(spaimTag);
 
		 
		 
		 
		 if(emap.containsKey(e.getPk())){
			 e = emap.get(e.getPk());
		 }else{
		     g.addEdge(e, source,target);	 
			 emap.put(e.getPk(),e);
		 }
		 
		} 
		
		return e;
		 
		 
	}
	private GPaxNode addGPaxNode(DirectedSparseMultigraph<GPaxNode, GPaxEdge> g, 
			BioPAXElement be, String cat ) throws Exception {
		return addGPaxNode( g, be,cat, true) ;
	}

	private GPaxNode addGPaxNode(DirectedSparseMultigraph<GPaxNode, GPaxEdge> g,
			BioPAXElement be, String cat, boolean rec) throws Exception {
		return 	 addGPaxNodeImpl( g,  be, cat,  rec,null);
		 
	}
	
	private GPaxNode addGPaxNodeImpl(DirectedSparseMultigraph<GPaxNode, GPaxEdge> g,
			BioPAXElement be, String cat, boolean rec,String defaultlabel) throws Exception {
		
		
		 
		
		 GPaxNode no = null;
		 no=new GPaxNode();
		 no.setElement(be);
		 
		 String label = null;
		 if(defaultlabel==null){
			 label = defineNodeLabel(no);
		 }else{
			 label=defaultlabel;
		 } 
		 
		 if(label==null){
			 
		 return null;
			 
		 }
		
		 
		 no.setLabel(label);
		 no.getSafeLabel();
		 no.setDescription(be.toString()+"|"+be.getUri());
		 no.setGroup("");
		 
		 /*
		 if(mapBench!=null ){
			String lb = label.toUpperCase();
			
			
			if(mapBench.containsKey(lb)){
				 no.setGroup(mapBench.get(lb));
			 }else{
				 for(String k:mapBench.keySet()){
					 if(k.contains(lb)){
						 no.setGroup(mapBench.get(lb)+"_X");
					 }
				 }
			 }
		 }*/
		
		 
		 
		String pk = no.getPk();
		
		GPaxNode fo = findNodeFromPk(no);
		if( fo!=null   ){
			 no = fo;
		 }else{
			 g.addVertex(no);
			 vmap.put(pk, no);
		 }
		 
		 
		 //+ additional processing related to entityReference management
		 //  and complex
		 if(be.getClass().isAssignableFrom(PhysicalEntityImpl.class) || be instanceof PhysicalEntityImpl  ){
			 
			 if( isAddEntityReference ==true){ 
				 if (SequenceEntity.class.isAssignableFrom(be.getClass())) {
					 //add all entityRefecences
					 SequenceEntity se = (SequenceEntity) be;
					 EntityReference er = se.getEntityReference();
					 GPaxNode ern = addGPaxNode(  g,   er,cat);
					 addGPaxEdge(g, ern, no,cat);
				 }
			 }
			 if( isAddComplexComponent ==true && rec==true){ 
				 if(be instanceof ComplexImpl){
					 ComplexImpl co = (ComplexImpl) be;
					 subGraphComplex(co,"R2_R3?",RX_COMPLEX,no);
				 }
			 }
			 /*
			 if(be instanceof ProteinImpl){
				 ProteinImpl p = (ProteinImpl) be;
				 p.getEntityReference();
			 }
			 
			 if(be instanceof ComplexAssemblyImpl){
				 
			 }*/
			 
		 }
		 
		 //-
		 
		return no;
	}

	//FM 02 2020 : adding direct alias system du avoid ducplicate entities
	private GPaxNode findNodeFromPk(GPaxNode no) {
	      
		   GPaxNode fo=null; 
			String pk=no.getPk();
			if(vmap.containsKey(pk)) {
				fo=vmap.get(pk);
			}else {
				//TODO : implement alias system to avoid duplicate 
				//alias e.g. for water +H2O
				List<String> alias=alias(no.pkFirstPart()); 
				if(alias!=null) {
					for(String apk : alias) {
						if(vmap.containsKey(apk)) {
							fo=vmap.get(apk);
						}	          		
					}
				}
				
				
			}
			   
			return fo;
		}	
	
	
	
	private List<String> alias(String pkFirstPart) {
		// TODO Auto-generated method stub
		return null;
	}

	private String defineNodeLabel(GPaxNode no) {
		BioPAXElement be= no.getElement();
		no.setSimpleuri(GPaxNode.simpleURI(be.getUri()));
		
		
		// for graphml output
		 String label="";
		 if (be.getClass().isAssignableFrom(PhysicalEntity.class) || be instanceof PhysicalEntity ){
				PhysicalEntity o = (PhysicalEntity )be ;
				label=o.getDisplayName() ;
		 }
		 else if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
			 Interaction o = (Interaction )be ;
				label=o.getDisplayName() ;
		 }
		 else if (be.getClass().isAssignableFrom(Control.class) || be instanceof Control ){
			   Control o = (Control )be ;
				label=o.getDisplayName() ;
		 }
		 else if (be.getClass().isAssignableFrom(EntityReference.class) || be instanceof EntityReference ){
			 EntityReference o = (EntityReference )be ;
				label=o.getDisplayName() ;
		 }
		 else if (be.getClass().isAssignableFrom(TemplateReactionRegulation.class) || be instanceof TemplateReactionRegulation){
			    TemplateReactionRegulation o = (TemplateReactionRegulation )be ;
				label=o.getDisplayName() ;
		 }
		 
		 else{
			    label=be.toString();
		 }
		 
		 
		 if(label==null  || label.equals("null")){
			 if(be instanceof CatalysisImpl){
				 CatalysisImpl o = (CatalysisImpl )be ;
				 label=o.getDisplayName() ;
				 if(label==null){
					 label=o.getStandardName();
				 }
				  
				 if(label==null){
					 label="CATALYSIS|"+be.toString();
				 }
			 }
			 if(be instanceof TemplateReactionRegulationImpl){
				 TemplateReactionRegulationImpl o = (TemplateReactionRegulationImpl )be ;
				 label=o.getDisplayName() ;
				 if(label==null){
					 label=o.getStandardName();
				 }
				 
				
				  
				 if(label==null){
					 label="CATALYSIS|"+be.toString();
				 }
			 }
			 else if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
				     Interaction o = (Interaction )be ;
					 label=o.getDisplayName() ;
					 if(label==null){
						 label=o.getStandardName();
						  
					 }
				  
					 
					 label=no.getSimpleuri();
			 }
			 else{
				
				 label=no.getSimpleuri();
			 }
		 }
		  
		 if(label == null){
			 label=defineLabelfx(be);
		 }
		
			 

		 if (be.getClass().isAssignableFrom(ComplexAssemblyImpl.class) ||
						 be instanceof ComplexAssemblyImpl){ 
			 if(label == null){
					label= defineComplexAssemblyID(be, label);
					//  LogUtils.info("@@FIXED::LABEL::ComplexAssemblyImpl  label,uri:  :"+label + be.getUri()) ;
			 }else{
				    //  LogUtils.info("@@DEFAULT::LABEL::ComplexAssemblyImpl  label,uri  :"+label+ be.getUri()) ;
			 }
		  }
				//  LogUtils.info(joined);
				 
				
		 
		 
		 
		return label;
	}

	private String defineComplexAssemblyID(BioPAXElement be, String lb) {
		String joined=null;
	 
		 
	 
		//ComplexAssemblyImpl o = (ComplexAssemblyImpl )be ;
		
		Conversion o = (Conversion )be ;
		
		 
		
		 lb=o.getDisplayName() ;
			  
		List<String> plabl = new ArrayList<String>();
		   
		//     LogUtils.info(o.getParticipantStoichiometry().size());
		//	 LogUtils.info(o.getParticipant().size());
		//	 LogUtils.info(o.getRight().size());
		//	 LogUtils.info(o.getLeft().size());
			
		  
		for(Stoichiometry  p:	o.getParticipantStoichiometry()){
					String v=defineLabelfx((BioPAXElement) p);
					if(v!=null){
						
						plabl.add(v);
						
					}
		 }
			
		for(Entity p:	o.getParticipant()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){
				
				plabl.add(v);
				
			}
		}
		
		for(Entity p:	o.getRight()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){
				
				plabl.add(v);
				
			}
		}
		
		for(Entity p:	o.getLeft()){
			String v=defineLabelfx((BioPAXElement) p);
			if(v!=null){
				
				plabl.add(v);
				
			}
		}
		
		
		
		if(lb != null){
			plabl.add(lb);
		 }
		sortByStringLength(plabl);
		joined = Joiner.on("").join(plabl);
		if(joined!=null && !joined.equals("")){
			return joined;
		}else{
			return null;
		}
	}
	
	
	private void sortByStringLength( List<String> plabl) {	
		
	  Ordering<String> byLength = new Ordering<String>() {
	       @Override
	       public int compare(String s1, String s2) {
	          return Ints.compare(s1.length(), s2.length());
	       }
	    };
 

	    Collections.sort(plabl,byLength.nullsFirst().reverse());
}
	/*
	 * 
	 */
	
	  /**
	   * The method returns the smallest entity having a name, i.e. a gene symbol,
	   * which could be parsed
	   * 
	   * @param entity
	   * @return Collection containing {@link entity}s having a name and are not
	   *         instance of a complex or ComplexAssembly
	   */
	
	/*protected Collection<? extends entity> getEntitiesWithName(Entity entity) {
	    Set<entity> resEntities = new HashSet<entity>();
	    String name = entity==null?null:entity.getNAME();

	    if (name!=null && !name.isEmpty() && !(pathway.class.isAssignableFrom(entity.getClass()))) {
	      if (complex.class.isAssignableFrom(entity.getClass())) {
	        complex c = (complex) entity;
	        for (physicalEntityParticipant pe : c.getCOMPONENTS()) {
	          resEntities.addAll(getEntitiesWithName(pe.getPHYSICAL_ENTITY()));
	        }
	      } else if (complexAssembly.class.isAssignableFrom(entity.getClass())) {
	        complexAssembly c = (complexAssembly) entity;
	        for (InteractionParticipant pe : c.getPARTICIPANTS()) {
	          resEntities.addAll(getEntitiesWithName(((physicalEntityParticipant)pe).getPHYSICAL_ENTITY()));          
	        }

	      } else {
	        resEntities.add(entity);
	      }
	    } 
	    return resEntities;
	  }  
*/

	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */
	
	
	/*
	 * Given a binding element (complex or interaction)
	 * and type (like left or right),
	 * returns chemical modification (abbreviated form).
	 */
	private static Set<String> getInteractionChemicalModifications(BioPAXElement participantElement) 
	{
		if(participantElement == null) {
			return null;
		}

		final Set<String> chemicalModificationsSet = new HashSet<String>();

		// if we are dealing with participant processes (interactions
		// or complexes), we have to go through the participants to get the
		// proper chemical modifications
		Collection<?> modificationFeatures = getValues(participantElement, "feature");
		if (modificationFeatures != null) {
			for (Object modification : modificationFeatures) {
				if (modification != null) {
					Object value = getValue((BioPAXElement) modification, "modificationType");
					if (value != null) {
						String mod = value.toString();
						//remove the ClassName_ prefix and square braces -
						mod = mod.substring(mod.indexOf("_") + 1).replaceAll("\\[|\\]", "");
						chemicalModificationsSet.add(mod);
					}
				}
			}
		}

		Collection<?> modificationNotFeatures = getValues(participantElement, "notFeature");
		if (modificationNotFeatures != null) {
			for (Object modification : modificationNotFeatures) {
				if (modification != null) {
					Object value = getValue((BioPAXElement) modification, "modificationType");
					if (value != null) {
						String mod = value.toString();
						//remove the ClassName_ prefix and square braces;
						//add "!" upfront (i.e. "NOT")
						mod = "!" + mod.substring(mod.indexOf("_") + 1).replaceAll("\\[|\\]", "");
						chemicalModificationsSet.add(mod);
					}
				}
			}
		}

		return  chemicalModificationsSet ;
	}

	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */
	
	/**
	 * Attempts to get the value of any of the BioPAX properties
	 * in the list.
	 * @param bpe BioPAX Element
	 * @param properties BioPAX property names
	 * 
	 * @return the value or null
	 */
	public static Object getValue(BioPAXElement bpe, String... properties) {
		for (String property : properties) {
			try {
				Method method = bpe.getModelInterface().getMethod(
						"get" + property.substring(0, 1).toUpperCase()
								+ property.substring(1).replace('-', '_'));
				Object invoke = method.invoke(bpe);
				if (invoke != null) {
					return invoke;
				}
//				PropertyEditor editor = SimpleEditorMap.L3
//					.getEditorForProperty(property, bpe.getModelInterface());
//				return editor.getValueFromBean(bpe); // is always a Set!
			} catch (Exception e) {
				e.printStackTrace();
			   /*
				if(log.isDebugEnabled()) {
					// this is often OK, as we guess L2 or L3 properties...
					log.debug("Ignore property " + property + " for " 
						+ bpe.getUri() + ": " + e);
				}*/
			}
		}
		return null;
}
	
	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */
	
	/**
	 * Attempts to get the values of specified BioPAX properties.
	 * @param bpe BioPAX Element
	 * @param properties BioPAX property names
	 * 
	 * @return the set of property values or null
	 */
	public static Collection<?> getValues(BioPAXElement bpe, String... properties) {
		Collection<Object> col = new HashSet<Object>();
		
		for (String property : properties) {
			try {
				Method method = bpe.getModelInterface().getMethod(
						"get" + property.substring(0, 1).toUpperCase()
								+ property.substring(1).replace('-', '_'));
				
				Object invoke = method.invoke(bpe);
				if (invoke != null) {
					// return value can be collection or Object
					if (invoke instanceof Collection) {
						col.addAll((Collection) invoke);
					} else {
						col.add(invoke);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
				/*if(log.isDebugEnabled()) {
				log.debug("Cannot get value of '" + property + "' for "
					+ bpe.getUri() + ": " + e);
			}*/
			}
				
			 
		}
		
		return col;
}
	
	/*
	 *from 
	 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
	 * 
	 */
	
	
	 public static String defineLabelfx(BioPAXElement element) {

			String label = defineNamefx(element);
			
			if (!(element instanceof Interaction)) {
				// get chemical modification & cellular location attributes
				Set<String> chemicalModificationsWrapper = getInteractionChemicalModifications(element);
				// set node attributes
				if(chemicalModificationsWrapper != null) {
					// add modifications to the label/name
					label += chemicalModificationsWrapper.toString();
					//set the node attribute (chem. mod. list)
					List<String> list =Lists.newArrayList(chemicalModificationsWrapper);
					//List<String> list = chemicalModificationsWrapper.asList();
					if (list != null && !list.isEmpty()) {
						// store chemical modifications to be used by the view details panel, node attribute browser, Quick Find
						
						/*Attributes.set(network, node, BIOPAX_CHEMICAL_MODIFICATIONS_LIST, list, String.class);
						if (list.contains(PHOSPHORYLATION_SITE)) {
							Attributes.set(network, node, BIOPAX_ENTITY_TYPE, PROTEIN_PHOSPHORYLATED, String.class);
						}*/
					}
				}

				// add cellular location to the label/name
				if(element instanceof PhysicalEntity) {
					CellularLocationVocabulary cl = ((PhysicalEntity) element).getCellularLocation();
					if(cl != null) {
						String terms = cl.toString();//it's like CellularLocationVocabulary_terms...
						terms =  terms.substring(terms.indexOf("_") + 1).replaceAll("\\[|\\]", "");
						label += (terms.length() > 0) ? ("; " + terms) : "";
					}
				}
			}
		return label;
	}

	 /*
		 *from 
		 *https://github.com/PathwayCommons/CyPath2/blob/master/src/main/java/org/pathwaycommons/cypath2/internal/BioPaxMapper.java
		 * 
		 */
		
	
	public static String defineNamefx(BioPAXElement bpe) {

		String nodeName = null;
		if(bpe instanceof Named)
			nodeName = ((Named)bpe).getDisplayName();
		String r=null;
		if(nodeName == null || nodeName.isEmpty()){
			r=  bpe.getUri();
		}
		else{
			r=  StringEscapeUtils.unescapeHtml4(nodeName);
		}
		return r;
	}

		
	public static void normalize(Model m) throws URISyntaxException {
		//merge interactions with exactly same properties...
		ModelUtils.mergeEquivalentInteractions(m);
		//some extra normalization to get better conversion results
		ModelUtils.normalizeGenerics(m); //TODO not sure want to apply this...
		for(SimplePhysicalEntity spe : new HashSet<SimplePhysicalEntity>(m.getObjects(SimplePhysicalEntity.class))) {
			ModelUtils.addMissingEntityReference(m, spe);
			URI uri = new URI(spe.getUri());
			//LogUtils.info(" "+spe.getDisplayName()+" ---- "+uri.getFragment());
		}
	}

	public   GPaxPatternSearchResult rawPatternSearch(
			Model m,
			SIFType[] sifTypes, //SIF rules/patterns to apply/search
			 Blacklist blacklist 
			) throws Exception
	{
		GraphmlPaxGraphGenerator.normalize(m);
	
		
		Pattern p =null;
		Map<BioPAXElement, List<Match>> matches =null;
		String report="";
	
		
		ArrayList<DirectedSparseMultigraph<GPaxNode, GPaxEdge>> glist = new ArrayList<DirectedSparseMultigraph<GPaxNode, GPaxEdge>>();
	
		
		//R1
	    //NOT found with glucose metab file
		//found with mapK.owl
		LogUtils.info("**************CASE_R1*******************");
		int r1ct=-1;
		int r1ct1=-1; 
		int r1ct2=-1;
		int rphospho=-1;
		int r2ct=-1;
		int rcomplx1=-1;
		int rcomplx2=-1;
		int r3ct= -1;
		 
		LogUtils.info("**************CASE_R1_1*******************");
	    p =SpaimPatternBox.controlsExpressionWithTemplateReac();
		matches = PatternSearcher.search(m, p);
	    r1ct1= MainGenerator.countPatternSearchResult(p, matches);
	    
	    
	//    this.subGraphControlsExpressionWithTemplateReac(p, matches);
	     
	  
	    LogUtils.info("**************CASE_R1_2*******************");
	    p =SpaimPatternBox.controlsExpressionWithConversion();
		matches = PatternSearcher.search(m, p);
		r1ct2= MainGenerator.countPatternSearchResult(p, matches);
		r1ct=r1ct1+r1ct2;
	    
		this.subGraphControlsExpressionWithConversion(p, matches); 
	     
	    
	    LogUtils.info("**************CASE_R1_3*******************");
	    p =SpaimPatternBox.controlsPhosphorylation();
		matches = PatternSearcher.search(m, p);
		rphospho= MainGenerator.countPatternSearchResult(p, matches);
		//this.subGraphControlPhospho(p, matches);

	   
		//R2
	    //found with glucose metab file
	    LogUtils.info("**************CASE_R2_1*******************");
		p =SpaimPatternBox.controlsMetabolicCatalysis(blacklist, true);
		matches = PatternSearcher.search(m, p);
		  r2ct=  MainGenerator.countPatternSearchResult(p, matches);
		//  this.subGraphControlsMetabolicCatalysis(p, matches);
	     
	 

	    
		 
	    //R3
	    //found with glucose metab file
	    LogUtils.info("**************CASE_R3*******************");
	    LogUtils.info("**************CASE_R3_1*******************");
	    
	    //HERE
	    
	    // ******WARNING***** :  must manage case R3 with only one substrate
	    p =SpaimPatternBox.reactsWith(blacklist);
		matches = PatternSearcher.search(m, p);
		int  r3ct1=  MainGenerator.countPatternSearchResult(p, matches);
	    //sgg.generateSubGraphFromPatternMatches(p,   matches,SpaimGraphGenerator.R3_REACTSWITH);
		//this.subGraphReactWith(p, matches);
		
	    LogUtils.info("**************CASE_R3_2*******************");
	    // ******WARNING***** :  must manage case R3 with only one substrate
	    p =SpaimPatternBox.usedToProduce(blacklist);
		matches = PatternSearcher.search(m, p);
		int  r3ct2=  MainGenerator.countPatternSearchResult(p, matches);
	    //sgg.generateSubGraphFromPatternMatches(p,   matches,SpaimGraphGenerator.R3_REACTSWITH);
		//this.subGraphReactWith(p, matches);
		
		
		r3ct=r3ct1+r3ct2;
	    LogUtils.info("**************CASE_R3_3*******************");
	    p =SpaimPatternBox.inComplexWith();
		matches = PatternSearcher.search(m, p);
		rcomplx1= MainGenerator.countPatternSearchResult(p, matches);
	
	  
	//	this.subGraphInComplexWithOrInSameComplex(p, matches, "R2_R3?",RX_INCOMPLEXWITH);
	    
	   
	    LogUtils.info("**************CASE_R3_4*******************");
	    p =SpaimPatternBox.inSameComplex();
		matches = PatternSearcher.search(m, p);
		  rcomplx2= MainGenerator.countPatternSearchResult(p, matches);
	
	  
		//  this.subGraphInComplexWithOrInSameComplex(p, matches, "R2_R3?",RX_INSAMECOMPLEX);
	    
		 
		  
		 report+=" R1="+r1ct;
		 report+=" R2="+r2ct;
		 report+=" R3="+r3ct;
		 report+=" RPHOSPHO="+rphospho;
		 report+=" RCOMPLX1="+rcomplx1;
		 report+=" RCOMPLX2="+rcomplx2;
		 
		
	    glist.add(this.getSpaimGraph());
	    GPaxPatternSearchResult rp = new GPaxPatternSearchResult(  report,  glist);
	    return rp;
	    
	}
	
	
 
}
