package dyliss.biopax.db;

 


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.collections15.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.biopax.paxtools.impl.level3.CatalysisImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.DnaImpl;
import org.biopax.paxtools.impl.level3.ProteinImpl;
import org.biopax.paxtools.impl.level3.RnaImpl;
import org.biopax.paxtools.impl.level3.SmallMoleculeImpl;
import org.biopax.paxtools.impl.level3.TemplateReactionRegulationImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Provenance;

//import dyliss.biopax.GraphConfig;
import dyliss.biopax.graph.SpaimEdge;
import dyliss.biopax.graph.SpaimNode;
import dyliss.biopax.util.LogUtils;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
 
 
public abstract  class SpaimGraphAbtractWriter {
	
	private static final String IRREVERSIBLE_VALUE = "irreversible";
	private static final String REVERSIBLE_VALUE = "reversible";
	private static final String DEFAULT_DB_ALIAS = "Transpath";

	
	
	private Map<String, DBMolecule> moleculeByNameTp  ;
	private Map<String, DBReaction> reactionBydescr  ;
	private Map<String, GenericSignalSpaim> genericSignalSpaimMap  ;
	
	
	private Map<String,Pair<Object> > hubMap;
	private HashSet<String> taggedEdgeMap ;
	
	
	boolean doHub = false;
	 
	boolean isDoDB  =true;
	boolean  isDoDBtoFile=true;

 
	String hubFile = null;
	String dBFile= null;
	
	String dbDriver= null;
	String dbUrl= null;
	String dbUser= null;
	String dbPassword= null;
	

	public SpaimGraphAbtractWriter( 	) {
 
		super();
 
 
		 init();
	} 
	 
	public SpaimGraphAbtractWriter( 	
			boolean isDoDB , boolean  isDoDBtoFile ,	
			boolean doHub ,String hubFile ,String dBFile,
				String dbDriver,String dbUrl,
				String dbUser,String dbPassword 
				) {
 
		super();
		this.isDoDB  =isDoDB;
		this.isDoDBtoFile=isDoDBtoFile;
		this.doHub = doHub;
	 
		this.hubFile = hubFile;
		this.dBFile= dBFile;
		
		this.dbDriver= dbDriver;
		this.dbUrl= dbUrl;
		this.dbUser= dbUser;
		this.dbPassword= dbPassword;
		
		
		
		 init();
	}

	protected void init() {
		//this.graphConfig = graphConfig;
		 moleculeByNameTp = new HashMap<String, DBMolecule>();
		 reactionBydescr = new HashMap<String, DBReaction>();
		 genericSignalSpaimMap = new HashMap<String, GenericSignalSpaim>();
		 hubMap= new HashMap<String,Pair<Object> >();
		 taggedEdgeMap = new HashSet<String>();
	}

	public abstract void persistGs(Connection conn, GenericSignal si) throws Exception;

	public abstract  void persistGss(Connection conn, GenericSignalSpaim gss) throws Exception ;

	public abstract  void persistTuple(Connection conn, DBTuple t) throws Exception;

	public abstract  void initPersist(Connection conn) throws Exception ;
	
	
	public abstract   Connection connect() throws Exception;

	
  	
	
	public   void iterateAndComplete(
			 
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg 
			)
			throws IOException, Exception {
		Connection conn = connect(); 
		writeGraphToDbImpl( jg , conn); 
	}
	
	
	public   void writeGraphToDbImpl(
			 
			DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg 
			, Connection conn 
			)
			throws IOException, Exception {
		
	
		
	
		
	    initPersist(conn);	
	    
	    
		Collection<SpaimNode> vl = jg.getVertices();
		int vct=0;
		int mct=0;
		int rct=0;
		for(SpaimNode v:vl){
			
			
			vct++;
			
		
			
			DBTuple t =null;
			boolean doInsertEnt=false;
			BioPAXElement be = v.getElement();
			
			String biopaxtype=be.getClass().getSimpleName();
			
			String dataSource=null;
			if (be.getClass().isAssignableFrom(Entity.class) || be instanceof  Entity ){
				Entity ent=(Entity) be;
				Set<Provenance> ds = ent.getDataSource();
				if(ds!=null ){
					  dataSource="";
					 int i=0;
					for(Provenance p:ds){
						i++;
						String sp="";
						if(i>1){
							sp=",";
						}
						dataSource+=sp+p.getDisplayName();
					}
				}
			}
			
			
			if (be.getClass().isAssignableFrom(PhysicalEntity.class) || be instanceof PhysicalEntity ){
					 
				 
		 		
				 	String typeOfMolecule ="u"; //fm: added u (undefined) 
			
				 	if(be instanceof ProteinImpl){
						 typeOfMolecule ="m";

					 }
					 else if(be instanceof ComplexImpl){
						 typeOfMolecule ="m";
					 }
					 else if(be instanceof SmallMoleculeImpl){
						 typeOfMolecule ="m";
					 }
					 else if(be instanceof DnaImpl){
						 typeOfMolecule ="g";
					 }
					 else if(be instanceof RnaImpl){
						 typeOfMolecule ="g";
					 }
					 //TODO : check the effect of the following  simplification
					//DBmolecule
					 //same label and type -> same entity (warning : this is a compression feature) 
					DBMolecule m =null;
					String name=v.getLabel();
					
					name = formatEntityName(name);
					
					String mkey=moleculeKey(typeOfMolecule, name);
					
					if( this.moleculeByNameTp.containsKey(mkey)){
						m=this.moleculeByNameTp.get(mkey);
						v.setDbid(m.getMolecule_id());
						v.setReversible(null);
						doInsertEnt=false;
					}else{
						mct++;
						//warning !   O and not 0 for molecule....
						String molecule_id= String.format(typeOfMolecule.toUpperCase()+"O%09d", mct);
						v.setDbid(molecule_id);// to be used when during  following "edge to sql" step
						v.setReversible(null);
						//G000000028, M000000451
						
						if(molecule_id==null || typeOfMolecule==null ||name==null){
							doInsertEnt=false;
						}else{
							m = new DBMolecule(molecule_id, typeOfMolecule, name);
							m.setDebug(v.getBiopaxType()+"|"+v.getLabel());
							this.moleculeByNameTp.put(mkey, m);
							doInsertEnt=true;
						}	
					}
					computeHubMap(mkey,jg, v, m);
					m.setBiopaxtype(biopaxtype);
					 
					m.setUri(be.getUri());
					m.setDatasource(dataSource);
					t=m;
			 }
			 else if (be.getClass().isAssignableFrom(Interaction.class) ||
					  be instanceof Interaction ){
				   String effect="EFFECT_NOT_DEFINED";
				   String level=null;// semantic (R1)| mechanistic (R2, R3)
				    if(v.getSpaimCaseFlat().contains("R1")){
				    	 level="semantic";
				    }
				    else if((v.getSpaimCaseFlat().contains("R2"))||(v.getSpaimCaseFlat().contains("R3") )){
				    	 level="mechanistic";
				    }
				    else{
				    	  level="mechanistic";  // all other not tagged  cases should similar to  R2 or R3
				    }
					//TODO
					//DBReaction
					rct++;
					String reaction_id = String.format("XN%09d", rct);
					v.setDbid(reaction_id);// to be used when during  following "edge to sql" step
					
					//TODO
					// reversible (R3)|irreversible (R1,R2) => from DB examples.  safe ?
					String reversible=null; 
					if(v.getSpaimCaseFlat().contains("R1")){
						reversible=IRREVERSIBLE_VALUE;
				    }
				    else if( v.getSpaimCaseFlat().contains("R2")){
				    	reversible=IRREVERSIBLE_VALUE;
				    }
				    else if(v.getSpaimCaseFlat().contains("R3") ){
				    	reversible=REVERSIBLE_VALUE;
				    }else{
				    	 reversible=REVERSIBLE_VALUE;   // all other not tagged  cases  
				    }
					
					
					//--> put Rx in all nodes extraced from a pattern 
					/*
					 * When at least one of the species-specific reactions was indicated as reversible, the unified generic reaction was then considered as reversible.
						Some molecules could be considered as not limiting and highly generic in many reactions, so they were removed
						from the reaction sets: ATP, ADP, NTP, NDP, protein remnants, phosphate, Coenzyme A, water and H+.
						[...]
						When at least one of the species-specific reactions was indicated as reversible, the unified generic reaction was then considered as reversible. Some molecules could be considered as not limiting
						and highly generic in many reactions, so they were removed from the reaction sets: ATP, ADP, NTP, NDP, protein remnants, phosphate, Coenzyme A, water and H+.
					 */
					if (be.getClass().isAssignableFrom(Control.class) || be instanceof Control ){
						
						/*
						 * EFFECT_NOT_DEFINED|EFFECT_INHIBITION|EFFECT_ACTIVATION|EFFECT_UNKNOWN|EFFECT_EXPRESSION
						 * pb db:			 EFFECT_ACTIVATION 	7992, EFFECT_EXPRESSION 	58400, EFFECT_INHIBITION 	1923, EFFECT_NOT_DEFINED 	105215, EFFECT_UNKNOWN 	320
						 */
						Control co = (Control) be;
						String ct=null;
						if(co.getControlType()!=null){
							
							ct=co.getControlType().toString().toUpperCase();
							
						}
						// activation, inhibition, inhibition-allosteric, inhinition-competitive, inhibition-irreversible,
						//inhibition-noncompetitive, inhibition-other, inhibition-uncompetitive, activation-nonallosteric, activation-allosteric
						//TODO 
						//reversible ???
						
						if(ct!=null){
							 
							
								if( ct.startsWith("IRREVERSIBLE")  ){
									 
									reversible=IRREVERSIBLE_VALUE;
								}
						
								
								//effect
								if( ct.startsWith("ACTIVATION")) {
									effect="EFFECT_ACTIVATION";
								}
								else if( ct.startsWith("INHIBITION") ){
									effect="EFFECT_INHIBITION";
								} 
								else{
									effect="EFFECT_NOT_DEFINED";
								}
								
								if(be instanceof TemplateReactionRegulationImpl ) {
									//TODO : EFFECT_EXPRESSION ?? shoudl we use controlType here (effect expression +/-) ?
									if(ct.startsWith("ACTIVATION")){
										effect="EFFECT_EXPRESSION";
									}
								}

						}
						
					}
				 
					
				 
					String reaction_description=v.getLabel();
					DBReaction r = null;
					
					String key=reactionKey(effect, reversible, reaction_description);
					 
					if( this.reactionBydescr.containsKey(key)){
						r=this.reactionBydescr.get(key);
						v.setReversible(reversible);
						doInsertEnt=false;
					}else{
						
						if( reversible==null || level==null ||reaction_id==null || effect==null ){
							doInsertEnt=false;
						}else{
						
							r = new DBReaction(reaction_id, level, reversible, effect, reaction_description);
							v.setReversible(reversible);// for further generic_signal equilibrium_id generation during edges analysis 
							r.setDebug(v.getBiopaxType()+"|"+v.getLabel());
					   
							this.reactionBydescr.put(key, r);
							doInsertEnt=true;
						
						}
					}
					//
					r.setBiopaxtype(biopaxtype);
					r.setDatasource(dataSource);
					r.setUri(be.getUri());
					t=r;

			 }
			 else{
				 v.setDbid(null);
				 LogUtils.warn("******unexpected entity ******|"+v.getDescription());
			 }
			

			 if(doInsertEnt==true && t!=null){
				 
				 persistTuple(conn, t);
			 }
			 
		}
		
		Map <String, Integer> equilMap = new HashMap<String, Integer>();
		Collection<SpaimEdge> edges = jg.getEdges();
		if(edges.size()>0){
			int cte=0;
			for(SpaimEdge e:edges){
				cte++;
				
				Pair<SpaimNode> ep = jg.getEndpoints(e);
				SpaimNode f = ep.getFirst();
				SpaimNode s = ep.getSecond();
				DBReaction react =null;
			
				//TODO
				
				String role_id=e.getSpaim();
				
				String molecule_id=null;
				 String rev =null;
				String signal_id= null; 
				String dg= "ID|"+f.getDbid()+"_"+f.getBiopaxType()+"("+f.getLabel()+") ="+e.getSpaim()+  "=> "+s.getDbid()+"_"+s.getBiopaxType()+"("+s.getLabel()+")"  ;
					
				BioPAXElement first = f.getElement();
				BioPAXElement second = s.getElement();
				Integer validationTest=0;
				if (first.getClass().isAssignableFrom(PhysicalEntity.class) || first instanceof PhysicalEntity ){
					validationTest=1;
					if (second.getClass().isAssignableFrom(Interaction.class) || second instanceof Interaction ){
						validationTest=2;
						  
						 signal_id=  s.getDbid() ;
						 molecule_id=f.getDbid();
						 rev = s.getReversible();
						 
						//FM 02 2020			 
						s.setSrctype("R");
						f.setSrctype("M");
						//
						
					}
				}
				else if (second.getClass().isAssignableFrom(PhysicalEntity.class) || second instanceof PhysicalEntity ){
					validationTest=1;
					if (first.getClass().isAssignableFrom(Interaction.class) || first instanceof Interaction ){
						validationTest=2;
						
						 signal_id=  f.getDbid() ;
						 molecule_id=s.getDbid();
						 rev = f.getReversible();
						//FM 02 2020			 
							f.setSrctype("R");
							s.setSrctype("M");
					   //
					}
				}
				
				if(validationTest==2){
				 	 

					String key =genericSignalSpaimKey(molecule_id, rev, signal_id);
					
					if( this.genericSignalSpaimMap.containsKey(key)){
						 
					}else{
						
						
						GenericSignalSpaim gss = new GenericSignalSpaim(
								signal_id, molecule_id, role_id);
						gss.setDebug(dg);
						this.genericSignalSpaimMap.put(key, gss);
					
						
						persistGss(conn, gss);
						
		 //FM 0 2020
						
			f.setExport(true);
			s.setExport(true);
			e.setExport(true);
		//
							
					}
					
					/*
					 * 
				 	
					"When at least one of the species-specific reactions was indicated as reversible, the unified generic reaction was
					 then considered as reversible. Some molecules could be considered as not limiting
						and highly generic in many reactions, so they were removed from the reaction sets:
						 ATP, ADP, NTP, NDP, protein remnants, phosphate, Coenzyme A, water and H+."
					 *
					 */
					 
					int eqCode=0;
					if(rev!=null){
						 if(rev.equals(REVERSIBLE_VALUE)){
							 
							 eqCode=2; //r
						 }else if(rev.equals(IRREVERSIBLE_VALUE)){
							 
							 eqCode=1; //i
						 }
					 }
					 if(equilMap.containsKey(signal_id)){
						 int eqCodePred= equilMap.get(signal_id);
						 if(eqCodePred==2){
							 // former r "overread" i 
						 }
						 else if(eqCodePred==1 && eqCode==2){
							 // new r "overread" i
							 equilMap.put(signal_id, eqCode);
						 }
					 }else{
						 equilMap.put(signal_id, eqCode);
					 }
					
					 
	
					
				}else{
					LogUtils.info("**WARNING** unexpected edge pairs for spaim db "+e);
				}
				
				 
			}
		
		}
		
		for(String signal_id : equilMap.keySet() ){
			String equilibrium_id=null;//i|r
			Integer eqCode=equilMap.get(signal_id);
			if(eqCode==2){
				 equilibrium_id="r";
				  
			 }else if(eqCode==1){
				 equilibrium_id="i";
				 
			 }
			GenericSignal si = new GenericSignal(signal_id, equilibrium_id, DEFAULT_DB_ALIAS, signal_id);
			si.setDebug("");
			persistGs(conn, si);
		}
	 
		
		if(conn!=null){
			conn.close();
		}
	 
		if(doHub ==true){
			   writeHubToFile();
			   writeLoessDataToFile();

		}
	}


	private void writeLoessDataToFile() {
	
		String bn = FilenameUtils.getBaseName(hubFile);
		File rf = new File(hubFile);
		String spa="";
		if(rf.getParent()!=null){
			spa=rf.getParent()+"/";
		}
		File f = new File(spa+bn+"_loess.txt");

			Writer writer = null;
			
			try {
			    writer = new BufferedWriter(new OutputStreamWriter(  new FileOutputStream(f), "utf-8"));
			    HashMap <Integer,Integer> sumMap=new HashMap<Integer,Integer>();
			    ArrayList<Pair<Object>> countEntCon = new ArrayList<Pair<Object>>();
			    
			    for(String key:hubMap.keySet()){
			    	Pair<Object> p = hubMap.get(key);
			    	 
			    	Integer countCon=(Integer) p.getFirst();
			    	  
			    	Integer entityNb=0;
			    	if(sumMap.containsKey(countCon)){
			    		entityNb=sumMap.get(countCon);
			    	}
			    	entityNb++;
			    	sumMap.put(countCon, entityNb);
					
			    	Pair<Object> sp = new Pair<Object>(countCon,entityNb);
					countEntCon.add(sp);
			    	
			    }
			   
			    Collections.sort(countEntCon, new Comparator<Pair<Object>>() {
			        @Override
			        public int compare(Pair<Object> o1, Pair<Object> o2) {
			            return ((Integer) o2.getFirst()).compareTo( (Integer) o1.getFirst() );
			        }
			    });
			    writer.write("countCon\tentityNb\n");
			    for(Pair<Object> p:countEntCon){
		
			    	String line = p.getFirst()+"\t"+p.getSecond()+"\n";
			    	
					writer.write(line);
			 
			    	
			    }
			    
			    
			    
			} catch (IOException ex) {
			 	ex.printStackTrace();
			} finally {
			   try {writer.close();} catch (Exception ex) {
				   	ex.printStackTrace();
			   }
			}
	}
	
	
	
	private void writeHubToFile() {
		File f = new File(hubFile );

			Writer writer = null;
			
			try {
			    writer = new BufferedWriter(new OutputStreamWriter(  new FileOutputStream(f), "utf-8"));
			    
			    ArrayList<Pair<Object>> hubLines = new ArrayList<Pair<Object>>();
			    
			    for(String key:hubMap.keySet()){
			    	Pair<Object> p = hubMap.get(key);
			    	 
			    	Integer count=(Integer) p.getFirst();
			    	String mid=(String) p.getSecond();
			    	String line = "Transpath\t"+mid+"\t#"+key+"\t"+count+"\n";
					 
					Pair<Object> sp = new Pair<Object>(count,line);
					hubLines.add(sp);
			    	
			    }
			   
			    Collections.sort(hubLines, new Comparator<Pair<Object>>() {
			        @Override
			        public int compare(Pair<Object> o1, Pair<Object> o2) {
			            return ((Integer) o2.getFirst()).compareTo( (Integer) o1.getFirst() );
			        }
			    });
			    for(Pair<Object> p:hubLines){
			    	
			    	//Transpath	MO000045127 # nucleophosmin(h) 22
		 
			    	String line = (String) p.getSecond();
					writer.write(line);
			    	
			    }
			    
			    
			    
			} catch (IOException ex) {
			 	ex.printStackTrace();
			} finally {
			   try {writer.close();} catch (Exception ex) {
				   	ex.printStackTrace();
			   }
			}
	}
	private void computeHubMap(String key, DirectedSparseMultigraph<SpaimNode, SpaimEdge> jg, SpaimNode v, DBMolecule m) throws Exception {
		
		
		Integer count = 0;
	 
		// LogUtils.info(v+""+key+""+m.getName());
		if(hubMap.containsKey(key)){
			Pair<Object> pa =hubMap.get(key);
			count=(Integer) pa.getFirst();
		}
		Collection<SpaimNode> nd = jg.getNeighbors(v);
		for(SpaimNode n:nd){
			//n.getBiopaxType()
			
			BioPAXElement be = n.getElement();
			if (be.getClass().isAssignableFrom(Interaction.class) || be instanceof Interaction ){
				String k2 = key+"|"+be.getUri();
				//all edges mol->react with no duplicates
				if(!taggedEdgeMap.contains(k2)){
					taggedEdgeMap.add(k2);
					count=count+1;	
				}
				
				
			}
	
		}
		//Transpath	MO000045127 # nucleophosmin(h) 22
		Pair<Object> p =new Pair<Object>(count,m.getMolecule_id());
		
		hubMap.put(key, p);
		
	}
	
	
	
	
	protected static String formatEntityName(String name) {
		
		if(name.equals("PI")){
			name="phosphatidylinositol";
		}
		else if(name.equals("Pi")){
			name="phosphate(3-)";
		}
		else if(name.contains("copied")){
			name=removeNameCopiedSuffix(name); 
		}
		
		return name;
	}
	
	private String genericSignalSpaimKey(String molecule_id, String rev, String signal_id) {
		String id= signal_id+"|"+molecule_id+"|"+rev;
		
		return id;
	}
	private String reactionKey(String effect, String reversible, String reaction_description) {
		return genericSignalSpaimKey(effect, reaction_description, reversible);
	}
	protected static String moleculeKey(String type_of_molecule, String name) {
		name=name.trim();
		name=name.toLowerCase();
		String id=  type_of_molecule+"|"+name;
		
		return id;
	}
	
	private static String removeNameCopiedSuffix(String s) {
		Pattern p = Pattern.compile("(.*)\\(name copied.*");
		 Matcher m = p.matcher(s);
		 boolean b = m.matches();
		 String id=s;
		 if(b) {
			 id=m.group(1);
			 id=id.trim();
		 }
		return id;
	}
	
	//delete all TRUNCATE
	
 

	

	
	
}
