package dyliss.biopax.db;

public class DBReaction extends DBTuple  {
	
 
	public static   String TABLE_NAME = "transpath_reaction";
	private String reaction_id; 
	private String level 	;
	private String reversible 	;
	private String effect ;
	private  String reaction_description ;
  	private String biopaxtype;
  	
  	
	public String getBiopaxtype() {
		return biopaxtype;
	}
	public void setBiopaxtype(String biopaxtype) {
		this.biopaxtype = biopaxtype;
	}
	
	
	public String getUri() {
		return uri;
	}
	public void setUri(String uri) {
		this.uri = uri;
	}
	public String getDatasource() {
		return datasource;
	}
	public void setDatasource(String datasource) {
		this.datasource = datasource;
	}
	private String uri ;
	private String datasource ;
	
	public DBReaction(String reaction_id, String level, String reversible, String effect,
			String reaction_description) {
		super();
		this.reaction_id = reaction_id;
		this.level = level;
		this.reversible = reversible;
		this.effect = effect;
		this.reaction_description = reaction_description;
		 
	}
	public String getReaction_id() {
		return reaction_id;
	}
	public void setReaction_id(String reaction_id) {
		this.reaction_id = reaction_id;
	}
	public String getLevel() {
		return level;
	}
	public void setLevel(String level) {
		this.level = level;
	}
	public String getReversible() {
		return reversible;
	}
	public void setReversible(String reversible) {
		this.reversible = reversible;
	}
	public String getEffect() {
		return effect;
	}
	public void setEffect(String effect) {
		this.effect = effect;
	}
	public String getReaction_description() {
		return reaction_description;
	}
	public void setReaction_description(String reaction_description) {
		this.reaction_description = reaction_description;
	}
	 
	 
	public String toString() {
		return String.format(
				"TranspathReaction [reaction_id=%s, level=%s, reversible=%s, effect=%s, reaction_description=%s]",
				reaction_id, level, reversible, effect, reaction_description);
	}
	@Override
	public String insertQuery() {
 /*
  * example 
  INSERT INTO `transpath_reaction` (`reaction_id`, `level`, `reversible`, `effect`, `reaction_description`) VALUES
('XN000000003', 'mechanistic', 'reversible', 'EFFECT_NOT_DEFINED', 'Grb-2 + Sos <==> Grb-2:Sos');
  */
		String sql=String.format("INSERT INTO `"+TABLE_NAME+"` (`reaction_id`, `level`, `reversible`, `effect`, `reaction_description`, `debug`, `uri`, `datasource`, `biopaxtype`)"+
  " VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s');" , esc(reaction_id), esc(level), esc(reversible),esc(effect),
    esc(reaction_description), esc(debug), esc(uri), esc(datasource), esc(biopaxtype));
		return sql;
	}
	@Override
	public String createTableQuery() {
		String sql="";

		sql+=" DROP TABLE IF EXISTS `"+TABLE_NAME+"`;";
		sql+=" CREATE TABLE IF NOT EXISTS `"+TABLE_NAME+"` (";
		sql+="   `reaction_id` char(250) NOT NULL DEFAULT '',";
		sql+="   `level` text,";
		sql+="   `reversible` text,";
		sql+="   `effect` text,";
		sql+="   `reaction_description` text,";
		sql+="  `debug` text,"; 
		sql+="  `uri` char(250),";
		sql+="  `datasource` char(250),"; 
		sql+="  `biopaxtype` char(250),"; 
		sql+="   PRIMARY KEY (`reaction_id`)";
		sql+=" ) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		
		
		
		return sql;
	}
 
}
