package dyliss.biopax.app;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;

import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;

import dyliss.biopax.GraphConfig;
import dyliss.biopax.db.DBMolecule;
import dyliss.biopax.db.DBReaction;
import dyliss.biopax.util.LogUtils;

public class Alias2MoleculeDBMerger  extends SpaimDB2GTool{

	static final String VERSION="1.2";
	
	public Alias2MoleculeDBMerger(GraphConfig graphConfig) {
		super(graphConfig);
		 
	}

	public static void main(String[] args) throws Exception {
		 LogUtils.info(Alias2MoleculeDBMerger.class.getName());
		 LogUtils.info("version:"+VERSION);
		 LogUtils.info("start:Alias2MoleculeDBMerger");
		
		 String propFilePath= "graphconf.properties";
		 File molAliasFile = new File("mol-alias.txt");
		 if(args!=null && args.length>0){
			
			 propFilePath = args[0];
			 
			if( args.length>1){
				 
				 molAliasFile = new File(args[1]);
 
				}
		}
		
		  
		  GraphConfig gc = new GraphConfig(propFilePath);
 
		  Alias2MoleculeDBMerger amdb = new Alias2MoleculeDBMerger(gc);
		  Connection conn=amdb.connect();
 
		  amdb.mergeDBMolAlias( conn,molAliasFile);
/*
 * update generic_signal_spaim s set s.molecule_id='MO000015208' WHERE  
 *  s.molecule_id='MO000011580'
Exception in thread "main" com.mysql.jdbc.exceptions.
jdbc4.MySQLIntegrityConstraintViolationException:
 Duplicate entry 'XN000075467-MO000015208-p' for key 'PRIMARY'

 */
		          
	}
	
	
	public void mergeDBMolAlias( Connection conn,File molAliasFile) 
			throws Exception, SQLException {
		
 
		
		//convert to left join to enable molecule as  singleton
		List<String> lines = FileUtils.readLines(molAliasFile, "UTF-8");
		
		for(String l:lines){
			ArrayList<String> molAliases = new  ArrayList<String>();
			ArrayList<DBMolecule> molAl = new  ArrayList<DBMolecule>();
			String[] sp = l.split(";");
		    
			for(String s:sp){
				s=s.trim();
				if(!s.equals("")){
					molAliases.add(s);
					
				}
			}
			int i=0; 
			String refname=null;
			for(String molname:molAliases){
			    
				molname= molname.toLowerCase();
				if(i==0){
					refname=molname;
				}
				String sqlstart = "";
				i++;
				
				 sqlstart = "select "
							+ " m.molecule_id,  "+
							" m.type_of_molecule,m.name,m.debug  "+
							  " from  transpath_molecule m"
							  + " WHERE  LOWER(m.name)='"+molname+"'";
		 
				ResultSet rs1= executeSelectQuery(  sqlstart,   conn);
			
				while (rs1.next()) {
				   
				  String molecule_id = rs1.getString(1);
				  String type_of_molecule=rs1.getString(2);
				  String namem=rs1.getString(3);
	 
				  String debugm=rs1.getString(4);
				  
				  DBMolecule m1 = new DBMolecule(molecule_id, type_of_molecule, namem);
				  m1.setDebug(debugm);
				  molAl.add(m1);
				   LogUtils.info(String.format(" %s %s %s %s",molecule_id,namem,type_of_molecule,debugm));
		
			
			  }
			}
			if(refname!=null){
				DBMolecule refm= molAl.get(0); 

				int j=0;
				for(DBMolecule m : molAl){
					if(j!=0){
						// delete
						 LogUtils.info(m.getMolecule_id());
						//update references
						String sql1 = "update generic_signal_spaim s "
								+ "set s.molecule_id="
								+ "'"+refm.getMolecule_id()+"'"
								  + " WHERE   s.molecule_id='"
								  +m.getMolecule_id()+"'";
									 LogUtils.info(sql1);
						 try{ 
							 execute(  sql1,   conn);
							 
						 }catch(MySQLIntegrityConstraintViolationException ex){
							 ex.printStackTrace();
							  LogUtils.info("ConstraintViolation - GOING TO REMOVE duplicate reaction");
							 String sql1r = "delete from generic_signal_spaim s "
										+ "where s.molecule_id="
										+ "'"+m.getMolecule_id()+"'";
										  
											 LogUtils.info(sql1r);
											execute(  sql1r,   conn);
						 }
						 
						 
						String sql2="delete from transpath_molecule m where "
								+ "m.molecule_id="
								+ "'"+m.getMolecule_id()+"'";
						 LogUtils.info(sql2);
						 execute(  sql2,   conn);
					}
					j++;
				}
			}
			
			
		}
		
		
		
		

 
	}
}
