package dyliss.biopax;

 

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;

 

 
public class TemplateManager {

 

	private String templateDir;
	private VelocityEngine engine ;

	private static TemplateManager instance;
	
	  public static TemplateManager getInstance(){
			if (instance == null){
				try {
					instance = new TemplateManager();
				} catch (Exception e) {
					 
					e.printStackTrace();
					instance =null;
				}
			}
			return instance;
		}
		
	  
		
		private TemplateManager() throws Exception {
  	
  	
	  super();
	  
 
 

}



		public void init() throws Exception {
			this.engine = new VelocityEngine(); //separate  instance mode: see http://velocity.apache.org/engine/releases/velocity-1.5/developer-guide.html
			 //  Velocity.init(); //singleton mode
			this.setProperties();    
			this.engine.init();
		}

 
 





 



	public void setTemplateDir(String templateDir) {
			this.templateDir = templateDir;
		}



	public   String  evaluateFromTemplate( String templateFile, VelocityContext context)
		throws Exception, IOException {
			Template t = this.engine.getTemplate( templateFile );
			StringWriter writer = new StringWriter();
			t.merge(context, writer );
			//LogUtil.debug("--------populateCommandWrapperFromTemplate---------", this.getClass());
			String s = writer.toString();
			//LogUtil.debug(s, this.getClass());
			//LogUtil.debug("-----------------", this.getClass());
			
			//this.engine.evaluate( context, writer, "log_tag", cmdStr);
			//String s = writer.toString();
			
			return s;
     }

	 
	

	
	private String getTemplateDir() {
	 
			return this.templateDir;
		}




private void setProperties()
{

    File td = new File( getTemplateDir() );
    File templateDirFile=new File(td.getAbsolutePath()) ;
    if ( templateDirFile.isAbsolute() )
    {
   	 
        this.engine.setProperty( "resource.loader", "file" );
        this.engine.setProperty( "file.resource.loader.class","org.apache.velocity.runtime.resource.loader.FileResourceLoader" );
        this.engine.setProperty( "file.resource.loader.path", templateDirFile.toString() );
        this.engine.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
  	      }
    else
    {       }
 }

}
 