package dyliss.biopax;

import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;

public class SpaimEnum {
 
	public static final String substrat="s";//
	public static final String product="p";//
	public static final String activator="a"; //+
	public static final String inhibitor="i"; // -
	public static final String modulator="m";
	public static final String undefined=null;
	
	//manage a & i cases
	public static String controlTypeToSpaimCode(Control control, ControlType controlType){
		String ct=controlType.toString().toUpperCase();
	 
		// activation, inhibition, inhibition-allosteric, inhinition-competitive, inhibition-irreversible,
		//inhibition-noncompetitive, inhibition-other, inhibition-uncompetitive, activation-nonallosteric, activation-allosteric
	 
		
		if( ct.startsWith("ACTIVATION")) {
			return activator;
		}
		else if( ct.startsWith("INHIBITION") ){
			return inhibitor;
		} 
		else{
			
			System.err.println("WARNING: unhandled controlType for control "+control.getDisplayName()+"controlType:"+controlType);
			return undefined;
		}
		 
	}
	
	public static String controlTypeToSpaimCodeValidated(Control control, ControlType controlType){
		if(controlType==null){
			System.err.println("WARNING: null controlType for control "+control.getDisplayName()+"controlType:"+controlType);
			 return undefined;
		 
		}
		String ct=controlTypeToSpaimCode( control, controlType);
		
		return ct;
		
	}
}
