"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class EncodingType(_EncodingType, metaclass=_EncodingTypeEnumTypeWrapper):
    """// Represents a phrase in the text that is a known entity, such as
    // a person, an organization, or location. The API associates information, such
    // as salience and mentions, with entities.
    message Entity {
     // The type of the entity. For most entity types, the associated metadata is a
     // Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`). The table
     // below lists the associated fields for entities that have different
     // metadata.
     enum Type {
       // Unknown
       UNKNOWN = 0;

       // Person
       PERSON = 1;

       // Location
       LOCATION = 2;

       // Organization
       ORGANIZATION = 3;

       // Event
       EVENT = 4;

       // Artwork
       WORK_OF_ART = 5;

       // Consumer product
       CONSUMER_GOOD = 6;

       // Other types of entities
       OTHER = 7;

       // Phone number<br><br>
       // The metadata lists the phone number, formatted according to local
       // convention, plus whichever additional elements appear in the text:<ul>
       // <li><code>number</code> &ndash; the actual number, broken down into
       // sections as per local convention</li> <li><code>national_prefix</code>
       // &ndash; country code, if detected</li> <li><code>area_code</code> &ndash;
       // region or area code, if detected</li> <li><code>extension</code> &ndash;
       // phone extension (to be dialed after connection), if detected</li></ul>
       PHONE_NUMBER = 9;

       // Address<br><br>
       // The metadata identifies the street number and locality plus whichever
       // additional elements appear in the text:<ul>
       // <li><code>street_number</code> &ndash; street number</li>
       // <li><code>locality</code> &ndash; city or town</li>
       // <li><code>street_name</code> &ndash; street/route name, if detected</li>
       // <li><code>postal_code</code> &ndash; postal code, if detected</li>
       // <li><code>country</code> &ndash; country, if detected</li>
       // <li><code>broad_region</code> &ndash; administrative area, such as the
       // state, if detected</li> <li><code>narrow_region</code> &ndash; smaller
       // administrative area, such as county, if detected</li>
       // <li><code>sublocality</code> &ndash; used in Asian addresses to demark a
       // district within a city, if detected</li></ul>
       ADDRESS = 10;

       // Date<br><br>
       // The metadata identifies the components of the date:<ul>
       // <li><code>year</code> &ndash; four digit year, if detected</li>
       // <li><code>month</code> &ndash; two digit month number, if detected</li>
       // <li><code>day</code> &ndash; two digit day number, if detected</li></ul>
       DATE = 11;

       // Number<br><br>
       // The metadata is the number itself.
       NUMBER = 12;

       // Price<br><br>
       // The metadata identifies the <code>value</code> and <code>currency</code>.
       PRICE = 13;
     }

     // The representative name for the entity.
     string name = 1;

     // The entity type.
     Type type = 2;

     // Metadata associated with the entity.
     //
     // For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
     // and Knowledge Graph MID (`mid`), if they are available. For the metadata
     // associated with other entity types, see the Type table below.
     map<string, string> metadata = 3;

     // The salience score associated with the entity in the [0, 1.0] range.
     //
     // The salience score for an entity provides information about the
     // importance or centrality of that entity to the entire document text.
     // Scores closer to 0 are less salient, while scores closer to 1.0 are highly
     // salient.
     float salience = 4;

     // The mentions of this entity in the input document. The API currently
     // supports proper noun mentions.
     repeated EntityMention mentions = 5;

     // For calls to [AnalyzeEntitySentiment][] or if
     // [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entity_sentiment] is set to
     // true, this field will contain the aggregate sentiment expressed for this
     // entity in the provided document.
     Sentiment sentiment = 6;
    }

    Represents the text encoding that the caller uses to process the output.
    Providing an `EncodingType` is recommended because the API provides the
    beginning offsets for various outputs, such as tokens and mentions, and
    languages that natively use different text encodings may access offsets
    differently.
    """
    pass
class _EncodingType:
    V = typing.NewType('V', builtins.int)
class _EncodingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EncodingType.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    NONE = EncodingType.V(0)
    """If `EncodingType` is not specified, encoding-dependent information (such as
    `begin_offset`) will be set at `-1`.
    """

    UTF8 = EncodingType.V(1)
    """Encoding-dependent information (such as `begin_offset`) is calculated based
    on the UTF-8 encoding of the input. C++ and Go are examples of languages
    that use this encoding natively.
    """

    UTF16 = EncodingType.V(2)
    """Encoding-dependent information (such as `begin_offset`) is calculated based
    on the UTF-16 encoding of the input. Java and JavaScript are examples of
    languages that use this encoding natively.
    """

    UTF32 = EncodingType.V(3)
    """Encoding-dependent information (such as `begin_offset`) is calculated based
    on the UTF-32 encoding of the input. Python is an example of a language
    that uses this encoding natively.
    """


NONE = EncodingType.V(0)
"""If `EncodingType` is not specified, encoding-dependent information (such as
`begin_offset`) will be set at `-1`.
"""

UTF8 = EncodingType.V(1)
"""Encoding-dependent information (such as `begin_offset`) is calculated based
on the UTF-8 encoding of the input. C++ and Go are examples of languages
that use this encoding natively.
"""

UTF16 = EncodingType.V(2)
"""Encoding-dependent information (such as `begin_offset`) is calculated based
on the UTF-16 encoding of the input. Java and JavaScript are examples of
languages that use this encoding natively.
"""

UTF32 = EncodingType.V(3)
"""Encoding-dependent information (such as `begin_offset`) is calculated based
on the UTF-32 encoding of the input. Python is an example of a language
that uses this encoding natively.
"""

global___EncodingType = EncodingType


class Document(google.protobuf.message.Message):
    """################################################################ #

    Represents the input to API methods.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CONTENT_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    content: typing.Text = ...
    """The content of the input in string format.
    Cloud audit logging exempt since it is based on user data.
    """

    language: typing.Text = ...
    """The language of the document (if not specified, the language is
    automatically detected). Both ISO and BCP-47 language codes are
    accepted.<br>
    [Language Support](/natural-language/docs/languages)
    lists currently supported languages for each API method.
    If the language (either specified by the caller or automatically detected)
    is not supported by the called API method, an `INVALID_ARGUMENT` error
    is returned.
    """

    def __init__(self,
        *,
        content : typing.Text = ...,
        language : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["content",b"content","language",b"language"]) -> None: ...
global___Document = Document

class Sentence(google.protobuf.message.Message):
    """Represents a sentence in the input document."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TEXT_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    @property
    def text(self) -> global___TextSpan:
        """The sentence text."""
        pass
    @property
    def tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Token]:
        """어절단위로 쪼개는 것은"""
        pass
    def __init__(self,
        *,
        text : typing.Optional[global___TextSpan] = ...,
        tokens : typing.Optional[typing.Iterable[global___Token]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["text",b"text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["text",b"text","tokens",b"tokens"]) -> None: ...
global___Sentence = Sentence

class Morpheme(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class OutOfVocab(_OutOfVocab, metaclass=_OutOfVocabEnumTypeWrapper):
        """사전에 없는 단어 정보 처리 결과"""
        pass
    class _OutOfVocab:
        V = typing.NewType('V', builtins.int)
    class _OutOfVocabEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OutOfVocab.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        IN_WORD_EMBEDDING = Morpheme.OutOfVocab.V(0)
        """워드임베딩에 포함된 내용"""

        OUT_OF_VOCAB = Morpheme.OutOfVocab.V(1)
        """자동 추측"""

        IN_CUSTOM_DICT = Morpheme.OutOfVocab.V(2)
        """사용자 제공 사전에 있는 내용"""

        IN_BUILTIN_DICT = Morpheme.OutOfVocab.V(3)
        """기본 사전에 포함된 내용"""


    IN_WORD_EMBEDDING = Morpheme.OutOfVocab.V(0)
    """워드임베딩에 포함된 내용"""

    OUT_OF_VOCAB = Morpheme.OutOfVocab.V(1)
    """자동 추측"""

    IN_CUSTOM_DICT = Morpheme.OutOfVocab.V(2)
    """사용자 제공 사전에 있는 내용"""

    IN_BUILTIN_DICT = Morpheme.OutOfVocab.V(3)
    """기본 사전에 포함된 내용"""


    class Tag(_Tag, metaclass=_TagEnumTypeWrapper):
        """내부적으로 pred 된 형태소는 0~42까지 반환하지만,
        1~43까지 숫자로 쓰고, UNK은 0으로 바꾼다.
        """
        pass
    class _Tag:
        V = typing.NewType('V', builtins.int)
    class _TagEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Tag.V], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
        UNK = Morpheme.Tag.V(0)
        """// 0 1 EC
        // 1 2 EF
        // 2 3 EP
        // 3 4 ETM
        // 4 5 ETN
        // 5 6 IC
        // 6 7 JC
        // 7 8 JKB
        // 8 9 JKC
        // 9 10 JKG
        // 10 11 JKO
        // 11 12 JKQ
        // 12 13 JKS
        // 13 14 JKV
        // 14 15 JX
        // 15 16 MAG
        // 16 17 MAJ
        // 17 18 MMA
        // 18 19 MMD
        // 19 20 MMN
        // 20 21 NA
        // 21 22 NF
        // 22 23 NNB
        // 23 24 NNG
        // 24 25 NNP
        // 25 26 NP
        // 26 27 NR
        // 27 28 NV
        // 28 29 SE
        // 29 30 SF
        // 30 31 SH
        // 31 32 SL
        // 32 33 SN
        // 33 34 SO
        // 34 35 SP
        // 35 36 SS
        // 36 37 SW
        // 37 38 VA
        // 38 39 VCN
        // 39 40 VCP
        // 40 41 VV
        // 41 42 VX
        // 42 43 XPN
        // 43 44 XR
        // 44 45 XSA
        // 45 46 XSN
        // 46 47 XSV
        """

        NNG = Morpheme.Tag.V(24)
        """일반 명사"""

        NNP = Morpheme.Tag.V(25)
        """고유 명사"""

        NNB = Morpheme.Tag.V(23)
        """의존 명사"""

        NP = Morpheme.Tag.V(26)
        """대명사"""

        NR = Morpheme.Tag.V(27)
        """수사"""

        NF = Morpheme.Tag.V(22)
        """명사 추정 범주"""

        NA = Morpheme.Tag.V(21)
        """분석불능범주"""

        NV = Morpheme.Tag.V(28)
        """용언 추정 범주"""

        VV = Morpheme.Tag.V(41)
        """동사"""

        VA = Morpheme.Tag.V(38)
        """형용사"""

        VX = Morpheme.Tag.V(42)
        """보조 용언"""

        VCP = Morpheme.Tag.V(40)
        """긍정 지정사"""

        VCN = Morpheme.Tag.V(39)
        """부정 지정사"""

        MMA = Morpheme.Tag.V(18)
        """성상 관형사"""

        MMD = Morpheme.Tag.V(19)
        """지시 관형사"""

        MMN = Morpheme.Tag.V(20)
        """수 관형사"""

        MAG = Morpheme.Tag.V(16)
        """일반 부사"""

        MAJ = Morpheme.Tag.V(17)
        """접속 부사"""

        IC = Morpheme.Tag.V(6)
        """감탄사"""

        JKS = Morpheme.Tag.V(13)
        """주격 조사"""

        JKC = Morpheme.Tag.V(9)
        """보격 조사"""

        JKG = Morpheme.Tag.V(10)
        """관형격 조사"""

        JKO = Morpheme.Tag.V(11)
        """목적격 조사"""

        JKB = Morpheme.Tag.V(8)
        """부사격 조사"""

        JKV = Morpheme.Tag.V(14)
        """호격 조사"""

        JKQ = Morpheme.Tag.V(12)
        """인용격 조사"""

        JX = Morpheme.Tag.V(15)
        """보조사"""

        JC = Morpheme.Tag.V(7)
        """접속 조사"""

        EP = Morpheme.Tag.V(3)
        """선어말 어미"""

        EF = Morpheme.Tag.V(2)
        """종결 어미"""

        EC = Morpheme.Tag.V(1)
        """연결 어미"""

        ETN = Morpheme.Tag.V(5)
        """명사형 전성 어미"""

        ETM = Morpheme.Tag.V(4)
        """관형형 전성 어미"""

        XPN = Morpheme.Tag.V(43)
        """체언 접두사"""

        XSN = Morpheme.Tag.V(46)
        """명사 파생 접미사"""

        XSV = Morpheme.Tag.V(47)
        """동사 파생 접미사"""

        XSA = Morpheme.Tag.V(45)
        """형용사 파생 접미사"""

        XR = Morpheme.Tag.V(44)
        """어근"""

        SF = Morpheme.Tag.V(30)
        """마침표,물음표,느낌표"""

        SP = Morpheme.Tag.V(35)
        """쉼표,가운뎃점,콜론,빗금"""

        SS = Morpheme.Tag.V(36)
        """따옴표,괄호표,줄표"""

        SE = Morpheme.Tag.V(29)
        """줄임표"""

        SO = Morpheme.Tag.V(34)
        """붙임표(물결,숨김,빠짐)"""

        SW = Morpheme.Tag.V(37)
        """기타기호 (논리수학기호,화폐기호)"""

        SL = Morpheme.Tag.V(32)
        """외국어"""

        SH = Morpheme.Tag.V(31)
        """한자"""

        SN = Morpheme.Tag.V(33)
        """숫자"""


    UNK = Morpheme.Tag.V(0)
    """// 0 1 EC
    // 1 2 EF
    // 2 3 EP
    // 3 4 ETM
    // 4 5 ETN
    // 5 6 IC
    // 6 7 JC
    // 7 8 JKB
    // 8 9 JKC
    // 9 10 JKG
    // 10 11 JKO
    // 11 12 JKQ
    // 12 13 JKS
    // 13 14 JKV
    // 14 15 JX
    // 15 16 MAG
    // 16 17 MAJ
    // 17 18 MMA
    // 18 19 MMD
    // 19 20 MMN
    // 20 21 NA
    // 21 22 NF
    // 22 23 NNB
    // 23 24 NNG
    // 24 25 NNP
    // 25 26 NP
    // 26 27 NR
    // 27 28 NV
    // 28 29 SE
    // 29 30 SF
    // 30 31 SH
    // 31 32 SL
    // 32 33 SN
    // 33 34 SO
    // 34 35 SP
    // 35 36 SS
    // 36 37 SW
    // 37 38 VA
    // 38 39 VCN
    // 39 40 VCP
    // 40 41 VV
    // 41 42 VX
    // 42 43 XPN
    // 43 44 XR
    // 44 45 XSA
    // 45 46 XSN
    // 46 47 XSV
    """

    NNG = Morpheme.Tag.V(24)
    """일반 명사"""

    NNP = Morpheme.Tag.V(25)
    """고유 명사"""

    NNB = Morpheme.Tag.V(23)
    """의존 명사"""

    NP = Morpheme.Tag.V(26)
    """대명사"""

    NR = Morpheme.Tag.V(27)
    """수사"""

    NF = Morpheme.Tag.V(22)
    """명사 추정 범주"""

    NA = Morpheme.Tag.V(21)
    """분석불능범주"""

    NV = Morpheme.Tag.V(28)
    """용언 추정 범주"""

    VV = Morpheme.Tag.V(41)
    """동사"""

    VA = Morpheme.Tag.V(38)
    """형용사"""

    VX = Morpheme.Tag.V(42)
    """보조 용언"""

    VCP = Morpheme.Tag.V(40)
    """긍정 지정사"""

    VCN = Morpheme.Tag.V(39)
    """부정 지정사"""

    MMA = Morpheme.Tag.V(18)
    """성상 관형사"""

    MMD = Morpheme.Tag.V(19)
    """지시 관형사"""

    MMN = Morpheme.Tag.V(20)
    """수 관형사"""

    MAG = Morpheme.Tag.V(16)
    """일반 부사"""

    MAJ = Morpheme.Tag.V(17)
    """접속 부사"""

    IC = Morpheme.Tag.V(6)
    """감탄사"""

    JKS = Morpheme.Tag.V(13)
    """주격 조사"""

    JKC = Morpheme.Tag.V(9)
    """보격 조사"""

    JKG = Morpheme.Tag.V(10)
    """관형격 조사"""

    JKO = Morpheme.Tag.V(11)
    """목적격 조사"""

    JKB = Morpheme.Tag.V(8)
    """부사격 조사"""

    JKV = Morpheme.Tag.V(14)
    """호격 조사"""

    JKQ = Morpheme.Tag.V(12)
    """인용격 조사"""

    JX = Morpheme.Tag.V(15)
    """보조사"""

    JC = Morpheme.Tag.V(7)
    """접속 조사"""

    EP = Morpheme.Tag.V(3)
    """선어말 어미"""

    EF = Morpheme.Tag.V(2)
    """종결 어미"""

    EC = Morpheme.Tag.V(1)
    """연결 어미"""

    ETN = Morpheme.Tag.V(5)
    """명사형 전성 어미"""

    ETM = Morpheme.Tag.V(4)
    """관형형 전성 어미"""

    XPN = Morpheme.Tag.V(43)
    """체언 접두사"""

    XSN = Morpheme.Tag.V(46)
    """명사 파생 접미사"""

    XSV = Morpheme.Tag.V(47)
    """동사 파생 접미사"""

    XSA = Morpheme.Tag.V(45)
    """형용사 파생 접미사"""

    XR = Morpheme.Tag.V(44)
    """어근"""

    SF = Morpheme.Tag.V(30)
    """마침표,물음표,느낌표"""

    SP = Morpheme.Tag.V(35)
    """쉼표,가운뎃점,콜론,빗금"""

    SS = Morpheme.Tag.V(36)
    """따옴표,괄호표,줄표"""

    SE = Morpheme.Tag.V(29)
    """줄임표"""

    SO = Morpheme.Tag.V(34)
    """붙임표(물결,숨김,빠짐)"""

    SW = Morpheme.Tag.V(37)
    """기타기호 (논리수학기호,화폐기호)"""

    SL = Morpheme.Tag.V(32)
    """외국어"""

    SH = Morpheme.Tag.V(31)
    """한자"""

    SN = Morpheme.Tag.V(33)
    """숫자"""


    TEXT_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    PROBABILITY_FIELD_NUMBER: builtins.int
    DISAMBIGUATION_FIELD_NUMBER: builtins.int
    OUT_OF_VOCAB_FIELD_NUMBER: builtins.int
    @property
    def text(self) -> global___TextSpan:
        """The sentence text."""
        pass
    tag: global___Morpheme.Tag.V = ...
    """형태소 태그"""

    probability: builtins.float = ...
    """형태소 분석 결과 확률"""

    disambiguation: builtins.int = ...
    """유의어 번호"""

    out_of_vocab: global___Morpheme.OutOfVocab.V = ...
    """사전에 없는 단어 표시"""

    def __init__(self,
        *,
        text : typing.Optional[global___TextSpan] = ...,
        tag : global___Morpheme.Tag.V = ...,
        probability : builtins.float = ...,
        disambiguation : builtins.int = ...,
        out_of_vocab : global___Morpheme.OutOfVocab.V = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["text",b"text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["disambiguation",b"disambiguation","out_of_vocab",b"out_of_vocab","probability",b"probability","tag",b"tag","text",b"text"]) -> None: ...
global___Morpheme = Morpheme

class Token(google.protobuf.message.Message):
    """Represents the smallest syntactic building block of the text.
    어절
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TEXT_FIELD_NUMBER: builtins.int
    MORPHEMES_FIELD_NUMBER: builtins.int
    LEMMA_FIELD_NUMBER: builtins.int
    TAGGED_FIELD_NUMBER: builtins.int
    @property
    def text(self) -> global___TextSpan:
        """The token text."""
        pass
    @property
    def morphemes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Morpheme]:
        """어절 내부의 형태소 분리"""
        pass
    lemma: typing.Text = ...
    """어절 단위로
    Parts of speech tag for this token.
    PartOfSpeech part_of_speech = 2;

    의존구문 분석
    유의어 분석
    Dependency tree parse for this token.
    DependencyEdge dependency_edge = 3;

    [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
    """

    tagged: typing.Text = ...
    def __init__(self,
        *,
        text : typing.Optional[global___TextSpan] = ...,
        morphemes : typing.Optional[typing.Iterable[global___Morpheme]] = ...,
        lemma : typing.Text = ...,
        tagged : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["text",b"text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["lemma",b"lemma","morphemes",b"morphemes","tagged",b"tagged","text",b"text"]) -> None: ...
global___Token = Token

class TextSpan(google.protobuf.message.Message):
    """// Represents the feeling associated with the entire text or entities in
    // the text.
    message Sentiment {
     // A non-negative number in the [0, +inf) range, which represents
     // the absolute magnitude of sentiment regardless of score (positive or
     // negative).
     float magnitude = 2;

     // Sentiment score between -1.0 (negative sentiment) and 1.0
     // (positive sentiment).
     float score = 3;
    }

    // Represents part of speech information for a token. Parts of speech
    // are as defined in
    // http://www.lrec-conf.org/proceedings/lrec2012/pdf/274_Paper.pdf
    message PartOfSpeech {
     // The part of speech tags enum.
     enum Tag {
       // Unknown
       UNKNOWN = 0;

       // Adjective
       ADJ = 1;

       // Adposition (preposition and postposition)
       ADP = 2;

       // Adverb
       ADV = 3;

       // Conjunction
       CONJ = 4;

       // Determiner
       DET = 5;

       // Noun (common and proper)
       NOUN = 6;

       // Cardinal number
       NUM = 7;

       // Pronoun
       PRON = 8;

       // Particle or other function word
       PRT = 9;

       // Punctuation
       PUNCT = 10;

       // Verb (all tenses and modes)
       VERB = 11;

       // Other: foreign words, typos, abbreviations
       X = 12;

       // Affix
       AFFIX = 13;
     }

     // The characteristic of a verb that expresses time flow during an event.
     enum Aspect {
       // Aspect is not applicable in the analyzed language or is not predicted.
       ASPECT_UNKNOWN = 0;

       // Perfective
       PERFECTIVE = 1;

       // Imperfective
       IMPERFECTIVE = 2;

       // Progressive
       PROGRESSIVE = 3;
     }

     // The grammatical function performed by a noun or pronoun in a phrase,
     // clause, or sentence. In some languages, other parts of speech, such as
     // adjective and determiner, take case inflection in agreement with the noun.
     enum Case {
       // Case is not applicable in the analyzed language or is not predicted.
       CASE_UNKNOWN = 0;

       // Accusative
       ACCUSATIVE = 1;

       // Adverbial
       ADVERBIAL = 2;

       // Complementive
       COMPLEMENTIVE = 3;

       // Dative
       DATIVE = 4;

       // Genitive
       GENITIVE = 5;

       // Instrumental
       INSTRUMENTAL = 6;

       // Locative
       LOCATIVE = 7;

       // Nominative
       NOMINATIVE = 8;

       // Oblique
       OBLIQUE = 9;

       // Partitive
       PARTITIVE = 10;

       // Prepositional
       PREPOSITIONAL = 11;

       // Reflexive
       REFLEXIVE_CASE = 12;

       // Relative
       RELATIVE_CASE = 13;

       // Vocative
       VOCATIVE = 14;
     }

     // Depending on the language, Form can be categorizing different forms of
     // verbs, adjectives, adverbs, etc. For example, categorizing inflected
     // endings of verbs and adjectives or distinguishing between short and long
     // forms of adjectives and participles
     enum Form {
       // Form is not applicable in the analyzed language or is not predicted.
       FORM_UNKNOWN = 0;

       // Adnomial
       ADNOMIAL = 1;

       // Auxiliary
       AUXILIARY = 2;

       // Complementizer
       COMPLEMENTIZER = 3;

       // Final ending
       FINAL_ENDING = 4;

       // Gerund
       GERUND = 5;

       // Realis
       REALIS = 6;

       // Irrealis
       IRREALIS = 7;

       // Short form
       SHORT = 8;

       // Long form
       LONG = 9;

       // Order form
       ORDER = 10;

       // Specific form
       SPECIFIC = 11;
     }

     // Gender classes of nouns reflected in the behaviour of associated words.
     enum Gender {
       // Gender is not applicable in the analyzed language or is not predicted.
       GENDER_UNKNOWN = 0;

       // Feminine
       FEMININE = 1;

       // Masculine
       MASCULINE = 2;

       // Neuter
       NEUTER = 3;
     }

     // The grammatical feature of verbs, used for showing modality and attitude.
     enum Mood {
       // Mood is not applicable in the analyzed language or is not predicted.
       MOOD_UNKNOWN = 0;

       // Conditional
       CONDITIONAL_MOOD = 1;

       // Imperative
       IMPERATIVE = 2;

       // Indicative
       INDICATIVE = 3;

       // Interrogative
       INTERROGATIVE = 4;

       // Jussive
       JUSSIVE = 5;

       // Subjunctive
       SUBJUNCTIVE = 6;
     }

     // Count distinctions.
     enum Number {
       // Number is not applicable in the analyzed language or is not predicted.
       NUMBER_UNKNOWN = 0;

       // Singular
       SINGULAR = 1;

       // Plural
       PLURAL = 2;

       // Dual
       DUAL = 3;
     }

     // The distinction between the speaker, second person, third person, etc.
     enum Person {
       // Person is not applicable in the analyzed language or is not predicted.
       PERSON_UNKNOWN = 0;

       // First
       FIRST = 1;

       // Second
       SECOND = 2;

       // Third
       THIRD = 3;

       // Reflexive
       REFLEXIVE_PERSON = 4;
     }

     // This category shows if the token is part of a proper name.
     enum Proper {
       // Proper is not applicable in the analyzed language or is not predicted.
       PROPER_UNKNOWN = 0;

       // Proper
       PROPER = 1;

       // Not proper
       NOT_PROPER = 2;
     }

     // Reciprocal features of a pronoun.
     enum Reciprocity {
       // Reciprocity is not applicable in the analyzed language or is not
       // predicted.
       RECIPROCITY_UNKNOWN = 0;

       // Reciprocal
       RECIPROCAL = 1;

       // Non-reciprocal
       NON_RECIPROCAL = 2;
     }

     // Time reference.
     enum Tense {
       // Tense is not applicable in the analyzed language or is not predicted.
       TENSE_UNKNOWN = 0;

       // Conditional
       CONDITIONAL_TENSE = 1;

       // Future
       FUTURE = 2;

       // Past
       PAST = 3;

       // Present
       PRESENT = 4;

       // Imperfect
       IMPERFECT = 5;

       // Pluperfect
       PLUPERFECT = 6;
     }

     // The relationship between the action that a verb expresses and the
     // participants identified by its arguments.
     enum Voice {
       // Voice is not applicable in the analyzed language or is not predicted.
       VOICE_UNKNOWN = 0;

       // Active
       ACTIVE = 1;

       // Causative
       CAUSATIVE = 2;

       // Passive
       PASSIVE = 3;
     }

     // The part of speech tag.
     Tag tag = 1;

     // The grammatical aspect.
     Aspect aspect = 2;

     // The grammatical case.
     Case case = 3;

     // The grammatical form.
     Form form = 4;

     // The grammatical gender.
     Gender gender = 5;

     // The grammatical mood.
     Mood mood = 6;

     // The grammatical number.
     Number number = 7;

     // The grammatical person.
     Person person = 8;

     // The grammatical properness.
     Proper proper = 9;

     // The grammatical reciprocity.
     Reciprocity reciprocity = 10;

     // The grammatical tense.
     Tense tense = 11;

     // The grammatical voice.
     Voice voice = 12;
    }

    // Represents dependency parse tree information for a token. (For more
    // information on dependency labels, see
    // http://www.aclweb.org/anthology/P13-2017
    message DependencyEdge {
     // The parse label enum for the token.
     enum Label {
       // Unknown
       UNKNOWN = 0;

       // Abbreviation modifier
       ABBREV = 1;

       // Adjectival complement
       ACOMP = 2;

       // Adverbial clause modifier
       ADVCL = 3;

       // Adverbial modifier
       ADVMOD = 4;

       // Adjectival modifier of an NP
       AMOD = 5;

       // Appositional modifier of an NP
       APPOS = 6;

       // Attribute dependent of a copular verb
       ATTR = 7;

       // Auxiliary (non-main) verb
       AUX = 8;

       // Passive auxiliary
       AUXPASS = 9;

       // Coordinating conjunction
       CC = 10;

       // Clausal complement of a verb or adjective
       CCOMP = 11;

       // Conjunct
       CONJ = 12;

       // Clausal subject
       CSUBJ = 13;

       // Clausal passive subject
       CSUBJPASS = 14;

       // Dependency (unable to determine)
       DEP = 15;

       // Determiner
       DET = 16;

       // Discourse
       DISCOURSE = 17;

       // Direct object
       DOBJ = 18;

       // Expletive
       EXPL = 19;

       // Goes with (part of a word in a text not well edited)
       GOESWITH = 20;

       // Indirect object
       IOBJ = 21;

       // Marker (word introducing a subordinate clause)
       MARK = 22;

       // Multi-word expression
       MWE = 23;

       // Multi-word verbal expression
       MWV = 24;

       // Negation modifier
       NEG = 25;

       // Noun compound modifier
       NN = 26;

       // Noun phrase used as an adverbial modifier
       NPADVMOD = 27;

       // Nominal subject
       NSUBJ = 28;

       // Passive nominal subject
       NSUBJPASS = 29;

       // Numeric modifier of a noun
       NUM = 30;

       // Element of compound number
       NUMBER = 31;

       // Punctuation mark
       P = 32;

       // Parataxis relation
       PARATAXIS = 33;

       // Participial modifier
       PARTMOD = 34;

       // The complement of a preposition is a clause
       PCOMP = 35;

       // Object of a preposition
       POBJ = 36;

       // Possession modifier
       POSS = 37;

       // Postverbal negative particle
       POSTNEG = 38;

       // Predicate complement
       PRECOMP = 39;

       // Preconjunt
       PRECONJ = 40;

       // Predeterminer
       PREDET = 41;

       // Prefix
       PREF = 42;

       // Prepositional modifier
       PREP = 43;

       // The relationship between a verb and verbal morpheme
       PRONL = 44;

       // Particle
       PRT = 45;

       // Associative or possessive marker
       PS = 46;

       // Quantifier phrase modifier
       QUANTMOD = 47;

       // Relative clause modifier
       RCMOD = 48;

       // Complementizer in relative clause
       RCMODREL = 49;

       // Ellipsis without a preceding predicate
       RDROP = 50;

       // Referent
       REF = 51;

       // Remnant
       REMNANT = 52;

       // Reparandum
       REPARANDUM = 53;

       // Root
       ROOT = 54;

       // Suffix specifying a unit of number
       SNUM = 55;

       // Suffix
       SUFF = 56;

       // Temporal modifier
       TMOD = 57;

       // Topic marker
       TOPIC = 58;

       // Clause headed by an infinite form of the verb that modifies a noun
       VMOD = 59;

       // Vocative
       VOCATIVE = 60;

       // Open clausal complement
       XCOMP = 61;

       // Name suffix
       SUFFIX = 62;

       // Name title
       TITLE = 63;

       // Adverbial phrase modifier
       ADVPHMOD = 64;

       // Causative auxiliary
       AUXCAUS = 65;

       // Helper auxiliary
       AUXVV = 66;

       // Rentaishi (Prenominal modifier)
       DTMOD = 67;

       // Foreign words
       FOREIGN = 68;

       // Keyword
       KW = 69;

       // List for chains of comparable items
       LIST = 70;

       // Nominalized clause
       NOMC = 71;

       // Nominalized clausal subject
       NOMCSUBJ = 72;

       // Nominalized clausal passive
       NOMCSUBJPASS = 73;

       // Compound of numeric modifier
       NUMC = 74;

       // Copula
       COP = 75;

       // Dislocated relation (for fronted/topicalized elements)
       DISLOCATED = 76;

       // Aspect marker
       ASP = 77;

       // Genitive modifier
       GMOD = 78;

       // Genitive object
       GOBJ = 79;

       // Infinitival modifier
       INFMOD = 80;

       // Measure
       MES = 81;

       // Nominal complement of a noun
       NCOMP = 82;
     }

     // Represents the head of this token in the dependency tree.
     // This is the index of the token which has an arc going to this token.
     // The index is the position of the token in the array of tokens returned
     // by the API method. If this token is a root token, then the
     // `head_token_index` is its own index.
     int32 head_token_index = 1;

     // The parse label for the token.
     Label label = 2;
    }

    // Represents a mention for an entity in the text. Currently, proper noun
    // mentions are supported.
    message EntityMention {
     // The supported types of mentions.
     enum Type {
       // Unknown
       TYPE_UNKNOWN = 0;

       // Proper name
       PROPER = 1;

       // Common noun (or noun compound)
       COMMON = 2;
     }

     // The mention text.
     TextSpan text = 1;

     // The type of the entity mention.
     Type type = 2;

     // For calls to [AnalyzeEntitySentiment][] or if
     // [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1.AnnotateTextRequest.Features.extract_entity_sentiment] is set to
     // true, this field will contain the sentiment expressed for this mention of
     // the entity in the provided document.
     Sentiment sentiment = 3;
    }

    Represents an output piece of text.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CONTENT_FIELD_NUMBER: builtins.int
    BEGIN_OFFSET_FIELD_NUMBER: builtins.int
    content: typing.Text = ...
    """The content of the output text."""

    begin_offset: builtins.int = ...
    """The API calculates the beginning offset of the content in the original
    document according to the [EncodingType][google.cloud.language.v1.EncodingType] specified in the API request.
    """

    def __init__(self,
        *,
        content : typing.Text = ...,
        begin_offset : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["begin_offset",b"begin_offset","content",b"content"]) -> None: ...
global___TextSpan = TextSpan

class AnalyzeSyntaxRequest(google.protobuf.message.Message):
    """// Represents a category returned from the text classifier.
    message ClassificationCategory {
     // The name of the category representing the document, from the [predefined
     // taxonomy](/natural-language/docs/categories).
     string name = 1;

     // The classifier's confidence of the category. Number represents how certain
     // the classifier is that this category represents the given text.
     float confidence = 2;
    }

    // The sentiment analysis request message.
    message AnalyzeSentimentRequest {
     // Input document.
     Document document = 1;

     // The encoding type used by the API to calculate sentence offsets.
     EncodingType encoding_type = 2;
    }

    // The sentiment analysis response message.
    message AnalyzeSentimentResponse {
     // The overall sentiment of the input document.
     Sentiment document_sentiment = 1;

     // The language of the text, which will be the same as the language specified
     // in the request or, if not specified, the automatically-detected language.
     // See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     string language = 2;

     // The sentiment for all the sentences in the document.
     repeated Sentence sentences = 3;
    }

    // The entity-level sentiment analysis request message.
    message AnalyzeEntitySentimentRequest {
     // Input document.
     Document document = 1;

     // The encoding type used by the API to calculate offsets.
     EncodingType encoding_type = 2;
    }

    // The entity-level sentiment analysis response message.
    message AnalyzeEntitySentimentResponse {
     // The recognized entities in the input document with associated sentiments.
     repeated Entity entities = 1;

     // The language of the text, which will be the same as the language specified
     // in the request or, if not specified, the automatically-detected language.
     // See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     string language = 2;
    }

    // The entity analysis request message.
    message AnalyzeEntitiesRequest {
     // Input document.
     Document document = 1;

     // The encoding type used by the API to calculate offsets.
     EncodingType encoding_type = 2;
    }

    // The entity analysis response message.
    message AnalyzeEntitiesResponse {
     // The recognized entities in the input document.
     repeated Entity entities = 1;

     // The language of the text, which will be the same as the language specified
     // in the request or, if not specified, the automatically-detected language.
     // See [Document.language][google.cloud.language.v1.Document.language] field for more details.
     string language = 2;
    }

    The syntax analysis request message.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DOCUMENT_FIELD_NUMBER: builtins.int
    ENCODING_TYPE_FIELD_NUMBER: builtins.int
    AUTO_SPLIT_SENTENCE_FIELD_NUMBER: builtins.int
    CUSTOM_DOMAIN_FIELD_NUMBER: builtins.int
    @property
    def document(self) -> global___Document:
        """Input document."""
        pass
    encoding_type: global___EncodingType.V = ...
    """The encoding type used by the API to calculate offsets."""

    auto_split_sentence: builtins.bool = ...
    """auto split sentence true이면 자동으로 문장 분리를 시도한다.
    없으면 \\n 을 기준으로 문장을 자른다.
    기본값은 false 이다.
    """

    custom_domain: typing.Text = ...
    """커스텀 사전 도메인 정보
    고유명사, 복합명사 사전에 기반하여 처리함.
    """

    def __init__(self,
        *,
        document : typing.Optional[global___Document] = ...,
        encoding_type : global___EncodingType.V = ...,
        auto_split_sentence : builtins.bool = ...,
        custom_domain : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["document",b"document"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auto_split_sentence",b"auto_split_sentence","custom_domain",b"custom_domain","document",b"document","encoding_type",b"encoding_type"]) -> None: ...
global___AnalyzeSyntaxRequest = AnalyzeSyntaxRequest

class AnalyzeSyntaxResponse(google.protobuf.message.Message):
    """The syntax analysis response message."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SENTENCES_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    @property
    def sentences(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Sentence]:
        """Sentences in the input document."""
        pass
    language: typing.Text = ...
    """Tokens, along with their syntactic information, in the input document.
    repeated Token tokens = 2;

    The language of the text, which will be the same as the language specified
    in the request or, if not specified, the automatically-detected language.
    See [Document.language][google.cloud.language.v1.Document.language] field for more details.
    """

    def __init__(self,
        *,
        sentences : typing.Optional[typing.Iterable[global___Sentence]] = ...,
        language : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language",b"language","sentences",b"sentences"]) -> None: ...
global___AnalyzeSyntaxResponse = AnalyzeSyntaxResponse
