"""
Default mapping between atomic element and potential.

-----------------------------------------------------
Provides dictionaries with mappings element to the default potential.

Currently the default for LDA and PBE GW is included.
"""
DEFAULT_LDA = {
    'Ru': 'Ru_pv',
    'Re': 'Re',
    'Ra': 'Ra_sv',
    'Rb': 'Rb_sv',
    'Rn': 'Rn',
    'Rh': 'Rh_pv',
    'Be': 'Be',
    'Ba': 'Ba_sv',
    'Bi': 'Bi_d',
    'Br': 'Br',
    'H': 'H',
    'P': 'P',
    'Os': 'Os',
    'Hg': 'Hg',
    'Ge': 'Ge_d',
    'Gd': 'Gd_3',
    'Ga': 'Ga_d',
    'Pr': 'Pr_3',
    'Pt': 'Pt',
    'Pu': 'Pu',
    'C': 'C',
    'Pb': 'Pb_d',
    'Pa': 'Pa',
    'Pd': 'Pd',
    'Cd': 'Cd',
    'Po': 'Po_d',
    'Pm': 'Pm_3',
    'Ho': 'Ho_3',
    'Hf': 'Hf_pv',
    'K': 'K_sv',
    'He': 'He',
    'Mg': 'Mg',
    'Mo': 'Mo_sv',
    'Mn': 'Mn_pv',
    'O': 'O',
    'S': 'S',
    'W': 'W_pv',
    'Zn': 'Zn',
    'Eu': 'Eu_2',
    'Zr': 'Zr_sv',
    'Er': 'Er_3',
    'Ni': 'Ni',
    'Na': 'Na_pv',
    'Nb': 'Nb_sv',
    'Nd': 'Nd_3',
    'Ne': 'Ne',
    'Np': 'Np',
    'Fr': 'Fr_sv',
    'Fe': 'Fe',
    'B': 'B',
    'F': 'F',
    'Sr': 'Sr_sv',
    'N': 'N',
    'Kr': 'Kr',
    'Si': 'Si',
    'Sn': 'Sn_d',
    'Sm': 'Sm_3',
    'V': 'V_sv',
    'Sc': 'Sc_sv',
    'Sb': 'Sb',
    'Se': 'Se',
    'Co': 'Co',
    'Cm': 'Cm',
    'Cl': 'Cl',
    'Ca': 'Ca_sv',
    'Ce': 'Ce',
    'Xe': 'Xe',
    'Lu': 'Lu_3',
    'Cs': 'Cs_sv',
    'Cr': 'Cr_pv',
    'Cu': 'Cu',
    'La': 'La',
    'Li': 'Li_sv',
    'Tl': 'Tl_d',
    'Tm': 'Tm_3',
    'Th': 'Th',
    'Ti': 'Ti_sv',
    'Te': 'Te',
    'Tb': 'Tb_3',
    'Tc': 'Tc_pv',
    'Ta': 'Ta_pv',
    'Yb': 'Yb_2',
    'Dy': 'Dy_3',
    'I': 'I',
    'U': 'U',
    'Y': 'Y_sv',
    'Ac': 'Ac',
    'Ag': 'Ag',
    'Ir': 'Ir',
    'Am': 'Am',
    'Al': 'Al',
    'As': 'As',
    'Ar': 'Ar',
    'Au': 'Au',
    'At': 'At_d',
    'In': 'In_d',
}

DEFAULT_GW = {
    'Ni': 'Ni_sv',
    'Pd': 'Pd_sv',
    'Pt': 'Pt',
    'Ru': 'Ru_sv',
    'Na': 'Na_sv',
    'Nb': 'Nb_sv',
    'Mg': 'Mg_sv',
    'Li': 'Li_sv',
    'Pb': 'Pb_d',
    'Y': 'Y_sv',
    'Rb': 'Rb_sv',
    'Ti': 'Ti_sv',
    'Te': 'Te',
    'Rh': 'Rh_sv',
    'Tc': 'Tc_sv',
    'Ta': 'Ta_sv',
    'Be': 'Be_sv',
    'Xe': 'Xe',
    'Ba': 'Ba_sv',
    'Bi': 'Bi_d',
    'Si': 'Si',
    'As': 'As',
    'Fe': 'Fe_sv',
    'Br': 'Br',
    'Sr': 'Sr_sv',
    'Hf': 'Hf_sv',
    'Mo': 'Mo_sv',
    'He': 'He',
    'C': 'C',
    'B': 'B',
    'F': 'F',
    'I': 'I',
    'H': 'H',
    'K': 'K_sv',
    'Mn': 'Mn_sv',
    'O': 'O',
    'Ne': 'Ne',
    'P': 'P',
    'S': 'S',
    'Re': 'Re_sv',
    'Kr': 'Kr',
    'W': 'W_sv',
    'V': 'V_sv',
    'Sc': 'Sc_sv',
    'Sb': 'Sb_d',
    'N': 'N',
    'Os': 'Os_sv',
    'Se': 'Se',
    'Zn': 'Zn',
    'Co': 'Co_sv',
    'Ag': 'Ag',
    'Cl': 'Cl',
    'Ca': 'Ca_sv',
    'Ir': 'Ir_sv',
    'Al': 'Al',
    'Ce': 'Ce',
    'Cd': 'Cd',
    'Ge': 'Ge_d',
    'Ar': 'Ar',
    'Au': 'Au',
    'Zr': 'Zr_sv',
    'Ga': 'Ga_d',
    'In': 'In_d',
    'Cs': 'Cs_sv',
    'Cr': 'Cr_sv',
    'Cu': 'Cu',
    'Sn': 'Sn_d',
}
