# pylint: disable=redefined-builtin, invalid-name
# -*- coding: utf-8 -*-
"""
AiiDA-VASP documentation build configuration file, created by
sphinx-quickstart on Mon Feb 12 09:24:45 2018.

"""
import datetime
import os
import re
import sys

sys.path.insert(0, os.path.abspath('.'))

# -- General configuration ------------------------------------------------

extensions = [
    'sphinx.ext.autodoc', 'sphinx.ext.doctest', 'sphinx.ext.intersphinx', 'sphinx.ext.todo', 'sphinx.ext.coverage',
    'sphinx.ext.mathjax', 'sphinx.ext.viewcode', 'aiida.sphinxext', 'sphinxcontrib.apidoc',
    'sphinxext.remoteliteralinclude'
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'AiiDA-VASP'
copyright = f'{datetime.datetime.now().year}, AiiDA-VASP development team'
author = 'AiiDA_VASP development team'

# The version info for the project you're documenting
release = re.sub('^v', '', os.popen('git describe').read().strip())
version = release

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['tests', 'api']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
on_rtd = os.environ.get('READTHEDOCS') == 'True'
if on_rtd:
    html_theme = 'default'
    from aiida.manage import configuration
    configuration.IN_RT_DOC_MODE = True
    configuration.BACKEND = 'django'
else:
    import sphinx_rtd_theme  # pylint: disable=import-error
    html_theme = 'sphinx_rtd_theme'
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'AiiDA-VASPdoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'AiiDA-VASP.tex', 'AiiDA-VASP Documentation', 'AiiDA-VASP development team', 'manual'),
]

# -- Options for the sphinxcontrib.apidoc extention -----------------------

apidoc_module_dir = '../../src/aiida_vasp'
apidoc_output_dir = 'apidoc'
apidoc_excluded_paths = ['tests', 'test_data']
apidoc_extra_args = ['--no-headings', '--module-first', '--maxdepth', '4']

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, 'aiida-vasp', 'AiiDA-VASP Documentation', [author], 1)]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc, 'AiiDA-VASP', 'AiiDA-VASP Documentation', author, 'AiiDA-VASP',
        'A plugin to enable usage of VASP in the AiiDA workflow engine.', 'Miscellaneous'
    ),
]

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    'python': ('https://docs.python.org/', None),
    'aiida': ('https://aiida.readthedocs.io/projects/aiida-core/en/latest/', None)
}
