# coding: utf-8

"""
    Radarr

    Radarr API docs  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel
from radarr.models.movie_resource import MovieResource
from radarr.models.parsed_movie_info import ParsedMovieInfo

class ParseResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    title: Optional[str]
    parsed_movie_info: Optional[ParsedMovieInfo]
    movie: Optional[MovieResource]
    __properties = ["id", "title", "parsedMovieInfo", "movie"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParseResource:
        """Create an instance of ParseResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of parsed_movie_info
        if self.parsed_movie_info:
            _dict['parsedMovieInfo'] = self.parsed_movie_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of movie
        if self.movie:
            _dict['movie'] = self.movie.to_dict()
        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParseResource:
        """Create an instance of ParseResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ParseResource.parse_obj(obj)

        _obj = ParseResource.parse_obj({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "parsed_movie_info": ParsedMovieInfo.from_dict(obj.get("parsedMovieInfo")) if obj.get("parsedMovieInfo") is not None else None,
            "movie": MovieResource.from_dict(obj.get("movie")) if obj.get("movie") is not None else None
        })
        return _obj

