# AUTOGENERATED! DO NOT EDIT! File to edit: 25_s3_cmd.ipynb (unless otherwise specified).

__all__ = ['get_s3_key_list', 's3_session', 's3', 'bucket', 'df', 'list_s3_files', 'files_df']

# Cell
import json
import pandas as pd
import os
import boto3

# Cell
s3_session = boto3.session.Session(region_name='eu-west-1').client('s3')
s3 = boto3.resource('s3')

def get_s3_key_list(bucket: str):
    raw_data_buckets = s3_session.list_objects_v2(Bucket=bucket,Delimiter='/')
        # s3. list objects underneath

    df = pd.DataFrame(raw_data_buckets['CommonPrefixes'])
    return df

bucket = 'creationlabs-raw-data'
df = get_s3_key_list(bucket)
df

# Cell
def list_s3_files(bucket_name, prefix):
    bucket = s3.Bucket(bucket_name)
    files = [ [f"s3://{bucket_name}/{o.key}",o.key,o] for o  in bucket.objects.filter(Prefix=prefix)]

    columns = ['s3_path','key','object']

    files_df = pd.DataFrame(files, columns=columns)

    # split key column into multiple columns by '/'
    files_df['key'] = files_df['key'].apply(lambda x: x.split('/'))

    # get the max len(key)
    max_key_len = files_df['key'].apply(lambda x: len(x)).max()

    # create new columns for each key element
    for i in range(max_key_len):
        files_df['key_'+str(i)] = files_df['key'].apply(lambda x: x[i] if len(x) > i else None)

    return files_df

files_df = list_s3_files(bucket, df.Prefix.values[0])
files_df.head()