# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class CommentBody(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'text': 'str',
        'annotations': 'list[Annotation]',
        'is_resolved': 'str'
    }

    attribute_map = {
        'text': 'text',
        'annotations': 'annotations',
        'is_resolved': 'isResolved'
    }

    def __init__(self, text=None, annotations=None, is_resolved=None, local_vars_configuration=None):  # noqa: E501
        """CommentBody - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._text = None
        self._annotations = None
        self._is_resolved = None
        self.discriminator = None

        if text is not None:
            self.text = text
        if annotations is not None:
            self.annotations = annotations
        if is_resolved is not None:
            self.is_resolved = is_resolved

    @property
    def text(self):
        """Gets the text of this CommentBody.  # noqa: E501

        The main comment value.  # noqa: E501

        :return: The text of this CommentBody.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this CommentBody.

        The main comment value.  # noqa: E501

        :param text: The text of this CommentBody.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def annotations(self):
        """Gets the annotations of this CommentBody.  # noqa: E501

        A list of optional Annotations.  # noqa: E501

        :return: The annotations of this CommentBody.  # noqa: E501
        :rtype: list[Annotation]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this CommentBody.

        A list of optional Annotations.  # noqa: E501

        :param annotations: The annotations of this CommentBody.  # noqa: E501
        :type: list[Annotation]
        """

        self._annotations = annotations

    @property
    def is_resolved(self):
        """Gets the is_resolved of this CommentBody.  # noqa: E501


        :return: The is_resolved of this CommentBody.  # noqa: E501
        :rtype: str
        """
        return self._is_resolved

    @is_resolved.setter
    def is_resolved(self, is_resolved):
        """Sets the is_resolved of this CommentBody.


        :param is_resolved: The is_resolved of this CommentBody.  # noqa: E501
        :type: str
        """

        self._is_resolved = is_resolved

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommentBody):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CommentBody):
            return True

        return self.to_dict() != other.to_dict()
