# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['poolcontrolpy']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.1,<4.0.0', 'asyncio>=3.4.3,<4.0.0']

setup_kwargs = {
    'name': 'poolcontrolpy',
    'version': '0.2.3',
    'description': 'Package for accessing nodejs-poolController',
    'long_description': '# poolcontrolpy\n\nPackage for accessing nodejs-poolController for use with a planned Home Assistant integration.\n\n## Installation\n\n```bash\n$ pip install poolcontrolpy\n```\n\n## Usage\n\nConfigure pool controller and confirm successful connection.\n\n```python\nimport asyncio\nimport aiohttp\n\nfrom poolcontrolpy.poolcontrolpy import Controller\n\n\nasync def checkconnection():\n\n    async with aiohttp.ClientSession() as client:\n        controller = Controller(client, "10.0.20.13", 4200)\n        return await controller.checkconnect()\n\nresp = asyncio.run(checkconnection())\nprint(resp)\n```\n\n*Note: This example uses \'asyncio.run\' so it cannot be called when another asyncio event loop is running in the same thread.*\n\n## Contributing\n\nInterested in contributing? Check out the contributing guidelines. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.\n\n## License\n\n`poolcontrolpy` was created by Kevin Robinson. It is licensed under the terms of the MIT license.\n\n## Credits\n\n`poolcontrolpy` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).\n',
    'author': 'Kevin Robinson',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
