"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnMetric = exports.Unit = exports.toJson_CfnMetricProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnMetricProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnMetricProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DisplayName': obj.displayName,
        'Unit': obj.unit,
        'Dimensions': obj.dimensions?.map(y => y),
        'Types': obj.types?.map(y => y),
        'TimeseriesId': obj.timeseriesId,
        'PluginId': obj.pluginId,
        'Warnings': obj.warnings?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnMetricProps = toJson_CfnMetricProps;
/* eslint-enable max-len, quote-props */
/**
 * The unit of the metric.
 *
 * @schema Unit
 */
var Unit;
(function (Unit) {
    /** Billion (bilcount) */
    Unit["BILLION_BILCOUNT"] = "Billion (bilcount)";
    /** Bit (bit) */
    Unit["BIT_BIT"] = "Bit (bit)";
    /** BitPerHour (bit/h) */
    Unit["BIT_PER_HOUR_BIT_H"] = "BitPerHour (bit/h)";
    /** BitPerMinute (bit/min) */
    Unit["BIT_PER_MINUTE_BIT_MIN"] = "BitPerMinute (bit/min)";
    /** BitPerSecond (bit/s) */
    Unit["BIT_PER_SECOND_BIT_S"] = "BitPerSecond (bit/s)";
    /** Byte (B) */
    Unit["BYTE_B"] = "Byte (B)";
    /** BytePerHour (B/h) */
    Unit["BYTE_PER_HOUR_B_H"] = "BytePerHour (B/h)";
    /** BytePerMinute (B/min) */
    Unit["BYTE_PER_MINUTE_B_MIN"] = "BytePerMinute (B/min)";
    /** BytePerSecond (B/s) */
    Unit["BYTE_PER_SECOND_B_S"] = "BytePerSecond (B/s)";
    /** Cores */
    Unit["CORES"] = "Cores";
    /** Count (count) */
    Unit["COUNT_COUNT"] = "Count (count)";
    /** Day (ds) */
    Unit["DAY_DS"] = "Day (ds)";
    /** DecibelMilliWatt (dBm) */
    Unit["DECIBEL_MILLI_WATT_D_BM"] = "DecibelMilliWatt (dBm)";
    /** G */
    Unit["G"] = "G";
    /** GibiByte (GiB) */
    Unit["GIBI_BYTE_GI_B"] = "GibiByte (GiB)";
    /** GigaByte (GB) */
    Unit["GIGA_BYTE_GB"] = "GigaByte (GB)";
    /** Hour (hs) */
    Unit["HOUR_HS"] = "Hour (hs)";
    /** KibiByte (KiB) */
    Unit["KIBI_BYTE_KI_B"] = "KibiByte (KiB)";
    /** KibiBytePerHour (KiB/h) */
    Unit["KIBI_BYTE_PER_HOUR_KI_B_H"] = "KibiBytePerHour (KiB/h)";
    /** KibiBytePerMinute (KiB/min) */
    Unit["KIBI_BYTE_PER_MINUTE_KI_B_MIN"] = "KibiBytePerMinute (KiB/min)";
    /** KibiBytePerSecond (KiB/s) */
    Unit["KIBI_BYTE_PER_SECOND_KI_B_S"] = "KibiBytePerSecond (KiB/s)";
    /** KiloByte (kB) */
    Unit["KILO_BYTE_K_B"] = "KiloByte (kB)";
    /** KiloBytePerHour (kB/h) */
    Unit["KILO_BYTE_PER_HOUR_K_B_H"] = "KiloBytePerHour (kB/h)";
    /** KiloBytePerMinute (kB/min) */
    Unit["KILO_BYTE_PER_MINUTE_K_B_MIN"] = "KiloBytePerMinute (kB/min)";
    /** KiloBytePerSecond (kB/s) */
    Unit["KILO_BYTE_PER_SECOND_K_B_S"] = "KiloBytePerSecond (kB/s)";
    /** M */
    Unit["M"] = "M";
    /** MSU */
    Unit["MSU"] = "MSU";
    /** MebiByte (MiB) */
    Unit["MEBI_BYTE_MI_B"] = "MebiByte (MiB)";
    /** MebiBytePerHour (MiB/h) */
    Unit["MEBI_BYTE_PER_HOUR_MI_B_H"] = "MebiBytePerHour (MiB/h)";
    /** MebiBytePerMinute (MiB/min) */
    Unit["MEBI_BYTE_PER_MINUTE_MI_B_MIN"] = "MebiBytePerMinute (MiB/min)";
    /** MebiBytePerSecond (MiB/s) */
    Unit["MEBI_BYTE_PER_SECOND_MI_B_S"] = "MebiBytePerSecond (MiB/s)";
    /** MegaByte (MB) */
    Unit["MEGA_BYTE_MB"] = "MegaByte (MB)";
    /** MegaBytePerHour (MB/h) */
    Unit["MEGA_BYTE_PER_HOUR_MB_H"] = "MegaBytePerHour (MB/h)";
    /** MegaBytePerMinute (MB/min) */
    Unit["MEGA_BYTE_PER_MINUTE_MB_MIN"] = "MegaBytePerMinute (MB/min)";
    /** MegaBytePerSecond (MB/s) */
    Unit["MEGA_BYTE_PER_SECOND_MB_S"] = "MegaBytePerSecond (MB/s)";
    /** MicroSecond (?s) */
    Unit["MICRO_SECOND_S"] = "MicroSecond (?s)";
    /** MilliSecond (ms) */
    Unit["MILLI_SECOND_MS"] = "MilliSecond (ms)";
    /** MilliSecondPerMinute (ms/min) */
    Unit["MILLI_SECOND_PER_MINUTE_MS_MIN"] = "MilliSecondPerMinute (ms/min)";
    /** Million (milcount) */
    Unit["MILLION_MILCOUNT"] = "Million (milcount)";
    /** Minute (mins) */
    Unit["MINUTE_MINS"] = "Minute (mins)";
    /** Month (mos) */
    Unit["MONTH_MOS"] = "Month (mos)";
    /** N/A */
    Unit["N_A"] = "N/A";
    /** NanoSecond (ns) */
    Unit["NANO_SECOND_NS"] = "NanoSecond (ns)";
    /** NanoSecondPerMinute (ns/min) */
    Unit["NANO_SECOND_PER_MINUTE_NS_MIN"] = "NanoSecondPerMinute (ns/min)";
    /** PerHour (count/h) */
    Unit["PER_HOUR_COUNT_H"] = "PerHour (count/h)";
    /** PerMinute (count/min) */
    Unit["PER_MINUTE_COUNT_MIN"] = "PerMinute (count/min)";
    /** PerSecond (count/s) */
    Unit["PER_SECOND_COUNT_S"] = "PerSecond (count/s)";
    /** Percent (%) */
    Unit["PERCENT"] = "Percent (%)";
    /** Pixel (px) */
    Unit["PIXEL_PX"] = "Pixel (px)";
    /** Promille (?) */
    Unit["PROMILLE"] = "Promille (?)";
    /** Ratio */
    Unit["RATIO"] = "Ratio";
    /** Second (s) */
    Unit["SECOND_S"] = "Second (s)";
    /** State */
    Unit["STATE"] = "State";
    /** Unspecified */
    Unit["UNSPECIFIED"] = "Unspecified";
    /** Week (ws) */
    Unit["WEEK_WS"] = "Week (ws)";
    /** Year (ys) */
    Unit["YEAR_YS"] = "Year (ys)";
    /** k */
    Unit["K"] = "k";
    /** km/h */
    Unit["KM_H"] = "km/h";
    /** m/h */
    Unit["M_H"] = "m/h";
    /** m/s */
    Unit["M_S"] = "m/s";
    /** mCores */
    Unit["M_CORES"] = "mCores";
})(Unit = exports.Unit || (exports.Unit = {}));
/**
 * A CloudFormation `Dynatrace::Environment::Metric`
 *
 * @cloudformationResource Dynatrace::Environment::Metric
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
 */
class CfnMetric extends cdk.CfnResource {
    /**
     * Create a new `Dynatrace::Environment::Metric`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMetric.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnMetricProps(props) });
        this.props = props;
        this.attrAggregationTypes = cdk.Token.asList(this.getAtt('AggregationTypes'));
        this.attrFilter = cdk.Token.asString(this.getAtt('Filter'));
        this.attrDetailedSource = cdk.Token.asString(this.getAtt('DetailedSource'));
    }
}
exports.CfnMetric = CfnMetric;
_a = JSII_RTTI_SYMBOL_1;
CfnMetric[_a] = { fqn: "@cdk-cloudformation/dynatrace-environment-metric.CfnMetric", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnMetric.CFN_RESOURCE_TYPE_NAME = "Dynatrace::Environment::Metric";
//# sourceMappingURL=data:application/json;base64,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