import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a timeseries metric (V1) in Dynatrace.
 *
 * @schema CfnMetricProps
 */
export interface CfnMetricProps {
    /**
     * @schema CfnMetricProps#DisplayName
     */
    readonly displayName?: string;
    /**
     * @schema CfnMetricProps#Unit
     */
    readonly unit?: Unit;
    /**
     * @schema CfnMetricProps#Dimensions
     */
    readonly dimensions?: string[];
    /**
     * @schema CfnMetricProps#Types
     */
    readonly types?: string[];
    /**
     * @schema CfnMetricProps#TimeseriesId
     */
    readonly timeseriesId?: string;
    /**
     * The ID of the plugin, where the metric originates.
     *
     * @schema CfnMetricProps#PluginId
     */
    readonly pluginId?: string;
    /**
     * The warnings that occurred while creating the metric.
     *
     * @schema CfnMetricProps#Warnings
     */
    readonly warnings?: string[];
}
/**
 * Converts an object of type 'CfnMetricProps' to JSON representation.
 */
export declare function toJson_CfnMetricProps(obj: CfnMetricProps | undefined): Record<string, any> | undefined;
/**
 * The unit of the metric.
 *
 * @schema Unit
 */
export declare enum Unit {
    /** Billion (bilcount) */
    BILLION_BILCOUNT = "Billion (bilcount)",
    /** Bit (bit) */
    BIT_BIT = "Bit (bit)",
    /** BitPerHour (bit/h) */
    BIT_PER_HOUR_BIT_H = "BitPerHour (bit/h)",
    /** BitPerMinute (bit/min) */
    BIT_PER_MINUTE_BIT_MIN = "BitPerMinute (bit/min)",
    /** BitPerSecond (bit/s) */
    BIT_PER_SECOND_BIT_S = "BitPerSecond (bit/s)",
    /** Byte (B) */
    BYTE_B = "Byte (B)",
    /** BytePerHour (B/h) */
    BYTE_PER_HOUR_B_H = "BytePerHour (B/h)",
    /** BytePerMinute (B/min) */
    BYTE_PER_MINUTE_B_MIN = "BytePerMinute (B/min)",
    /** BytePerSecond (B/s) */
    BYTE_PER_SECOND_B_S = "BytePerSecond (B/s)",
    /** Cores */
    CORES = "Cores",
    /** Count (count) */
    COUNT_COUNT = "Count (count)",
    /** Day (ds) */
    DAY_DS = "Day (ds)",
    /** DecibelMilliWatt (dBm) */
    DECIBEL_MILLI_WATT_D_BM = "DecibelMilliWatt (dBm)",
    /** G */
    G = "G",
    /** GibiByte (GiB) */
    GIBI_BYTE_GI_B = "GibiByte (GiB)",
    /** GigaByte (GB) */
    GIGA_BYTE_GB = "GigaByte (GB)",
    /** Hour (hs) */
    HOUR_HS = "Hour (hs)",
    /** KibiByte (KiB) */
    KIBI_BYTE_KI_B = "KibiByte (KiB)",
    /** KibiBytePerHour (KiB/h) */
    KIBI_BYTE_PER_HOUR_KI_B_H = "KibiBytePerHour (KiB/h)",
    /** KibiBytePerMinute (KiB/min) */
    KIBI_BYTE_PER_MINUTE_KI_B_MIN = "KibiBytePerMinute (KiB/min)",
    /** KibiBytePerSecond (KiB/s) */
    KIBI_BYTE_PER_SECOND_KI_B_S = "KibiBytePerSecond (KiB/s)",
    /** KiloByte (kB) */
    KILO_BYTE_K_B = "KiloByte (kB)",
    /** KiloBytePerHour (kB/h) */
    KILO_BYTE_PER_HOUR_K_B_H = "KiloBytePerHour (kB/h)",
    /** KiloBytePerMinute (kB/min) */
    KILO_BYTE_PER_MINUTE_K_B_MIN = "KiloBytePerMinute (kB/min)",
    /** KiloBytePerSecond (kB/s) */
    KILO_BYTE_PER_SECOND_K_B_S = "KiloBytePerSecond (kB/s)",
    /** M */
    M = "M",
    /** MSU */
    MSU = "MSU",
    /** MebiByte (MiB) */
    MEBI_BYTE_MI_B = "MebiByte (MiB)",
    /** MebiBytePerHour (MiB/h) */
    MEBI_BYTE_PER_HOUR_MI_B_H = "MebiBytePerHour (MiB/h)",
    /** MebiBytePerMinute (MiB/min) */
    MEBI_BYTE_PER_MINUTE_MI_B_MIN = "MebiBytePerMinute (MiB/min)",
    /** MebiBytePerSecond (MiB/s) */
    MEBI_BYTE_PER_SECOND_MI_B_S = "MebiBytePerSecond (MiB/s)",
    /** MegaByte (MB) */
    MEGA_BYTE_MB = "MegaByte (MB)",
    /** MegaBytePerHour (MB/h) */
    MEGA_BYTE_PER_HOUR_MB_H = "MegaBytePerHour (MB/h)",
    /** MegaBytePerMinute (MB/min) */
    MEGA_BYTE_PER_MINUTE_MB_MIN = "MegaBytePerMinute (MB/min)",
    /** MegaBytePerSecond (MB/s) */
    MEGA_BYTE_PER_SECOND_MB_S = "MegaBytePerSecond (MB/s)",
    /** MicroSecond (?s) */
    MICRO_SECOND_S = "MicroSecond (?s)",
    /** MilliSecond (ms) */
    MILLI_SECOND_MS = "MilliSecond (ms)",
    /** MilliSecondPerMinute (ms/min) */
    MILLI_SECOND_PER_MINUTE_MS_MIN = "MilliSecondPerMinute (ms/min)",
    /** Million (milcount) */
    MILLION_MILCOUNT = "Million (milcount)",
    /** Minute (mins) */
    MINUTE_MINS = "Minute (mins)",
    /** Month (mos) */
    MONTH_MOS = "Month (mos)",
    /** N/A */
    N_A = "N/A",
    /** NanoSecond (ns) */
    NANO_SECOND_NS = "NanoSecond (ns)",
    /** NanoSecondPerMinute (ns/min) */
    NANO_SECOND_PER_MINUTE_NS_MIN = "NanoSecondPerMinute (ns/min)",
    /** PerHour (count/h) */
    PER_HOUR_COUNT_H = "PerHour (count/h)",
    /** PerMinute (count/min) */
    PER_MINUTE_COUNT_MIN = "PerMinute (count/min)",
    /** PerSecond (count/s) */
    PER_SECOND_COUNT_S = "PerSecond (count/s)",
    /** Percent (%) */
    PERCENT = "Percent (%)",
    /** Pixel (px) */
    PIXEL_PX = "Pixel (px)",
    /** Promille (?) */
    PROMILLE = "Promille (?)",
    /** Ratio */
    RATIO = "Ratio",
    /** Second (s) */
    SECOND_S = "Second (s)",
    /** State */
    STATE = "State",
    /** Unspecified */
    UNSPECIFIED = "Unspecified",
    /** Week (ws) */
    WEEK_WS = "Week (ws)",
    /** Year (ys) */
    YEAR_YS = "Year (ys)",
    /** k */
    K = "k",
    /** km/h */
    KM_H = "km/h",
    /** m/h */
    M_H = "m/h",
    /** m/s */
    M_S = "m/s",
    /** mCores */
    M_CORES = "mCores"
}
/**
 * A CloudFormation `Dynatrace::Environment::Metric`
 *
 * @cloudformationResource Dynatrace::Environment::Metric
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
 */
export declare class CfnMetric extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Dynatrace::Environment::Metric";
    /**
     * Resource props.
     */
    readonly props: CfnMetricProps;
    /**
     * Attribute `Dynatrace::Environment::Metric.AggregationTypes`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrAggregationTypes: string[];
    /**
     * Attribute `Dynatrace::Environment::Metric.Filter`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrFilter: string;
    /**
     * Attribute `Dynatrace::Environment::Metric.DetailedSource`
     * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
     */
    readonly attrDetailedSource: string;
    /**
     * Create a new `Dynatrace::Environment::Metric`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnMetricProps);
}
