/*!
 * Cropper v0.5.5
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014 Fengyuan Chen
 * Released under the MIT license
 */

!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a(jQuery)}(function(a){"use strict";var b=a(window),c=a(document),d=/^(\+|\*|e|n|w|s|ne|nw|sw|se)$/i,e=/^(x|y|width|height)$/i,f="cropper-hidden",g="cropper-invisible",h="mousedown touchstart",i="mousemove touchmove",j="mouseup mouseleave touchend touchleave touchcancel",k="build.cropper",l="built.cropper",m="render.cropper",n="resize.cropper",o=function(a){return"number"==typeof a},p=function(b,c){this.$element=a(b),this.setDefaults(c),this.init()},q=Math.round,r=Math.min,s=Math.max,t=Math.abs,u=parseFloat;p.prototype={constructor:p,setDefaults:function(b){b=a.extend({},p.defaults,a.isPlainObject(b)?b:{}),a.each(b,function(a,c){switch(a){case"moveable":b.movable=c;break;case"resizeable":b.resizable=c;break;case"aspectRatio":b[a]=t(u(c))||0/0;break;case"minWidth":case"minHeight":b[a]=t(u(c))||0;break;case"maxWidth":case"maxHeight":b[a]=t(u(c))||1/0}}),this.defaults=b},init:function(){var b,c,d=this,e=this.$element,f=e[0],h={};e.is("img")?b=e.attr("src"):e.is("canvas")&&f.getContext&&(b=f.toDataURL()),b&&(this.$clone&&this.$clone.remove(),this.$clone=c=a('<img src="'+b+'">'),c.one("load",function(){h.naturalWidth=this.naturalWidth||c.width(),h.naturalHeight=this.naturalHeight||c.height(),h.aspectRatio=h.naturalWidth/h.naturalHeight,d.active=!0,d.src=b,d.image=h,d.build()}),c.addClass(g).prependTo("body"))},build:function(){var b,d,e=this.$element,h=this.defaults;this.built&&this.unbuild(),b=a.Event(k),e.trigger(b),b.isDefaultPrevented()||(this.$cropper=d=a(p.template),e.addClass(f),this.$clone.removeClass(g).prependTo(d),this.$container=e.parent(),this.$container.append(d),this.$modal=d.find(".cropper-modal"),this.$canvas=d.find(".cropper-canvas"),this.$dragger=d.find(".cropper-dragger"),this.$viewer=d.find(".cropper-viewer"),this.cropped=!0,h.autoCrop||(this.$dragger.addClass(f),this.cropped=!1),this.$modal.toggleClass(f,!h.modal),!h.dragCrop&&this.$canvas.addClass(f),!h.movable&&this.$dragger.find(".cropper-face").addClass(f),!h.resizable&&this.$dragger.find(".cropper-line, .cropper-point").addClass(f),this.$dragScope=h.multiple?this.$cropper:c,this.addListener(),this.initPreview(),this.built=!0,this.update(),e.trigger(l))},unbuild:function(){this.built&&(this.built=!1,this.removeListener(),this.$preview.empty(),this.$preview=null,this.$dragger=null,this.$canvas=null,this.$modal=null,this.$container=null,this.$cropper.remove(),this.$cropper=null)},update:function(a){this.initContainer(),this.initCropper(),this.initDragger(),a?this.setData(a,!0):this.setData(this.defaults.data)},resize:function(){clearTimeout(this.resizing),this.resizing=setTimeout(a.proxy(this.update,this,this.getData()),200)},reset:function(a){this.cropped&&(a&&(this.defaults.data={}),this.dragger=this.cloneDragger(),this.setData(this.defaults.data))},release:function(){this.cropped&&(this.cropped=!1,this.defaults.done({x:0,y:0,width:0,height:0}),this.$dragger.addClass(f))},destroy:function(){var a=this.$element;this.active&&(this.unbuild(),a.removeClass(f),a.removeData("cropper"),a=null)},preview:function(){var b=this.cropper,c=this.dragger;this.$viewer.find("img").css({height:q(b.height),marginLeft:-q(c.left),marginTop:-q(c.top),width:q(b.width)}),this.$preview.each(function(){var d=a(this),e=d.width()/c.width,f={height:q(b.height*e),marginLeft:-q(c.left*e),marginTop:-q(c.top*e),width:q(b.width*e)};d.find("img").css(f)})},addListener:function(){var c=this.defaults;this.$element.on(k,c.build).on(l,c.built).on(m,c.render),this.$cropper.on(h,a.proxy(this.dragstart,this)),this.$dragScope.on(i,a.proxy(this.dragmove,this)).on(j,a.proxy(this.dragend,this)),b.on(n,a.proxy(this.resize,this))},removeListener:function(){var a=this.defaults;this.$element.off(k,a.build).off(l,a.built).off(m,a.render),this.$cropper.off(h,this.dragstart),this.$dragScope.off(i,this.dragmove).on(j,this.dragend),b.off(n,this.resize)},initPreview:function(){var b='<img src="'+this.src+'">';this.$preview=a(this.defaults.preview),this.$preview.html(b),this.$viewer.html(b)},initContainer:function(){var a=this.$container;this.container={width:a.width(),height:a.height()}},initCropper:function(){var a,b=this.container,c=this.image;c.naturalWidth*b.height/c.naturalHeight-b.width>=0?(a={height:b.width/c.aspectRatio,width:b.width,left:0},a.top=(b.height-a.height)/2):(a={height:b.height,width:b.height*c.aspectRatio,top:0},a.left=(b.width-a.width)/2),c.ratio=a.width/c.naturalWidth,c.height=a.height,c.width=a.width,this.$cropper.css({height:q(a.height),left:q(a.left),top:q(a.top),width:q(a.width)}),this.cropper=a},initDragger:function(){var a,b=this.defaults,c=this.cropper,d=b.aspectRatio||this.image.aspectRatio,e=this.image.ratio;a=c.height*d-c.width>=0?{height:c.width/d,width:c.width,left:0,top:(c.height-c.width/d)/2,maxWidth:c.width,maxHeight:c.width/d}:{height:c.height,width:c.height*d,left:(c.width-c.height*d)/2,top:0,maxWidth:c.height*d,maxHeight:c.height},a.minWidth=0,a.minHeight=0,b.aspectRatio?(isFinite(b.maxWidth)?(a.maxWidth=r(a.maxWidth,b.maxWidth*e),a.maxHeight=a.maxWidth/d):isFinite(b.maxHeight)&&(a.maxHeight=r(a.maxHeight,b.maxHeight*e),a.maxWidth=a.maxHeight*d),b.minWidth>0?(a.minWidth=s(0,b.minWidth*e),a.minHeight=a.minWidth/d):b.minHeight>0&&(a.minHeight=s(0,b.minHeight*e),a.minWidth=a.minHeight*d)):(a.maxWidth=r(a.maxWidth,b.maxWidth*e),a.maxHeight=r(a.maxHeight,b.maxHeight*e),a.minWidth=s(0,b.minWidth*e),a.minHeight=s(0,b.minHeight*e)),a.minWidth=r(a.maxWidth,a.minWidth),a.minHeight=r(a.maxHeight,a.minHeight),a.height*=.8,a.width*=.8,a.left=(c.width-a.width)/2,a.top=(c.height-a.height)/2,this.defaultDragger=a,this.dragger=this.cloneDragger(),this.draggerLeft=a.left,this.draggerTop=a.top},cloneDragger:function(){return a.extend({},this.defaultDragger)},renderDragger:function(){var b,c,d,e=this.dragger,f=this.cropper,g=this.draggerLeft,h=this.draggerTop;e.width>e.maxWidth?(e.width=e.maxWidth,e.left=g):e.width<e.minWidth&&(e.width=e.minWidth,e.left=g),e.height>e.maxHeight?(e.height=e.maxHeight,e.top=h):e.height<e.minHeight&&(e.height=e.minHeight,e.top=h),b=f.width-e.width,c=f.height-e.height,e.left=e.left>b?b:e.left<0?0:e.left,e.top=e.top>c?c:e.top<0?0:e.top,d=a.Event(m),this.$element.trigger(d),d.isDefaultPrevented()||(this.dragger=e,this.draggerLeft=e.left,this.draggerTop=e.top,this.defaults.done(this.getData()),this.$dragger.css({height:q(e.height),left:q(e.left),top:q(e.top),width:q(e.width)}),this.preview())},setData:function(b,c){var d=this.cropper,e=this.dragger,f=this.defaults.aspectRatio;this.built&&"undefined"!=typeof b&&((null===b||a.isEmptyObject(b))&&(e=this.cloneDragger()),a.isPlainObject(b)&&!a.isEmptyObject(b)&&(c||(this.defaults.data=b),b=this.transformData(b),o(b.x)&&b.x<=d.width&&(e.left=b.x),o(b.y)&&b.y<=d.height&&(e.top=b.y),f?o(b.width)&&b.width<=e.maxWidth&&b.width>=e.minWidth?(e.width=b.width,e.height=e.width/f):o(b.height)&&b.height<=e.maxHeight&&b.height>=e.minHeight&&(e.height=b.height,e.width=e.height*f):(o(b.width)&&b.width<=e.maxWidth&&b.width>=e.minWidth&&(e.width=b.width),o(b.height)&&b.height<=e.maxHeight&&b.height>=e.minHeight&&(e.height=b.height))),this.dragger=e,this.renderDragger())},getData:function(){var a=this.dragger,b={};return this.built&&(b={x:a.left,y:a.top,width:a.width,height:a.height},b=this.transformData(b,!0)),b},transformData:function(b,c){var d=this.image.ratio,f={};return a.each(b,function(a,b){b=u(b),e.test(a)&&!isNaN(b)&&(f[a]=c?q(b/d):b*d)}),f},setAspectRatio:function(a){var b="auto"===a;a=u(a),(b||!isNaN(a)&&a>0)&&(this.defaults.aspectRatio=b?0/0:a,this.built&&(this.initDragger(),this.renderDragger()))},setImgSrc:function(b){var c,d=this,e=this.$element,f=e[0];b&&b!==this.src&&(e.is("img")?(e.attr("src",b),this.init()):e.is("canvas")&&f.getContext&&(c=f.getContext("2d"),a('<img src="'+b+'">').one("load",function(){f.width=this.width,f.height=this.height,c.clearRect(0,0,f.width,f.height),c.drawImage(this,0,0),d.init()})))},getImgInfo:function(){return this.image||{}},dragstart:function(b){var c,e=(b.originalEvent||b).touches,g=b;if(e){if(e.length>1)return;g=e[0],this.touchId=g.identifier}c=a(g.target).data("direction"),d.test(c)&&(b.preventDefault(),this.direction=c,this.startX=g.pageX,this.startY=g.pageY,"+"===c&&(this.cropping=!0,this.$modal.removeClass(f)))},dragmove:function(a){var b=(a.originalEvent||a).changedTouches,c=a;if(b){if(b.length>1)return;if(c=b[0],c.identifier!==this.touchId)return}this.direction&&(a.preventDefault(),this.endX=c.pageX,this.endY=c.pageY,this.dragging())},dragend:function(a){var b=(a.originalEvent||a).changedTouches,c=a;if(b){if(b.length>1)return;if(c=b[0],c.identifier!==this.touchId)return}this.direction&&(a.preventDefault(),this.cropping&&(this.cropping=!1,this.$modal.toggleClass(f,!this.defaults.modal)),this.direction="")},dragging:function(){var a,b=this.direction,c=this.cropper,d=c.width,e=c.height,g=this.dragger,h=g.width,i=g.height,j=g.left,k=g.top,l=j+h,m=k+i,n=!0,o=this.defaults.aspectRatio,p={x:this.endX-this.startX,y:this.endY-this.startY};switch(o&&(p.X=p.y*o,p.Y=p.x/o),b){case"+":p.x&&p.y&&(a=this.$cropper.offset(),j=this.startX-a.left,k=this.startY-a.top,h=g.minWidth,i=g.minHeight,p.x>0?p.y>0?b="se":(b="ne",k-=i):p.y>0?(b="sw",j-=h):(b="nw",j-=h,k-=i),this.cropped||(this.cropped=!0,this.$dragger.removeClass(f)));break;case"*":j+=p.x,k+=p.y;break;case"e":if(p.x>=0&&(l>=d||o&&(0>=k||m>=e))){n=!1;break}h+=p.x,o&&(i=h/o,k-=p.Y/2),0>h&&(b="w",h=0);break;case"n":if(p.y<=0&&(0>=k||o&&(0>=j||l>=d))){n=!1;break}i-=p.y,k+=p.y,o&&(h=i*o,j+=p.X/2),0>i&&(b="s",i=0);break;case"w":if(p.x<=0&&(0>=j||o&&(0>=k||m>=e))){n=!1;break}h-=p.x,j+=p.x,o&&(i=h/o,k+=p.Y/2),0>h&&(b="e",h=0);break;case"s":if(p.y>=0&&(m>=e||o&&(0>=j||l>=d))){n=!1;break}i+=p.y,o&&(h=i*o,j-=p.X/2),0>i&&(b="n",i=0);break;case"ne":if(p.y<=0&&(0>=k||l>=d)){n=!1;break}i-=p.y,k+=p.y,o?h=i*o:h+=p.x,0>i&&(b="sw",i=0,h=0);break;case"nw":if(p.y<=0&&(0>=k||0>=j)){n=!1;break}i-=p.y,k+=p.y,o?(h=i*o,j+=p.X):(h-=p.x,j+=p.x),0>i&&(b="se",i=0,h=0);break;case"sw":if(p.x<=0&&(0>=j||m>=e)){n=!1;break}h-=p.x,j+=p.x,o?i=h/o:i+=p.y,0>h&&(b="ne",i=0,h=0);break;case"se":if(p.x>=0&&(l>=d||m>=e)){n=!1;break}h+=p.x,o?i=h/o:i+=p.y,0>h&&(b="nw",i=0,h=0)}n&&(g.width=h,g.height=i,g.left=j,g.top=k,this.direction=b,this.renderDragger()),this.startX=this.endX,this.startY=this.endY}},p.template=function(a,b){return b=b.split(","),a.replace(/\d+/g,function(a){return b[a]})}('<0 6="5-container"><0 6="5-modal"></0><0 6="5-canvas" 3-2="+"></0><0 6="5-dragger"><1 6="5-viewer"></1><1 6="5-8 8-h"></1><1 6="5-8 8-v"></1><1 6="5-face" 3-2="*"></1><1 6="5-7 7-e" 3-2="e"></1><1 6="5-7 7-n" 3-2="n"></1><1 6="5-7 7-w" 3-2="w"></1><1 6="5-7 7-s" 3-2="s"></1><1 6="5-4 4-e" 3-2="e"></1><1 6="5-4 4-n" 3-2="n"></1><1 6="5-4 4-w" 3-2="w"></1><1 6="5-4 4-s" 3-2="s"></1><1 6="5-4 4-ne" 3-2="ne"></1><1 6="5-4 4-nw" 3-2="nw"></1><1 6="5-4 4-sw" 3-2="sw"></1><1 6="5-4 4-se" 3-2="se"></1></0></0>',"div,span,direction,data,point,cropper,class,line,dashed"),p.defaults={aspectRatio:"auto",data:{},done:a.noop,multiple:!1,autoCrop:!0,dragCrop:!0,modal:!0,movable:!0,resizable:!0,minWidth:0,minHeight:0,maxWidth:1/0,maxHeight:1/0},p.setDefaults=function(b){a.extend(p.defaults,b)},p.other=a.fn.cropper,a.fn.cropper=function(b,c){var d=this;return this.each(function(){var e=a(this),f=e.data("cropper");f||e.data("cropper",f=new p(this,b)),"string"==typeof b&&a.isFunction(f[b])&&(d=f[b](c))}),"undefined"!=typeof d?d:this},a.fn.cropper.constructor=p,a.fn.cropper.setDefaults=p.setDefaults,a.fn.cropper.noConflict=function(){return a.fn.cropper=p.other,this}});