"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
const lib_1 = require("../lib");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const duration_1 = require("@aws-cdk/core/lib/duration");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-cloudfront-s3-existing-bucket-stack');
let mybucket;
mybucket = defaults.CreateScrapBucket(stack, { removalPolicy: core_1.RemovalPolicy.DESTROY });
const _construct = new lib_1.CloudFrontToS3(stack, 'test-cloudfront-s3', {
    existingBucketObj: mybucket,
});
// Add Cache Policy
const myCachePolicy = new cloudfront.CachePolicy(stack, 'myCachePolicy', {
    cachePolicyName: 'MyPolicy',
    defaultTtl: duration_1.Duration.minutes(0),
    minTtl: duration_1.Duration.minutes(0),
    maxTtl: duration_1.Duration.minutes(0),
});
// Add behavior
_construct.cloudFrontWebDistribution.addBehavior('/images/*.jpg', new origins.S3Origin(mybucket), {
    cachePolicy: myCachePolicy
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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