# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-12-02 21:08
"""
Hand edited to run separate database and state migrations to add indexes to
LearnerCourseGradeMetrics
"""
from __future__ import unicode_literals

from django.db import migrations, models
from django.db import connection


def compat_drop_index(index, table):
    """Compatibility function to drop a database index

    Because MySQL requires the table name in the drop statement and SQLite
    fails if the `ON table_name` is provided
    """
    if connection.vendor == 'mysql':
        return 'DROP INDEX {index} ON {table}'.format(index=index, table=table)
    else:
        return 'DROP INDEX {index}'.format(index=index)


class Migration(migrations.Migration):

    atomic = False

    dependencies = [
        ('figures', '0012_alter_pipelineerror_field'),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.AlterField(
                    model_name='learnercoursegrademetrics',
                    name='course_id',
                    field=models.CharField(blank=True, db_index=True, max_length=255),
                ),
                migrations.AlterField(
                    model_name='learnercoursegrademetrics',
                    name='date_for',
                    field=models.DateField(db_index=True),
                ),
            ],
            database_operations=[
                migrations.RunSQL(sql="""
                    CREATE INDEX figures_learnercoursegrademetrics_course_id_599c26b2
                    ON figures_learnercoursegrademetrics (course_id);
                """, reverse_sql=compat_drop_index(
                        index='figures_learnercoursegrademetrics_course_id_599c26b2',
                        table='figures_learnercoursegrademetrics')),
                migrations.RunSQL(sql="""
                    CREATE INDEX figures_learnercoursegrademetrics_date_for_3872d749
                    ON figures_learnercoursegrademetrics (date_for);
                """, reverse_sql=compat_drop_index(
                        index='figures_learnercoursegrademetrics_date_for_3872d749',
                        table='figures_learnercoursegrademetrics')
                    )
            ]
        )
    ]
