<a id="mypy-boto3-qldb"></a>

# mypy-boto3-qldb

[![PyPI - mypy-boto3-qldb](https://img.shields.io/pypi/v/mypy-boto3-qldb.svg?color=blue)](https://pypi.org/project/mypy-boto3-qldb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-qldb.svg?color=blue)](https://pypi.org/project/mypy-boto3-qldb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-qldb?color=blue)](https://pypistats.org/packages/mypy-boto3-qldb)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.QLDB 1.18.26](https://boto3.amazonaws.com/v1/documentation/api/1.18.26/reference/services/qldb.html#QLDB)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-qldb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_qldb/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-qldb](#mypy-boto3-qldb)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `QLDB` service.

```bash
python -m pip install boto3-stubs[qldb]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[qldb]` in your environment:
  `python -m pip install 'boto3-stubs[qldb]'`

Both type checking and auto-complete should work for `QLDB` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[qldb]` in your environment:
  `python -m pip install 'boto3-stubs[qldb]'`

Both type checking and auto-complete should work for `QLDB` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[qldb]` in your environment:
  `python -m pip install 'boto3-stubs[qldb]'`
- Run `mypy` as usual

Type checking should work for `QLDB` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[qldb]` in your environment:
  `python -m pip install 'boto3-stubs[qldb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `QLDB` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`QLDBClient` provides annotations for `boto3.client("qldb")`.

```python
import boto3

from mypy_boto3_qldb import QLDBClient

client: QLDBClient = boto3.client("qldb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: QLDBClient = session.client("qldb")
```

<a id="literals"></a>

### Literals

`mypy_boto3_qldb.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_qldb.literals import (
    EncryptionStatusType,
    ErrorCauseType,
    ExportStatusType,
    LedgerStateType,
    PermissionsModeType,
    S3ObjectEncryptionTypeType,
    StreamStatusType,
)

def check_value(value: EncryptionStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_qldb.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_qldb.type_defs import (
    CancelJournalKinesisStreamRequestRequestTypeDef,
    CancelJournalKinesisStreamResponseTypeDef,
    CreateLedgerRequestRequestTypeDef,
    CreateLedgerResponseTypeDef,
    DeleteLedgerRequestRequestTypeDef,
    DescribeJournalKinesisStreamRequestRequestTypeDef,
    DescribeJournalKinesisStreamResponseTypeDef,
    DescribeJournalS3ExportRequestRequestTypeDef,
    DescribeJournalS3ExportResponseTypeDef,
    DescribeLedgerRequestRequestTypeDef,
    DescribeLedgerResponseTypeDef,
    ExportJournalToS3RequestRequestTypeDef,
    ExportJournalToS3ResponseTypeDef,
    GetBlockRequestRequestTypeDef,
    GetBlockResponseTypeDef,
    GetDigestRequestRequestTypeDef,
    GetDigestResponseTypeDef,
    GetRevisionRequestRequestTypeDef,
    GetRevisionResponseTypeDef,
    JournalKinesisStreamDescriptionTypeDef,
    JournalS3ExportDescriptionTypeDef,
    KinesisConfigurationTypeDef,
    LedgerEncryptionDescriptionTypeDef,
    LedgerSummaryTypeDef,
    ListJournalKinesisStreamsForLedgerRequestRequestTypeDef,
    ListJournalKinesisStreamsForLedgerResponseTypeDef,
    ListJournalS3ExportsForLedgerRequestRequestTypeDef,
    ListJournalS3ExportsForLedgerResponseTypeDef,
    ListJournalS3ExportsRequestRequestTypeDef,
    ListJournalS3ExportsResponseTypeDef,
    ListLedgersRequestRequestTypeDef,
    ListLedgersResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ResponseMetadataTypeDef,
    S3EncryptionConfigurationTypeDef,
    S3ExportConfigurationTypeDef,
    StreamJournalToKinesisRequestRequestTypeDef,
    StreamJournalToKinesisResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateLedgerPermissionsModeRequestRequestTypeDef,
    UpdateLedgerPermissionsModeResponseTypeDef,
    UpdateLedgerRequestRequestTypeDef,
    UpdateLedgerResponseTypeDef,
    ValueHolderTypeDef,
)

def get_structure() -> CancelJournalKinesisStreamRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-qldb` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-qldb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_qldb/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
