# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['proc_wrapper']

package_data = \
{'': ['*']}

extras_require = \
{'docs': ['Sphinx>=3.3.0,<4.0.0',
          'sphinx-rtd-theme>=0.5.0,<0.6.0',
          'myst-parser>=0.13.0,<0.14.0']}

setup_kwargs = {
    'name': 'cloudreactor-procwrapper',
    'version': '2.0.0rc6',
    'description': 'Wraps the execution of processes so that a service API endpoint (CloudReactor) can monitor and manage them. Also implements retries, timeouts, and secret injection from AWS into the environment.',
    'long_description': '# cloudreactor-procwrapper\n\n<p align="center">\n  <a href="https://github.com/CloudReactor/cloudreactor-procwrapper/actions?query=workflow%3ACI">\n    <img src="https://img.shields.io/github/workflow/status/CloudReactor/cloudreactor-procwrapper/CI/main?label=CI&logo=github&style=flat-square" alt="CI Status" >\n  </a>\n  <a href="https://cloudreactor-procwrapper.readthedocs.io">\n    <img src="https://img.shields.io/readthedocs/cloudreactor-procwrapper.svg?logo=read-the-docs&logoColor=fff&style=flat-square" alt="Documentation Status">\n  </a>\n  <a href="https://codecov.io/gh/CloudReactor/cloudreactor-procwrapper">\n    <img src="https://img.shields.io/codecov/c/github/CloudReactor/cloudreactor-procwrapper.svg?logo=codecov&logoColor=fff&style=flat-square" alt="Test coverage percentage">\n  </a>\n</p>\n<p align="center">\n  <a href="https://python-poetry.org/">\n    <img src="https://img.shields.io/badge/packaging-poetry-299bd7?style=flat-square&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAASCAYAAABrXO8xAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAJJSURBVHgBfZLPa1NBEMe/s7tNXoxW1KJQKaUHkXhQvHgW6UHQQ09CBS/6V3hKc/AP8CqCrUcpmop3Cx48eDB4yEECjVQrlZb80CRN8t6OM/teagVxYZi38+Yz853dJbzoMV3MM8cJUcLMSUKIE8AzQ2PieZzFxEJOHMOgMQQ+dUgSAckNXhapU/NMhDSWLs1B24A8sO1xrN4NECkcAC9ASkiIJc6k5TRiUDPhnyMMdhKc+Zx19l6SgyeW76BEONY9exVQMzKExGKwwPsCzza7KGSSWRWEQhyEaDXp6ZHEr416ygbiKYOd7TEWvvcQIeusHYMJGhTwF9y7sGnSwaWyFAiyoxzqW0PM/RjghPxF2pWReAowTEXnDh0xgcLs8l2YQmOrj3N7ByiqEoH0cARs4u78WgAVkoEDIDoOi3AkcLOHU60RIg5wC4ZuTC7FaHKQm8Hq1fQuSOBvX/sodmNJSB5geaF5CPIkUeecdMxieoRO5jz9bheL6/tXjrwCyX/UYBUcjCaWHljx1xiX6z9xEjkYAzbGVnB8pvLmyXm9ep+W8CmsSHQQY77Zx1zboxAV0w7ybMhQmfqdmmw3nEp1I0Z+FGO6M8LZdoyZnuzzBdjISicKRnpxzI9fPb+0oYXsNdyi+d3h9bm9MWYHFtPeIZfLwzmFDKy1ai3p+PDls1Llz4yyFpferxjnyjJDSEy9CaCx5m2cJPerq6Xm34eTrZt3PqxYO1XOwDYZrFlH1fWnpU38Y9HRze3lj0vOujZcXKuuXm3jP+s3KbZVra7y2EAAAAAASUVORK5CYII=" alt="Poetry">\n  </a>\n  <a href="https://github.com/pre-commit/pre-commit">\n    <img src="https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=flat-square" alt="pre-commit">\n  </a>\n</p>\n<p align="center">\n  <a href="https://pypi.org/project/cloudreactor-procwrapper/">\n    <img src="https://img.shields.io/pypi/v/cloudreactor-procwrapper.svg?logo=python&logoColor=fff&style=flat-square" alt="PyPI Version">\n  </a>\n  <img src="https://img.shields.io/pypi/pyversions/cloudreactor-procwrapper.svg?style=flat-square&logo=python&amp;logoColor=fff" alt="Supported Python versions">\n  <img src="https://img.shields.io/pypi/l/cloudreactor-procwrapper.svg?style=flat-square" alt="License">\n</p>\n\nWraps the execution of processes so that a service API endpoint (\n[CloudReactor](https://cloudreactor.io/))\ncan monitor and manage them. Also implements retries, timeouts, and\nsecret injection from AWS into the environment.\n\n## Installation\n\nInstall this via pip (or your favourite package manager):\n\n`pip install cloudreactor-procwrapper`\n\nFetching secrets from AWS Secrets Manager requires that\n[boto3](https://boto3.amazonaws.com/v1/documentation/api/latest/index.html) is available to import in your python environment.\n\nJSON Path transformation requires that [jsonpath-ng](https://github.com/h2non/jsonpath-ng)\nbe available to import in your python environment.\n\nYou can get the tested versions of both dependencies in\n[proc_wrapper-requirements.in](https://github.com/CloudReactor/cloudreactor-procwrapper/blob/main/proc_wrapper-requirements.in)\n(suitable for use by [https://github.com/jazzband/pip-tools/](pip-tools)) or the resolved requirements in\n[proc_wrapper-requirements.txt](https://github.com/CloudReactor/cloudreactor-procwrapper/blob/main/proc_wrapper-requirements.txt).\n\n\n## Usage\n\n### Wrapped mode\n\nIn wrapped mode, you run the module with a command line which it\nexecutes in a child process. The command can be implemented in whatever\nprogramming language the running machine supports.\n\nInstead of running\n\n    somecommand --somearg x\n\nyou would run\n\n    python -m proc_wrapper somecommand --somearg x\n\nHere are all the options:\n\n    usage: python -m proc_wrapper [-h] [--task-name TASK_NAME]\n                                  [--task-uuid TASK_UUID]\n                                  [--task-execution-uuid TASK_EXECUTION_UUID]\n                                  [--task-version-number TASK_VERSION_NUMBER]\n                                  [--task-version-text TASK_VERSION_TEXT]\n                                  [--task-version-signature TASK_VERSION_SIGNATURE]\n                                  [--task-instance-metadata TASK_INSTANCE_METADATA]\n                                  [--api-base-url API_BASE_URL]\n                                  [--api-key API_KEY]\n                                  [--api-heartbeat-interval API_HEARTBEAT_INTERVAL]\n                                  [--api-error-timeout API_ERROR_TIMEOUT]\n                                  [--api-final-update-timeout API_FINAL_UPDATE_TIMEOUT]\n                                  [--api-retry-delay API_RETRY_DELAY]\n                                  [--api-resume-delay API_RESUME_DELAY]\n                                  [--api-task-execution-creation-error-timeout API_TASK_EXECUTION_CREATION_ERROR_TIMEOUT]\n                                  [--api-task-execution-creation-conflict-timeout API_TASK_EXECUTION_CREATION_CONFLICT_TIMEOUT]\n                                  [--api-task-execution-creation-conflict-retry-delay API_TASK_EXECUTION_CREATION_CONFLICT_RETRY_DELAY]\n                                  [--api-request-timeout API_REQUEST_TIMEOUT]\n                                  [--offline-mode] [--service]\n                                  [--max-concurrency MAX_CONCURRENCY]\n                                  [--max-conflicting-age MAX_CONFLICTING_AGE]\n                                  [--prevent-offline-execution]\n                                  [--log-level LOG_LEVEL] [--log-secrets]\n                                  [--work-dir WORK_DIR]\n                                  [--process-timeout PROCESS_TIMEOUT]\n                                  [--process-max-retries PROCESS_MAX_RETRIES]\n                                  [--process-retry-delay PROCESS_RETRY_DELAY]\n                                  [--process-check-interval PROCESS_CHECK_INTERVAL]\n                                  [--process-termination-grace-period PROCESS_TERMINATION_GRACE_PERIOD]\n                                  [--enable-status-update-listener]\n                                  [--status-update-socket-port STATUS_UPDATE_SOCKET_PORT]\n                                  [--status-update-message-max-bytes STATUS_UPDATE_MESSAGE_MAX_BYTES]\n                                  [--status-update-interval STATUS_UPDATE_INTERVAL]\n                                  [--send-pid] [--send-hostname]\n                                  [--no-send-runtime-metadata]\n                                  [--deployment DEPLOYMENT] [--schedule SCHEDULE]\n                                  [--resolved-env-ttl RESOLVED_ENV_TTL]\n                                  [--rollbar-access-token ROLLBAR_ACCESS_TOKEN]\n                                  [--rollbar-retries ROLLBAR_RETRIES]\n                                  [--rollbar-retry-delay ROLLBAR_RETRY_DELAY]\n                                  [--rollbar-timeout ROLLBAR_TIMEOUT]\n                                  ...\n\n    Wraps the execution of processes so that a service API endpoint (CloudReactor)\n    is optionally informed of the progress. Also implements retries, timeouts, and\n    secret injection from AWS into the environment.\n\n    positional arguments:\n      command\n\n    optional arguments:\n      -h, --help            show this help message and exit\n      --task-name TASK_NAME\n                            Name of Task (either the Task Name or the Task UUID\n                            must be specified\n      --task-uuid TASK_UUID\n                            UUID of Task (either the Task Name or the Task UUID\n                            must be specified)\n      --task-execution-uuid TASK_EXECUTION_UUID\n                            UUID of Task Execution to attach to\n      --task-version-number TASK_VERSION_NUMBER\n                            Numeric version of the Task\'s source code (optional)\n      --task-version-text TASK_VERSION_TEXT\n                            Human readable version of the Task\'s source code\n                            (optional)\n      --task-version-signature TASK_VERSION_SIGNATURE\n                            Version signature of the Task\'s source code (optional)\n      --task-instance-metadata TASK_INSTANCE_METADATA\n                            Additional metadata about the Task instance, in JSON\n                            format (optional)\n      --api-base-url API_BASE_URL\n                            Base URL of API server\n      --api-key API_KEY     API key\n      --api-heartbeat-interval API_HEARTBEAT_INTERVAL\n                            Number of seconds to wait between sending heartbeats\n                            to the API server. -1 means to not send heartbeats.\n                            Defaults to 30 for concurrency limited services, 300\n                            otherwise.\n      --api-error-timeout API_ERROR_TIMEOUT\n                            Number of seconds to wait while receiving recoverable\n                            errors from the API server. Defaults to 300.\n      --api-final-update-timeout API_FINAL_UPDATE_TIMEOUT\n                            Number of seconds to wait while receiving recoverable\n                            errors from the API server when sending the final\n                            update before exiting. Defaults to 1800.\n      --api-retry-delay API_RETRY_DELAY\n                            Number of seconds to wait before retrying an API\n                            request. Defaults to 120.\n      --api-resume-delay API_RESUME_DELAY\n                            Number of seconds to wait before resuming API\n                            requests, after retries are exhausted. Defaults to\n                            600. -1 means no resumption.\n      --api-task-execution-creation-error-timeout API_TASK_EXECUTION_CREATION_ERROR_TIMEOUT\n                            Number of seconds to keep retrying Task Execution\n                            creation while receiving error responses from the API\n                            server. -1 means to keep trying indefinitely. Defaults\n                            to 300.\n      --api-task-execution-creation-conflict-timeout API_TASK_EXECUTION_CREATION_CONFLICT_TIMEOUT\n                            Number of seconds to keep retrying Task Execution\n                            creation while conflict is detected by the API server.\n                            -1 means to keep trying indefinitely. Defaults to 1800\n                            for concurrency limited services, 0 otherwise.\n      --api-task-execution-creation-conflict-retry-delay API_TASK_EXECUTION_CREATION_CONFLICT_RETRY_DELAY\n                            Number of seconds between attempts to retry Task\n                            Execution creation after conflict is detected.\n                            Defaults to 60 for concurrency-limited services, 120\n                            otherwise.\n      --api-request-timeout API_REQUEST_TIMEOUT\n                            Timeout for contacting API server, in seconds.\n                            Defaults to 30.\n      --offline-mode        Do not communicate with or rely on an API server\n      --service             Indicate that this is a Task that should run\n                            indefinitely\n      --max-concurrency MAX_CONCURRENCY\n                            Maximum number of concurrent Task Executions allowed\n                            with the same Task UUID. Defaults to 1.\n      --max-conflicting-age MAX_CONFLICTING_AGE\n                            Maximum age of conflicting processes to consider, in\n                            seconds. -1 means no limit. Defaults to the heartbeat\n                            interval, plus 60 seconds for services that send\n                            heartbeats. Otherwise, defaults to no limit.\n      --prevent-offline-execution\n                            Do not start processes if the API server is\n                            unavailable.\n      --log-level LOG_LEVEL\n                            Log level (DEBUG, INFO, WARNING, ERROR, CRITICAL).\n                            Defaults to WARNING.\n      --log-secrets         Log sensitive information\n      --work-dir WORK_DIR   Working directory\n      --process-timeout PROCESS_TIMEOUT\n                            Timeout for process, in seconds. Defaults to None for\n                            non-services, infinite for services. -1 means no\n                            timeout.\n      --process-max-retries PROCESS_MAX_RETRIES\n                            Maximum number of times to retry failed processes. -1\n                            means to retry forever. Defaults to 0.\n      --process-retry-delay PROCESS_RETRY_DELAY\n                            Number of seconds to wait before retrying a process.\n                            Defaults to 60.\n      --process-check-interval PROCESS_CHECK_INTERVAL\n                            Number of seconds to wait between checking the status\n                            of processes. Defaults to 10.\n      --process-termination-grace-period PROCESS_TERMINATION_GRACE_PERIOD\n                            Number of seconds to wait after sending SIGTERM to a\n                            process, but before killing it with SIGKILL. Defaults\n                            to 30.\n      --enable-status-update-listener\n                            Listen for status updates from the process, sent on\n                            the status socket port via UDP. If not specified,\n                            status update messages will not be read.\n      --status-update-socket-port STATUS_UPDATE_SOCKET_PORT\n                            The port used to receive status updates from the\n                            process. Defaults to 2373.\n      --status-update-message-max-bytes STATUS_UPDATE_MESSAGE_MAX_BYTES\n                            The maximum number of bytes status update messages can\n                            be. Defaults to 65536.\n      --status-update-interval STATUS_UPDATE_INTERVAL\n                            Minimum of seconds to wait between sending status\n                            updates to the API server. -1 means to not send status\n                            updates except with heartbeats. Defaults to -1.\n      --send-pid            Send the process ID to the API server\n      --send-hostname       Send the hostname to the API server\n      --no-send-runtime-metadata\n                            Do not send metadata about the runtime environment\n      --deployment DEPLOYMENT\n                            Deployment name (production, staging, etc.)\n      --schedule SCHEDULE   Run schedule reported to the API server\n      --resolved-env-ttl RESOLVED_ENV_TTL\n                            Number of seconds to cache resolved environment\n                            variables instead of refreshing them when a process\n                            restarts. -1 means to never refresh. Defaults to -1.\n      --rollbar-access-token ROLLBAR_ACCESS_TOKEN\n                            Access token for Rollbar (used to report error when\n                            communicating with API server)\n      --rollbar-retries ROLLBAR_RETRIES\n                            Number of retries per Rollbar request. Defaults to 2.\n      --rollbar-retry-delay ROLLBAR_RETRY_DELAY\n                            Number of seconds to wait before retrying a Rollbar\n                            request. Defaults to 120.\n      --rollbar-timeout ROLLBAR_TIMEOUT\n                            Timeout for contacting Rollbar server, in seconds.\n                            Defaults to 30.\n\nThese environment variables take precedence over command-line arguments:\n\n* PROC_WRAPPER_TASK_NAME\n* PROC_WRAPPER_TASK_UUID\n* PROC_WRAPPER_TASK_EXECUTION_UUID\n* PROC_WRAPPER_TASK_IS_SERVICE\n* PROC_WRAPPER_MAX_CONCURRENCY\n* PROC_WRAPPER_PREVENT_OFFLINE_EXECUTION\n* PROC_WRAPPER_TASK_VERSION_NUMBER\n* PROC_WRAPPER_TASK_VERSION_TEXT\n* PROC_WRAPPER_TASK_VERSION_SIGNATURE\n* PROC_WRAPPER_TASK_INSTANCE_METADATA\n* PROC_WRAPPER_LOG_LEVEL\n* PROC_WRAPPER_DEPLOYMENT\n* PROC_WRAPPER_API_BASE_URL\n* PROC_WRAPPER_API_KEY\n* PROC_WRAPPER_API_HEARTBEAT_INTERVAL_SECONDS\n* PROC_WRAPPER_API_ERROR_TIMEOUT_SECONDS\n* PROC_WRAPPER_API_RETRY_DELAY_SECONDS\n* PROC_WRAPPER_API_RESUME_DELAY_SECONDS\n* PROC_WRAPPER_API_TASK_EXECUTION_CREATION_ERROR_TIMEOUT_SECONDS\n* PROC_WRAPPER_API_TASK_EXECUTION_CREATION_CONFLICT_TIMEOUT_SECONDS\n* PROC_WRAPPER_API_TASK_EXECUTION_CREATION_CONFLICT_RETRY_DELAY_SECONDS\n* PROC_WRAPPER_API_FINAL_UPDATE_TIMEOUT_SECONDS\n* PROC_WRAPPER_API_REQUEST_TIMEOUT_SECONDS\n* PROC_WRAPPER_SEND_PID\n* PROC_WRAPPER_SEND_HOSTNAME\n* PROC_WRAPPER_SEND_RUNTIME_METADATA\n* PROC_WRAPPER_ROLLBAR_ACCESS_TOKEN\n* PROC_WRAPPER_ROLLBAR_TIMEOUT_SECONDS\n* PROC_WRAPPER_ROLLBAR_RETRIES\n* PROC_WRAPPER_ROLLBAR_RETRY_DELAY_SECONDS\n* PROC_WRAPPER_MAX_CONFLICTING_AGE_SECONDS\n* PROC_WRAPPER_WORK_DIR\n* PROC_WRAPPER_PROCESS_MAX_RETRIES\n* PROC_WRAPPER_PROCESS_TIMEOUT_SECONDS\n* PROC_WRAPPER_PROCESS_RETRY_DELAY_SECONDS\n* PROC_WRAPPER_PROCESS_CHECK_INTERVAL_SECONDS\n* PROC_WRAPPER_PROCESS_TERMINATION_GRACE_PERIOD_SECONDS\n* PROC_WRAPPER_STATUS_UPDATE_SOCKET_PORT\n* PROC_WRAPPER_STATUS_UPDATE_MESSAGE_MAX_BYTES\n\nThe command is executed with the same environment that the wrapper script gets,\nexcept that these properties are copied/overridden:\n\n* PROC_WRAPPER_DEPLOYMENT\n* PROC_WRAPPER_API_BASE_URL\n* PROC_WRAPPER_API_KEY\n* PROC_WRAPPER_API_ERROR_TIMEOUT_SECONDS\n* PROC_WRAPPER_API_RETRY_DELAY_SECONDS\n* PROC_WRAPPER_API_RESUME_DELAY_SECONDS\n* PROC_WRAPPER_API_REQUEST_TIMEOUT_SECONDS\n* PROC_WRAPPER_ROLLBAR_ACCESS_TOKEN\n* PROC_WRAPPER_ROLLBAR_TIMEOUT_SECONDS\n* PROC_WRAPPER_ROLLBAR_RETRIES\n* PROC_WRAPPER_ROLLBAR_RETRY_DELAY_SECONDS\n* PROC_WRAPPER_ROLLBAR_RESUME_DELAY_SECONDS\n* PROC_WRAPPER_TASK_EXECUTION_UUID\n* PROC_WRAPPER_TASK_UUID\n* PROC_WRAPPER_TASK_NAME\n* PROC_WRAPPER_TASK_VERSION_NUMBER\n* PROC_WRAPPER_TASK_VERSION_TEXT\n* PROC_WRAPPER_TASK_VERSION_SIGNATURE\n* PROC_WRAPPER_TASK_INSTANCE_METADATA\n* PROC_WRAPPER_SCHEDULE\n* PROC_WRAPPER_PROCESS_TIMEOUT_SECONDS\n* PROC_WRAPPER_MAX_CONCURRENCY\n* PROC_WRAPPER_PREVENT_OFFLINE_EXECUTION\n* PROC_WRAPPER_PROCESS_TERMINATION_GRACE_PERIOD_SECONDS\n* PROC_WRAPPER_ENABLE_STATUS_UPDATE_LISTENER\n* PROC_WRAPPER_STATUS_UPDATE_SOCKET_PORT\n* PROC_WRAPPER_STATUS_UPDATE_INTERVAL_SECONDS\n* PROC_WRAPPER_STATUS_UPDATE_MESSAGE_MAX_BYTES\n\nWrapped mode is suitable for running in a shell on your own (virtual) machine or\nin a Docker container.\n\n### Embedded mode\n\nIn embedded mode, you include this package in your python project\'s\ndependencies. To run a task you want to be monitored:\n\n    from proc_wrapper import ProcWrapper\n\n    def fun(data, config):\n        print(data)\n        return data[\'a\']\n\n    args = ProcWrapper.make_default_args()\n    args.offline_mode = True\n    args.task_name = \'embedded_test\'\n    proc_wrapper = ProcWrapper(args=args)\n    proc_wrapper.managed_call(fun, {\'a\': 1, \'b\': 2})\n\nThis is suitable for running in single-threaded environments like\nAWS Lambda. We do not yet support monitoring your task in embedded mode\nwith CloudReactor, but will do so in the near future.\n\n### Secret Fetching\n\nBoth usage modes can fetch secrets from\n[AWS Secrets Manager](https://aws.amazon.com/secrets-manager/), optionally extract\nembedded data, then inject them into the environment (in the case of wrapped mode)\nor a configuration dictionary (in the case of embedded mode).\n\nTo enable secret resolution, set environment variable\n\n    PROC_WRAPPER_RESOLVE_SECRETS\n\nto\n\n    TRUE\n\nThen to resolve the target environment variable `MY_SECRET`\nby fetching from AWS Secrets Manager, define the environment variable\n\n    AWS_SM_MY_SECRET_FOR_PROC_WRAPPER_TO_RESOLVE\n\nset to the ARN of the secret, for example:\n\n    arn:aws:secretsmanager:us-east-2:1234567890:secret:config-PPrpY\n\nThen when the wrapped process is run, it will see the environment variable\nMY_SECRET resolved to the value of the secret in Secrets Manager. Or, if\nrunning in embedded mode, the `config` dict argument will have the key\n`MY_SECRET` mapped to the value of the secret.\n\nIf the secret was stored in Secrets Manager as binary, the\ncorresponding environment variable will be set to the Base-64 encoded value.\n\nboto3 is used to fetch secrets. It will try to access to AWS Secrets Manager\nusing environment variables AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY if they\nare set, or use the EC2 instance role, ECS task role, or Lambda execution role\nif available.\n\nYou can also use "partial ARNs" (without the hyphened suffix) as keys.\nIn the example above\n\n    arn:aws:secretsmanager:us-east-2:1234567890:secret:config\n\ncould be used to fetch the same secret, provided there are no conflicting secret ARNs.\n\n### Secret Tranformation\n\nSecret fetching is relatively expensive and it makes sense to group related\nsecrets together. Therefore it is common to store JSON values as secrets.\nTo facilitate this, pieces of JSON values can be extracted to individual\nenvironment variables using [jsonpath-ng](https://github.com/h2non/jsonpath-ng).\nTo specify that a variable be extracted from a JSON value using\na JSON Path expression, append "|JP:" followed by the JSON Path expression\nin the environment variable value. For example, if the AWS Secrets Manager\nARN is\n\n    arn:aws:secretsmanager:us-east-2:1234567890:secret:dbconfig-PPrpY\n\nand the value is\n\n    {\n      "username": "postgres",\n      "password": "badpassword"\n    }\n\nThen you can populate the environment variable `DB_USERNAME` by setting the\nenvironment variable\n\n    AWS_SM_DB_USERNAME_FOR_PROC_WRAPPER_TO_RESOLVE\n\nto\n\n    arn:aws:secretsmanager:us-east-2:1234567890:secret:dbconfig-PPrpY|JP:$.username\n\nIf you do something similar to get the password from the same JSON value, proc_wrapper is\nsmart enough to cache the JSON value, so that the secret is only fetched once.\n\nSince JSON path expressions yield a list of results, we implement the following rules to\ntransform the list to the environment variable value:\n\n1. If the list of results has a single value, that value is used as the environment variable value,\nunless `[*]` is appended to the JSON path expression. If the value is boolean, the value\nwill be converted to either "TRUE" or "FALSE". If the value is a string or number, it will\nbe simply left/converted to a string. Otherwise, the value is serialized to a JSON string\nand set to the environment variable value.\n2. Otherwise, the list of results is serialized to a JSON string and set to the environment variable value.\n\n### Secrets Refreshing\n\nYou can set a Time to Live (TTL) on the duration that secrets are cached,\nusing the --resolved-env-ttl command argument or PROC_WRAPPER_RESOLVED_ENV_TTL_SECONDS environment variable.\n\nIf your process exits, you have configured the script to retry, and the TTL has expired since the last fetch, proc_wrapper will re-fetch the secrets\nand resolve them again, for the environment passed to the next invocation of\nyour process.\n\n### Status Updates\n\nAs your process or function runs, you can send status updates to CloudReactor by using\nthe StatusUpdater class. Status updates are shown in the CloudReactor dashboard and\nallow you to track the current progress of a Task and also how many items are being\nprocessed in multiple executions over time.\n\nIn wrapped mode, your application code would send updates to the proc_wrapper\nprorgram via UDP port 2373 (configurable with the PROC_WRAPPER_STATUS_UPDATE_PORT\nenvironment variable). If your application code is in python, you can use the\nprovided StatusUpdater class to do this:\n\n    from proc_wrapper import StatusUpdater\n\n    with StatusUpdater() as updater:\n        updater.send_update(last_status_message=\'Starting ...\')\n        success_count = 0\n\n        for i in range(100):\n            try:\n                do_work()\n                success_count += 1\n                updater.send_update(success_count=success_count)\n            except Exception:\n                failed_count += 1\n                updater.send_update(failed_count=failed_count)\n\n        updater.send_update(last_status_message=\'Finished!\')\n\n\n## Example Project\n\nThe [cloudreactor-ecs-quickstart](https://github.com/CloudReactor/cloudreactor-ecs-quickstart)\nproject uses this library to deploy some sample tasks, written in python, to CloudReactor,\nrunning using AWS ECS Fargate.\n\n## License\n\nThis software is dual-licensed under open source (MPL 2.0) and commercial licenses. See `LICENSE` for details.\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<!-- markdownlint-enable -->\n<!-- prettier-ignore-end -->\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n\n## Credits\n\nThis package was created with\n[Cookiecutter](https://github.com/audreyr/cookiecutter) and the\n[browniebroke/cookiecutter-pypackage](https://github.com/browniebroke/cookiecutter-pypackage)\nproject template.\n',
    'author': 'Jeff Tsay',
    'author_email': 'jeff@cloudreactor.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/CloudReactor/cloudreactor-procwrapper',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
