# Copyright (c) 2020 Dell Inc. or its subsidiaries.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""performance_category_map.py."""

performance_data = {
    'ARRAY': {
        'category': 'Array',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 88,
        'metrics_kpi_cnt': 38,
        'metrics_all': [
            'AllocatedCapacity', 'AllocatedCapacityTB', 'AvgFallThruTime',
            'AvgOptimizedReadMissSize', 'BEIOs', 'BEReadReqs', 'BEReqs',
            'BEUtilization', 'BEWriteReqs', 'Cache_Balance', 'CapacityHS',
            'CopySlotCount', 'CriticalAlertCount', 'DA_Balance', 'DX_Balance',
            'DeviceWPEvents', 'DiskUtilization', 'EFD_Balance', 'FC_Balance',
            'FEHitReqs', 'FEReadHitReqs', 'FEReadMissReqs', 'FEReadReqs',
            'FEReqs', 'FEUtilization', 'FEWriteHitReqs', 'FEWriteMissReqs',
            'FEWriteReqs', 'FE_Balance', 'HWConfigHS', 'HardwareHealthScore',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs', 'HostReads',
            'HostWrites', 'InfoAlertCount', 'OptimizedMBReadMisses',
            'OptimizedReadMisses', 'OverallCompressionRatio',
            'OverallEfficiencyRatio', 'OverallHealthScore', 'PercentCacheWP',
            'PercentEffectiveUsedCapacity', 'PercentHit', 'PercentMetaBEUsed',
            'PercentMetaFEUsed', 'PercentMetaRepUsed', 'PercentMetaSystemUsed',
            'PercentReads', 'PercentSnapshotSaved',
            'PercentSubscribedCapacity', 'PercentVPSaved', 'PercentWrites',
            'PrefetchedTracks', 'QueueDepthUtilization', 'RDFA_WPCount',
            'RDFUtilization', 'RDF_Balance', 'ReadResponseTime',
            'SATA_Balance', 'SCM_Balance', 'SloHealthScore', 'SnapCapGB',
            'SnapCapTB', 'SnapModifiedCapGB', 'SnapModifiedCapTB',
            'SnapshotCompressionRatio', 'SnapshotEfficiencyRatio',
            'SnapshotSharedRatio', 'SoftwareHealthScore',
            'SubscribedAllocatedCapGB', 'SubscribedAllocatedCapTB',
            'SubscribedCapacity', 'SubscribedCapacityTB', 'SystemMaxWPLimit',
            'SystemWPEvents', 'UsableCapacity', 'UsableCapacityTB',
            'UsedUsableCapGB', 'UsedUsableCapTB', 'VPCompressionRatio',
            'VPEfficiencyRatio', 'VPSharedRatio', 'WPCount',
            'WarningAlertCount', 'WriteResponseTime'],
        'metrics_kpi': [
            'AllocatedCapacity', 'AllocatedCapacityTB', 'BEIOs',
            'BEUtilization', 'Cache_Balance', 'DA_Balance', 'DX_Balance',
            'DiskUtilization', 'EFD_Balance', 'FC_Balance', 'FEUtilization',
            'FE_Balance', 'HostIOs', 'HostMBs', 'OverallCompressionRatio',
            'PercentCacheWP', 'PercentHit', 'PercentMetaBEUsed',
            'PercentMetaFEUsed', 'PercentMetaRepUsed', 'PercentMetaSystemUsed',
            'PercentReads', 'PercentWrites', 'RDFUtilization', 'RDF_Balance',
            'ReadResponseTime', 'SATA_Balance', 'SCM_Balance', 'SnapCapTB',
            'SnapModifiedCapTB', 'SubscribedAllocatedCapTB',
            'SubscribedCapacityTB', 'SystemMaxWPLimit', 'SystemWPEvents',
            'UsableCapacityTB', 'UsedUsableCapTB', 'WPCount',
            'WriteResponseTime']},
    'BEDIRECTOR': {
        'category': 'BEDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 26,
        'metrics_kpi_cnt': 10,
        'metrics_all': [
            'AvgTimePerSyscall', 'CompressedMBs', 'CompressedReadMBs',
            'CompressedReadReqs', 'CompressedReqs', 'CompressedWriteMBs',
            'CompressedWriteReqs', 'IOs', 'MBRead', 'MBWritten', 'MBs',
            'PercentBusy', 'PercentBusyLogicalCore_0',
            'PercentBusyLogicalCore_1', 'PercentNonIOBusy',
            'PercentNonIOBusyLogicalCore_0', 'PercentNonIOBusyLogicalCore_1',
            'PercentReadReqs', 'PercentWriteReqs', 'PrefetchedTracks',
            'ReadReqs', 'Reqs', 'SyscallCount', 'SyscallRemoteDirCount',
            'Syscall_RDF_DirCount', 'WriteReqs'],
        'metrics_kpi': [
            'IOs', 'MBRead', 'MBWritten', 'MBs', 'PercentBusy',
            'PercentNonIOBusy', 'ReadReqs', 'Reqs', 'SyscallCount',
            'WriteReqs']},
    'BEEMULATION': {
        'category': 'BeEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'BEPORT': {
        'category': 'BEPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 9,
        'metrics_kpi_cnt': 8,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'MaxSpeedGBs',
            'PercentBusy', 'Reads', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'PercentBusy',
            'Reads', 'Writes']},
    'BOARD': {
        'category': 'Board',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 4,
        'metrics_kpi_cnt': 4,
        'metrics_all': [
            'InboundMBs', 'InterConnect', 'MaxSpeedMBs', 'OutboundMBs'],
        'metrics_kpi': [
            'InboundMBs', 'InterConnect', 'MaxSpeedMBs', 'OutboundMBs']},
    'CACHEPARTITION': {
        'category': 'CachePartition',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 44,
        'metrics_kpi_cnt': 10,
        'metrics_all': [
            'AcquiredSlotCount', 'AgeNonWPSlots', 'AvgAgeGivenDestage',
            'AvgAgeOfWriteToNonWPSlots', 'CacheAgeGT_10_Min',
            'CacheAgeGT_1_Hour', 'CacheAgeGT_1_Min', 'CacheHitAges_1',
            'CacheHitAges_2', 'CacheHitAges_3', 'CacheHitAges_4',
            'CacheHitAges_5', 'CacheHitAges_6', 'CacheHitAges_7',
            'CacheHitAges_8', 'CacheSlotAges_1', 'CacheSlotAges_2',
            'CacheSlotAges_3', 'CacheSlotAges_4', 'CacheSlotAges_5',
            'CacheSlotAges_6', 'CacheSlotAges_7', 'CacheSlotAges_8',
            'CacheSlotsUsed', 'DestageSlotAge', 'DestagedSlotCount',
            'DonationGiveCount', 'DonationTakeCount', 'DonationTime',
            'HostIOs', 'HostMBs', 'LocalWPCount', 'PercentCacheUsed',
            'PercentHit', 'PercentMaxCache', 'PercentMinCache',
            'PercentTargetCache', 'PercentWPUtilization', 'RemoteWPCount',
            'SystemMaxWPLimit', 'TotalReplaceSlots', 'WPCount',
            'WritesToAllNonWPSlots', 'WritesToYoungNonWPSlots'],
        'metrics_kpi': [
            'CacheSlotsUsed', 'HostIOs', 'HostMBs', 'PercentHit',
            'PercentMaxCache', 'PercentMinCache', 'PercentTargetCache',
            'PercentWPUtilization', 'SystemMaxWPLimit', 'WPCount']},
    'DATABASE': {
        'category': 'Database',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 107,
        'metrics_kpi_cnt': 23,
        'metrics_all': [
            'AllocatedCapacity', 'AvgIOSize', 'AvgReadResponseTime6',
            'AvgReadResponseTime7', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteResponseTime6', 'AvgWriteResponseTime7', 'AvgWriteSize',
            'BEDiskReadResponseTime', 'BEMBReads', 'BEMBTransferred',
            'BEMBWritten', 'BEPercentReads', 'BEPercentWrites',
            'BEPrefetchedMBs', 'BEPrefetchedTrackUsed', 'BEPrefetchedTrackss',
            'BEReadReqs', 'BEReadRequestTime', 'BEReadTaskTime',
            'BEReqs', 'BEWriteReqs', 'BlockSize', 'CriticalAlertCount',
            'HostHits', 'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs',
            'HostMisses', 'HostReadHits', 'HostReadMisses', 'HostReads',
            'HostWriteHits', 'HostWriteMisses', 'HostWrites', 'IODensity',
            'InfoAlertCount', 'MaxWPThreshold', 'PercentHit',
            'PercentMisses', 'PercentRandomIO', 'PercentRandomReadHit',
            'PercentRandomReadMiss', 'PercentRandomReads',
            'PercentRandomWriteHit', 'PercentRandomWriteMiss',
            'PercentRandomWrites', 'PercentRead', 'PercentReadHit',
            'PercentReadMiss', 'PercentSeqIO', 'PercentSeqRead',
            'PercentSeqReadHit', 'PercentSeqReadMiss', 'PercentSeqWriteHit',
            'PercentSeqWriteMiss', 'PercentSeqWrites', 'PercentWrite',
            'PercentWriteHit', 'PercentWriteMiss', 'RDFRewrites',
            'RDFS_WriteResponseTime', 'RandomIOs', 'RandomReadHits',
            'RandomReadMisses', 'RandomReads', 'RandomWriteHits',
            'RandomWriteMisses', 'RandomWrites', 'RdfMBRead', 'RdfMBWritten',
            'RdfReadHits', 'RdfReads', 'RdfResponseTime', 'RdfWrites',
            'ReadMissResponseTime', 'ReadResponseTime',
            'ReadResponseTimeCount1', 'ReadResponseTimeCount2',
            'ReadResponseTimeCount3', 'ReadResponseTimeCount4',
            'ReadResponseTimeCount5', 'ReadResponseTimeCount6',
            'ReadResponseTimeCount7', 'ResponseTime', 'SeqIOs', 'SeqReadHits',
            'SeqReadMisses', 'SeqReads', 'SeqWriteHits', 'SeqWriteMisses',
            'SeqWrites', 'Skew', 'WPCount', 'WarningAlertCount',
            'WriteMissResponseTime', 'WritePacedDelay', 'WriteResponseTime',
            'WriteResponseTimeCount1', 'WriteResponseTimeCount2',
            'WriteResponseTimeCount3', 'WriteResponseTimeCount4',
            'WriteResponseTimeCount5', 'WriteResponseTimeCount6',
            'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEReqs', 'BEWriteReqs',
            'HostHits', 'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs',
            'HostMisses', 'HostReads', 'HostWrites', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite',
            'RDFS_WriteResponseTime', 'RdfResponseTime', 'ReadResponseTime',
            'ResponseTime', 'WPCount', 'WritePacedDelay',
            'WriteResponseTime']},
    'DEVICEGROUP': {
        'category': 'DeviceGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 86,
        'metrics_kpi_cnt': 29,
        'metrics_all': [
            'AllocatedCapacity', 'AvgIOSize', 'AvgReadSize',
            'AvgWritePacedDelay', 'AvgWriteSize', 'BEDisk ReadResponseTime ',
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedMBs', 'BEPrefetchedTrackUsed',
            'BEPrefetchedTrackss', 'BERdfCopy', 'BERdfCopyMB', 'BEReadReqs',
            'BEReadRequestTime', 'BEReadTaskTime', 'BEReqs', 'BEWriteReqs',
            'BlockSize', 'HostHits', 'HostIOs', 'HostMBReads', 'HostMBWritten',
            'HostMBs', 'HostMisses', 'HostReadHits', 'HostReadMisses',
            'HostReads', 'HostWriteHits', 'HostWriteMisses', 'HostWrites',
            'IODensity', 'MaxWPThreshold', 'PercentHit', 'PercentMisses',
            'PercentRandomIO', 'PercentRandomReadHit', 'PercentRandomReadMiss',
            'PercentRandomReads', 'PercentRandomWriteHit',
            'PercentRandomWriteMiss', 'PercentRandomWrites', 'PercentRead',
            'PercentReadHit', 'PercentReadMiss', 'PercentSeqIO',
            'PercentSeqRead', 'PercentSeqReadHit', 'PercentSeqReadMiss',
            'PercentSeqWriteHit', 'PercentSeqWriteMiss', 'PercentSeqWrites',
            'PercentWrite', 'PercentWriteHit', 'PercentWriteMiss',
            'RDFRewrites', 'RDFS_WriteResponseTime', 'RandomIOs',
            'RandomReadHits', 'RandomReadMisses', 'RandomReads',
            'RandomWriteHits', 'RandomWriteMisses', 'RandomWrites',
            'RdfMBRead', 'RdfMBWritten', 'RdfReads', 'RdfResponseTime',
            'RdfWrites', 'ReadMissResponseTime', 'ReadResponseTime',
            'ResponseTime', 'SeqIOs', 'SeqReadHits', 'SeqReadMisses',
            'SeqReads', 'SeqWriteHits', 'SeqWriteMisses', 'SeqWrites',
            'WPCount', 'WriteMissResponseTime', 'WritePacedDelay',
            'WriteResponseTime'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEReqs', 'BEWriteReqs',
            'HostHits', 'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs',
            'HostMisses', 'HostReads', 'HostWrites', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite',
            'RDFS_WriteResponseTime', 'RandomIOs', 'RandomReads',
            'RandomWrites', 'RdfResponseTime', 'ReadResponseTime',
            'ResponseTime', 'SeqIOs', 'SeqReads', 'SeqWrites', 'WPCount',
            'WritePacedDelay', 'WriteResponseTime']},
    'DISKGROUP': {
        'category': 'DiskGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 20,
        'metrics_kpi_cnt': 15,
        'metrics_all': [
            'AvgReadSize', 'AvgWriteSize', 'DiskReads', 'DiskWrites',
            'IODensity', 'IOs', 'MBReads', 'MBWritten', 'MBs', 'PercentBusy',
            'PercentCapacityFree', 'PercentCapacityUsed', 'PercentIdle',
            'ReadResponseTime', 'ResponseTime', 'TotalCapacity',
            'TotalSCSICommands', 'UnmapCommandCount', 'UsedCapacity',
            'WriteResponseTime'],
        'metrics_kpi': [
            'DiskReads', 'DiskWrites', 'IODensity', 'IOs', 'MBReads',
            'MBWritten', 'MBs', 'PercentBusy', 'PercentCapacityFree',
            'PercentCapacityUsed', 'ReadResponseTime', 'ResponseTime',
            'TotalCapacity', 'UsedCapacity', 'WriteResponseTime']},
    'EDSDIRECTOR': {
        'category': 'EDSDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 5,
        'metrics_kpi_cnt': 1,
        'metrics_all': [
            'PercentBusy', 'RandomReadMissMBs', 'RandomReadMisses',
            'RandomWriteMissMBs', 'RandomWriteMisses'],
        'metrics_kpi': ['PercentBusy']},
    'EDSEMULATION': {
        'category': 'EDSEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'EXTERNALDISK': {
        'category': 'ExternalDisk',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 18,
        'metrics_kpi_cnt': 13,
        'metrics_all': [
            'AvgQueueDepth', 'AvgReadSize', 'AvgWriteSize', 'DiskReads',
            'DiskWrites', 'IOs', 'MBReads', 'MBWrittens', 'MBs', 'PercentBusy',
            'PercentCapacityUsed', 'PercentIdle', 'ReadResponseTime',
            'ResponseTime', 'TotalCapacity', 'UnmapCommandCount',
            'Used Capacity', 'WriteResponseTime'],
        'metrics_kpi': [
            'DiskReads', 'DiskWrites', 'IOs', 'MBReads', 'MBWrittens', 'MBs',
            'PercentBusy', 'PercentCapacityUsed', 'ReadResponseTime',
            'ResponseTime', 'TotalCapacity', 'Used Capacity',
            'WriteResponseTime']},
    'FEDIRECTOR': {
        'category': 'FEDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 91,
        'metrics_kpi_cnt': 11,
        'metrics_all': [
            'AvgOptimizedReadMissSize', 'AvgQueueDepthRange0',
            'AvgQueueDepthRange1', 'AvgQueueDepthRange2',
            'AvgQueueDepthRange3', 'AvgQueueDepthRange4',
            'AvgQueueDepthRange5', 'AvgQueueDepthRange6',
            'AvgQueueDepthRange7', 'AvgQueueDepthRange8',
            'AvgQueueDepthRange9', 'AvgRDFSWriteResponseTime',
            'AvgReadMissResponseTime', 'AvgReadRT0To1', 'AvgReadRT16To32',
            'AvgReadRT1To2', 'AvgReadRT2To4', 'AvgReadRT32To64',
            'AvgReadRT4To8', 'AvgReadRT8To16', 'AvgReadRTOver64',
            'AvgTimePerSyscall', 'AvgWPDiscTime', 'AvgWriteRT0To1',
            'AvgWriteRT16To32', 'AvgWriteRT1To2', 'AvgWriteRT2To4',
            'AvgWriteRT32To64', 'AvgWriteRT4To8', 'AvgWriteRT8To16',
            'AvgWriteRTOver64', 'DeviceWPEvents', 'HitReqs', 'HostIOLimitIOs',
            'HostIOLimitMBs', 'HostIOs', 'HostMBs', 'MissReqs',
            'OptimizedMBReadMisses', 'OptimizedReadMisses', 'PercentBusy',
            'PercentBusyLogicalCore_0', 'PercentBusyLogicalCore_1',
            'PercentHitReqs', 'PercentReadReqHit', 'PercentReadReqs',
            'PercentWriteReqHit', 'PercentWriteReqs', 'QueueDepthCountRange0',
            'QueueDepthCountRange1', 'QueueDepthCountRange2',
            'QueueDepthCountRange3', 'QueueDepthCountRange4',
            'QueueDepthCountRange5', 'QueueDepthCountRange6',
            'QueueDepthCountRange7', 'QueueDepthCountRange8',
            'QueueDepthCountRange9', 'QueueDepthUtilization', 'ReadHitReqs',
            'ReadMissReqs', 'ReadRTCountRange0To1', 'ReadRTCountRange16To32',
            'ReadRTCountRange1To2', 'ReadRTCountRange2To4',
            'ReadRTCountRange32To64', 'ReadRTCountRange4To8',
            'ReadRTCountRange8To16', 'ReadRTCountRangeover64', 'ReadReqs',
            'ReadResponseTime', 'Reqs', 'SlotCollisions', 'SyscallCount',
            'SyscallRemoteDirCounts', 'Syscall_RDF_DirCounts',
            'SystemWPEvents', 'TotalReadCount', 'TotalWriteCount',
            'WriteHitReqs', 'WriteMissReqs', 'WriteRTCountRange0To1',
            'WriteRTCountRange16To32', 'WriteRTCountRange1To2',
            'WriteRTCountRange2To4', 'WriteRTCountRange32To64',
            'WriteRTCountRange4To8', 'WriteRTCountRange8To16',
            'WriteRTCountRangeover64', 'WriteReqs', 'WriteResponseTime'],
        'metrics_kpi': [
            'HostIOLimitIOs', 'HostIOLimitMBs', 'HostIOs', 'HostMBs',
            'PercentBusy', 'PercentBusyLogicalCore_0',
            'PercentBusyLogicalCore_1', 'QueueDepthUtilization',
            'ReadResponseTime', 'SyscallCount', 'WriteResponseTime']},
    'FEEMULATION': {
        'category': 'FeEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'FEPORT': {
        'category': 'FEPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 13,
        'metrics_kpi_cnt': 12,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'MaxSpeedGBs',
            'PercentBusy', 'ReadResponseTime', 'Reads', 'ResponseTime',
            'SpeedGBs', 'WriteResponseTime', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'PercentBusy',
            'ReadResponseTime', 'Reads', 'ResponseTime', 'SpeedGBs',
            'WriteResponseTime', 'Writes']},
    'FICONEMULATION': {
        'category': 'FiconEmulation',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all_cnt': 1,
        'metrics_kpi_cnt': 1,
        'metrics_all': ['PercentBusy'],
        'metrics_kpi': ['PercentBusy']},
    'FICONEMULATIONTHREAD': {
        'category': 'FiconEmulationThread',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'PercentIdle'],
        'metrics_kpi': ['PercentBusy', 'PercentIdle']},
    'FICONPORTTHREAD': {
        'category': 'FiconPortThread',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'PercentIdle'],
        'metrics_kpi': ['PercentBusy', 'PercentIdle']},
    'HOST': {
        'category': 'Host',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 12,
        'metrics_kpi_cnt': 10,
        'metrics_all': [
            'BandwidthLimit', 'BandwidthLimitExceededSecs', 'HostIOs',
            'HostMBReads', 'HostMBWrites', 'MBs', 'ReadResponseTime', 'Reads',
            'ResponseTime', 'SyscallCount', 'WriteResponseTime', 'Writes'],
        'metrics_kpi': [
            'HostIOs', 'HostMBReads', 'HostMBWrites', 'MBs',
            'ReadResponseTime', 'Reads', 'ResponseTime', 'SyscallCount',
            'WriteResponseTime', 'Writes']},
    'IMDIRECTOR': {
        'category': 'IMDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 1,
        'metrics_kpi_cnt': 1,
        'metrics_all': ['PercentBusy'],
        'metrics_kpi': ['PercentBusy']},
    'IMEMULATION': {
        'category': 'IMEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'INITIATOR': {
        'category': 'Initiator',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 11,
        'metrics_kpi_cnt': 10,
        'metrics_all': [
            'BandwidthLimitExceededSecs', 'HostIOs', 'HostMBReads',
            'HostMBWrites', 'MBs', 'ReadResponseTime', 'Reads', 'ResponseTime',
            'SyscallCount', 'WriteResponseTime', 'Writes'],
        'metrics_kpi': [
            'HostIOs', 'HostMBReads', 'HostMBWrites', 'MBs',
            'ReadResponseTime', 'Reads', 'ResponseTime', 'SyscallCount',
            'WriteResponseTime', 'Writes']},
    'IPINTERFACE': {
        'category': 'IPInterface',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 8,
        'metrics_kpi_cnt': 5,
        'metrics_all': [
            'IoRate', 'MBs', 'PacketCount', 'Reads', 'ResponseTime',
            'TotalReadTime', 'TotalWriteTime', 'Writes'],
        'metrics_kpi': [
            'IoRate', 'MBs', 'PacketCount', 'Reads', 'Writes']},
    'ISCSITARGET': {
        'category': 'ISCSITarget',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 8,
        'metrics_kpi_cnt': 5,
        'metrics_all': [
            'IoRate', 'MBs', 'PacketCount', 'Reads', 'ResponseTime',
            'TotalReadTime', 'TotalWriteTime', 'Writes'],
        'metrics_kpi': [
            'IoRate', 'MBs', 'PacketCount', 'Reads', 'Writes']},
    'MASKINGVIEW': {
        'category': 'MaskingView',
        'can_alert': False,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all_cnt': 6,
        'metrics_kpi_cnt': 3,
        'metrics_all': [
            'Capacity', 'HostIOs', 'HostMBs', 'ReadResponseTime',
            'ResponseTime', 'WriteResponseTime'],
        'metrics_kpi': [
            'HostIOs', 'HostMBs', 'ResponseTime']},
    'PORTGROUP': {
        'category': 'PortGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 8,
        'metrics_kpi_cnt': 8,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'PercentBusy',
            'Reads', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'PercentBusy',
            'Reads', 'Writes']},
    'RDFA': {
        'category': 'RDFA',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 51,
        'metrics_kpi_cnt': 8,
        'metrics_all': [
            'ActiveCycleSize', 'AvgCycleSize', 'AvgCycleTime',
            'AvgIOServiceTime', 'CompressedMBReceived', 'CompressedMBSent',
            'CompressedMBSentAndReceived', 'CycleNumber', 'DSEThreshold',
            'DSEUsedTracks', 'InactiveCycleSize', 'LastCycleDuration',
            'LocalWPCount', 'MBReads', 'MBWritten', 'NumDevsInSession',
            'NumberOfCompressedLinks', 'NumberOfLinks',
            'NumberOfRDFInvalidTracks', 'PercentCompressedMBReceived',
            'PercentCompressedMBSent', 'PercentCompressedMBSentAndReceived',
            'R1_R2_Lag_Time', 'R2_LastRestoreTime', 'RDFA_ActiveIndicator',
            'RDFA_SessionIndicator', 'RDFA_WPCount', 'RDFRewrites',
            'RDF_R1_R2_IOs', 'RDF_R1_R2_MBs', 'RDF_R2_R1_IOS',
            'RDF_R2_R1_MBs', 'RdfMBRead', 'RdfMBWritten', 'RdfReads',
            'RdfResponseTime', 'RdfWrites', 'ReadHits', 'SessionNumber',
            'SpillOverPackedSlots', 'SystemWPCount', 'SystemWPLimit',
            'TimeSinceLastSwitch', 'TotalHARepeatWrites', 'TotalHAWrites',
            'TotalReads', 'TotalTracksSpilledBack', 'TotalTracksSpilledOver',
            'TotalTracksSpilledOverUsed', 'TotalWrites', 'UncommittedTracks'],
        'metrics_kpi': [
            'AvgCycleSize', 'AvgCycleTime', 'AvgIOServiceTime', 'LocalWPCount',
            'RDFA_WPCount', 'RDF_R1_R2_IOs', 'RDF_R1_R2_MBs',
            'RdfResponseTime']},
    'RDFS': {
        'category': 'RDFS',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 85,
        'metrics_kpi_cnt': 22,
        'metrics_all': [
            'AvgIOSize', 'AvgReadSize', 'AvgWritePacedDelay', 'AvgWriteSize',
            'BEDiskReadResponseTime', 'BEMBReads', 'BEMBTransferred',
            'BEMBWritten', 'BEPercentReads', 'BEPercentWrites',
            'BEPrefetchedMBs', 'BEPrefetchedTrackUsed', 'BEPrefetchedTrackss',
            'BEReadReqs', 'BEReadRequestTime', 'BEReadTaskTime', 'BEReqs',
            'BEWriteReqs', 'BlockSize', 'HostHits', 'HostIOs', 'HostMBReads',
            'HostMBWritten', 'HostMBs', 'HostMisses', 'HostReadHits',
            'HostReadMisses', 'HostReads', 'HostWriteHits', 'HostWriteMisses',
            'HostWrites', 'IODensity', 'MaxWPThreshold', 'PercentHit',
            'PercentMisses', 'PercentRandomIO', 'PercentRandomReadHit',
            'PercentRandomReadMiss', 'PercentRandomReads',
            'PercentRandomWriteHit', 'PercentRandomWriteMiss',
            'PercentRandomWrites', 'PercentRead', 'PercentReadHit',
            'PercentReadMiss', 'PercentSeqIO', 'PercentSeqRead',
            'PercentSeqReadHit', 'PercentSeqReadMiss', 'PercentSeqWriteHit',
            'PercentSeqWriteMiss', 'PercentSeqWrites', 'PercentWrite',
            'PercentWriteHit', 'PercentWriteMiss', 'RDFS_WriteResponseTime',
            'RandomIOs', 'RandomReadHits', 'RandomReadMisses',
            'RandomReads', 'RandomWriteHits', 'RandomWriteMisses',
            'RandomWrites', 'RdfMBsReadPerSec', 'RdfMBsWrittenPerSec',
            'RdfReadHitsPerSec', 'RdfReadsPerSec', 'RdfRewritesPerSec',
            'RdfWritesPerSec', 'ReadMissResponseTime', 'ReadResponseTime',
            'ResponseTime', 'SeqIOs', 'SeqReadHits', 'SeqReadMisses',
            'SeqReads', 'SeqWriteHits', 'SeqWriteMisses', 'SeqWrites',
            'SpillOverPackedSlots', 'TotalCapacityGB', 'WPCount',
            'WriteMissResponseTime', 'WritePacedDelay', 'WriteResponseTime'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEReqs', 'BEWriteReqs',
            'HostHits', 'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs',
            'HostMisses', 'HostReads', 'HostWrites', 'PercentHit',
            'PercentMisses', 'PercentRead', 'PercentWrite',
            'RDFS_WriteResponseTime', 'ReadResponseTime', 'ResponseTime',
            'WPCount', 'WritePacedDelay', 'WriteResponseTime']},
    'RDFDIRECTOR': {
        'category': 'RDFDirector',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 32,
        'metrics_kpi_cnt': 9,
        'metrics_all': [
            'AsyncMBSent', 'AsyncWriteReqs', 'AvgIOServiceTime',
            'AvgIOSizeReceived', 'AvgIOSizeSent', 'AvgTimePerSyscall',
            'CompresedMBReceived', 'CompresedMBSent',
            'CompresedMBSentAndReceived', 'CopyIOs', 'CopyMBs', 'IOs',
            'MBRead', 'MBSentAndReceived', 'MBWritten',
            'NumberOfCompresedLinks', 'NumberOfLinks',
            'PercentBusy', 'PercentCompresedMBReceived',
            'PercentCompresedMBSent', 'PercentCompresedMBSentAndReceived',
            'Reqs', 'Rewrites', 'SyncMBSent', 'SyncWrites', 'SyscallCount',
            'SyscallRemoteDirCount', 'SyscallTime', 'Syscall_RDF_DirCounts',
            'TracksReceivedPerSec', 'TracksSentPerSec', 'WriteReqs'],
        'metrics_kpi': [
            'AvgIOServiceTime', 'CopyIOs', 'CopyMBs', 'IOs', 'MBRead',
            'MBSentAndReceived', 'MBWritten', 'PercentBusy', 'WriteReqs']},
    'RDFEMULATION': {
        'category': 'RDFEmulation',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 2,
        'metrics_kpi_cnt': 2,
        'metrics_all': ['PercentBusy', 'TotalWorkTime'],
        'metrics_kpi': ['PercentBusy', 'TotalWorkTime']},
    'RDFPORT': {
        'category': 'RDFPort',
        'can_alert': True,
        'diagnostics': True,
        'real_time': True,
        'thresholds': True,
        'metrics_all_cnt': 10,
        'metrics_kpi_cnt': 9,
        'metrics_all': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'MaxSpeedGBs',
            'PercentBusy', 'Reads', 'SpeedGBs', 'Writes'],
        'metrics_kpi': [
            'AvgIOSize', 'IOs', 'MBRead', 'MBWritten', 'MBs', 'PercentBusy',
            'Reads', 'SpeedGBs', 'Writes']},
    'STORAGECONTAINER': {
        'category': 'StorageContainer',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 114,
        'metrics_kpi_cnt': 24,
        'metrics_all': [
            'AllocatedCapacity', 'AvgIOSize', 'AvgReadResponseTime6',
            'AvgReadResponseTime7', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteResponseTime6', 'AvgWriteResponseTime7', 'AvgWriteSize',
            'BEDiskReadResponseTime', 'BEMBReads', 'BEMBTransferred',
            'BEMBWritten', 'BEPercentReads', 'BEPercentWrites',
            'BEPrefetchedMBs', 'BEPrefetchedTrackUsed', 'BEPrefetchedTrackss',
            'BEReadReqs', 'BEReadRequestTime ', 'BEReadTaskTime', 'BEReqs',
            'BEWriteReqs', 'BlockSize', 'CompressedTracks',
            'CriticalAlertCount', 'HostHits', 'HostIOLimitPercentTimeExceeded',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs',
            'HostMisses', 'HostReadHits', 'HostReadMisses', 'HostReads',
            'HostWriteHits', 'HostWriteMisses', 'HostWrites', 'IODensity',
            'InfoAlertCount', 'MaxWPThreshold', 'PercentCompressedTracks',
            'PercentHit', 'PercentMisses', 'PercentRandomIO',
            'PercentRandomReadHit', 'PercentRandomReadMiss',
            'PercentRandomReads', 'PercentRandomWriteHit',
            'PercentRandomWriteMiss', 'PercentRandomWrites', 'PercentRead',
            'PercentReadHit', 'PercentReadMiss', 'PercentSeqIO',
            'PercentSeqRead', 'PercentSeqReadHit', 'PercentSeqReadMiss',
            'PercentSeqWriteHit', 'PercentSeqWriteMiss', 'PercentSeqWrites',
            'PercentWrite', 'PercentWriteHit', 'PercentWriteMiss',
            'RDFRewrites', 'RDFS_WriteResponseTime', 'RandomIOs',
            'RandomReadHits', 'RandomReadMisses', 'RandomReads',
            'RandomWriteHits', 'RandomWriteMisses', 'RandomWrites',
            'RdfMBRead', 'RdfMBWritten', 'RdfReads', 'RdfResponseTime',
            'RdfWrites', 'ReadMissResponseTime', 'ReadResponseTime',
            'ReadResponseTimeCount1', 'ReadResponseTimeCount2',
            'ReadResponseTimeCount3', 'ReadResponseTimeCount4',
            'ReadResponseTimeCount5', 'ReadResponseTimeCount6',
            'ReadResponseTimeCount7', 'ResponseTime', 'SRDFA_MBSent',
            'SRDFA_WriteReqs', 'SRDFS_MBSent', 'SRDFS_WriteReqs',
            'SeqIOs', 'SeqReadHits', 'SeqReadMisses', 'SeqReads',
            'SeqWriteHits', 'SeqWriteMisses', 'SeqWrites', 'Skew',
            'TotalTracks', 'WPCount', 'WarningAlertCount',
            'WriteMissResponseTime', 'WritePacedDelay',
            'WriteResponseTime', 'WriteResponseTimeCount1',
            'WriteResponseTimeCount2', 'WriteResponseTimeCount3',
            'WriteResponseTimeCount4', 'WriteResponseTimeCount5',
            'WriteResponseTimeCount6', 'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEReqs', 'BEWriteReqs',
            'HostHits', 'HostIOLimitPercentTimeExceeded', 'HostIOs',
            'HostMBReads', 'HostMBWritten', 'HostMBs', 'HostMisses',
            'HostReads', 'HostWrites', 'PercentHit', 'PercentMisses',
            'PercentRead', 'PercentWrite', 'RDFS_WriteResponseTime',
            'RdfResponseTime', 'ReadResponseTime', 'ResponseTime', 'WPCount',
            'WritePacedDelay', 'WriteResponseTime']},
    'STORAGEGROUP': {
        'category': 'StorageGroup',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 134,
        'metrics_kpi_cnt': 26,
        'metrics_all': [
            'AllocatedCapacity', 'AvgIOSize', 'AvgQOSDelayPerIO',
            'AvgReadResponseTime6', 'AvgReadResponseTime7', 'AvgReadSize',
            'AvgWritePacedDelay', 'AvgWriteResponseTime6',
            'AvgWriteResponseTime7', 'AvgWriteSize', 'BEDiskReadResponseTime',
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEPercentReads',
            'BEPercentWrites', 'BEPrefetchedMBs', 'BEPrefetchedTrackUsed',
            'BEPrefetchedTrackss', 'BEReadReqs', 'BEReadRequestTime',
            'BEReadTaskTime', 'BEReqs', 'BEWriteReqs', 'BlockSize',
            'CompressedTracks', 'CompressionRatio', 'CriticalAlertCount',
            'HostHits', 'HostIOLimitPercentTimeExceeded', 'HostIOs',
            'HostMBReads', 'HostMBWritten', 'HostMBs', 'HostMisses',
            'HostReadHits', 'HostReadMisses', 'HostReads', 'HostWriteHits',
            'HostWriteMisses', 'HostWrites', 'IODensity', 'InfoAlertCount',
            'MaxWPThreshold', 'PPAvgResponseTime', 'PPObservedDeltaRT',
            'PPReadRespTime', 'PPRelativeRT', 'PPWriteRespTime',
            'PercentCompressedTracks', 'PercentHit', 'PercentMisses',
            'PercentRandomIO', 'PercentRandomReadHit', 'PercentRandomReadMiss',
            'PercentRandomReads', 'PercentRandomWriteHit',
            'PercentRandomWriteMiss', 'PercentRandomWrites', 'PercentRead',
            'PercentReadHit', 'PercentReadMiss', 'PercentSeqIO',
            'PercentSeqRead', 'PercentSeqReadHit', 'PercentSeqReadMiss',
            'PercentSeqWriteHit', 'PercentSeqWriteMiss', 'PercentSeqWrites',
            'PercentVPSpaceSaved', 'PercentWrite', 'PercentWriteHit',
            'PercentWriteMiss', 'RDFRewrites', 'RDFS_WriteResponseTime',
            'RandomIOs', 'RandomReadHits', 'RandomReadMisses',
            'RandomReads', 'RandomWriteHits', 'RandomWriteMisses',
            'RandomWrites', 'RdfMBRead', 'RdfMBWritten', 'RdfReads',
            'RdfResponseTime', 'RdfWrites', 'ReadMissResponseTime',
            'ReadResponseTime', 'ReadResponseTimeCount1',
            'ReadResponseTimeCount2', 'ReadResponseTimeCount3',
            'ReadResponseTimeCount4', 'ReadResponseTimeCount5',
            'ReadResponseTimeCount6', 'ReadResponseTimeCount7', 'ResponseTime',
            'SRDFA_MBSent', 'SRDFA_WriteReqs', 'SRDFS_MBSent',
            'SRDFS_WriteReqs', 'SeqIOs', 'SeqReadHits', 'SeqReadMisses',
            'SeqReads', 'SeqWriteHits', 'SeqWriteMisses', 'SeqWrites', 'Skew',
            'TotalResponseTime', 'TotalTracks', 'VAAITotalCommandCount',
            'VAAITotalTime', 'VAAIUnmapCommandCount', 'VAAIUnmapKB',
            'VAAIUnmapMB', 'VAAIWriteSameCommandCount', 'VAAIWriteSameKB',
            'VAAIWriteSameMB', 'VAAIXCopyCommandCount', 'VAAIXCopyKB',
            'VAAIXCopyMB', 'WPCount', 'WarningAlertCount',
            'WriteMissResponseTime', 'WritePacedDelay', 'WriteResponseTime',
            'WriteResponseTimeCount1', 'WriteResponseTimeCount2',
            'WriteResponseTimeCount3', 'WriteResponseTimeCount4',
            'WriteResponseTimeCount5', 'WriteResponseTimeCount6',
            'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgQOSDelayPerIO', 'AvgWritePacedDelay', 'BEReadReqs', 'BEReqs',
            'BEWriteReqs', 'HostHits', 'HostIOLimitPercentTimeExceeded',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs', 'HostMisses',
            'HostReads', 'HostWrites', 'PercentHit', 'PercentMisses',
            'PercentRead', 'PercentWrite', 'RDFS_WriteResponseTime',
            'RdfResponseTime', 'ReadResponseTime', 'ResponseTime',
            'VAAITotalCommandCount', 'WPCount', 'WritePacedDelay',
            'WriteResponseTime']},
    'STORAGERESOURCE': {
        'category': 'StorageResource',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': False,
        'metrics_all_cnt': 114,
        'metrics_kpi_cnt': 24,
        'metrics_all': [
            'AllocatedCapacity', 'AvgIOSize', 'AvgReadResponseTime6',
            'AvgReadResponseTime7', 'AvgReadSize', 'AvgWritePacedDelay',
            'AvgWriteResponseTime6', 'AvgWriteResponseTime7', 'AvgWriteSize',
            'BEDiskReadResponseTime', 'BEMBReads', 'BEMBTransferred',
            'BEMBWritten', 'BEPercentReads', 'BEPercentWrites',
            'BEPrefetchedMBs', 'BEPrefetchedTrackUsed', 'BEPrefetchedTrackss',
            'BEReadReqs', 'BEReadRequestTime', 'BEReadTaskTime', 'BEReqs',
            'BEWriteReqs', 'BlockSize', 'CompressedTracks',
            'CriticalAlertCount', 'HostHits', 'HostIOLimitPercentTimeExceeded',
            'HostIOs', 'HostMBReads', 'HostMBWritten', 'HostMBs', 'HostMisses',
            'HostReadHits', 'HostReadMisses', 'HostReads', 'HostWriteHits',
            'HostWriteMisses', 'HostWrites', 'IODensity', 'InfoAlertCount',
            'MaxWPThreshold', 'PercentCompressedTracks', 'PercentHit',
            'PercentMisses', 'PercentRandomIO', 'PercentRandomReadHit',
            'PercentRandomReadMiss', 'PercentRandomReads',
            'PercentRandomWriteHit', 'PercentRandomWriteMiss',
            'PercentRandomWrites', 'PercentRead', 'PercentReadHit',
            'PercentReadMiss', 'PercentSeqIO', 'PercentSeqRead',
            'PercentSeqReadHit', 'PercentSeqReadMiss', 'PercentSeqWriteHit',
            'PercentSeqWriteMiss', 'PercentSeqWrites', 'PercentWrite',
            'PercentWriteHit', 'PercentWriteMiss', 'RDFRewrites',
            'RDFS_WriteResponseTime', 'RandomIOs', 'RandomReadHits',
            'RandomReadMisses', 'RandomReads', 'RandomWriteHits',
            'RandomWriteMisses', 'RandomWrites', 'RdfMBRead', 'RdfMBWritten',
            'RdfReads', 'RdfResponseTime', 'RdfWrites', 'ReadMissResponseTime',
            'ReadResponseTime', 'ReadResponseTimeCount1',
            'ReadResponseTimeCount2', 'ReadResponseTimeCount3',
            'ReadResponseTimeCount4', 'ReadResponseTimeCount5',
            'ReadResponseTimeCount6', 'ReadResponseTimeCount7',
            'ResponseTime', 'SRDFA_MBSent', 'SRDFA_WriteReqs', 'SRDFS_MBSent',
            'SRDFS_WriteReqs', 'SeqIOs', 'SeqReadHits', 'SeqReadMisses',
            'SeqReads', 'SeqWriteHits', 'SeqWriteMisses', 'SeqWrites',
            'Skew', 'TotalTracks', 'WPCount', 'WarningAlertCount',
            'WriteMissResponseTime', 'WritePacedDelay', 'WriteResponseTime',
            'WriteResponseTimeCount1', 'WriteResponseTimeCount2',
            'WriteResponseTimeCount3', 'WriteResponseTimeCount4',
            'WriteResponseTimeCount5', 'WriteResponseTimeCount6',
            'WriteResponseTimeCount7'],
        'metrics_kpi': [
            'AvgWritePacedDelay', 'BEReadReqs', 'BEReqs', 'BEWriteReqs',
            'HostHits', 'HostIOLimitPercentTimeExceeded', 'HostIOs',
            'HostMBReads', 'HostMBWritten', 'HostMBs', 'HostMisses',
            'HostReads', 'HostWrites', 'PercentHit', 'PercentMisses',
            'PercentRead', 'PercentWrite', 'RDFS_WriteResponseTime',
            'RdfResponseTime', 'ReadResponseTime', 'ResponseTime', 'WPCount',
            'WritePacedDelay', 'WriteResponseTime']},
    'SRP': {
        'category': 'SRP',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 28,
        'metrics_kpi_cnt': 5,
        'metrics_all': [
            'BEMBReads', 'BEMBTransferred', 'BEMBWritten', 'BEReadReqs',
            'BEReqs', 'BEWriteReqs', 'HostIOs', 'HostMBReads', 'HostMBWritten',
            'HostMBs', 'HostReads', 'HostWrites', 'OverallCompressionRatio',
            'OverallEfficiencyRatio', 'PercentSnapshotSaved',
            'PercentVPSaved', 'ReadResponseTime', 'ResponseTime',
            'SnapshotCompressionRatio', 'SnapshotEfficiencyRatio',
            'SnapshotSharedRatio', 'TotalSRPCapacity',
            'TotalSnapshotAllocatedCapacity', 'UsedSRPCapacity',
            'VPCompressionRatio', 'VPEfficiencyRatio', 'VPSharedRatio',
            'WriteResponseTime'],
        'metrics_kpi': [
            'BEMBTransferred', 'BEReqs', 'HostIOs', 'HostMBs',
            'ResponseTime']},
    'THINPOOL': {
        'category': 'ThinPool',
        'can_alert': True,
        'diagnostics': True,
        'real_time': False,
        'thresholds': True,
        'metrics_all_cnt': 33,
        'metrics_kpi_cnt': 18,
        'metrics_all': [
            'AllocatedPoolCapacity', 'AvgIOSize', 'AvgReadSize',
            'AvgWriteSize', 'BEAvgResponseTime', 'BEMBRead', 'BEMBTransferred',
            'BEMBWritten', 'BEPercentReads', 'BEPercentWrites',
            'BEPrefetchedMBs', 'BEPrefetchedTrackUsed', 'BEPrefetchedTracks',
            'BEReadReqs', 'BEReadResponseTime', 'BEReqs', 'BEWriteReqs',
            'BEWriteResponseTime', 'BlockSize', 'CompressedTracks',
            'CompressionScanReads', 'CopyOnWrite', 'EgressTracks',
            'EnabledPoolCapacity', 'IODensity', 'IngressTracks',
            'PercentCompressedTracks', 'PercentUsedCapacity',
            'ReDirectOnWrite', 'TotalPoolCapacity', 'TotalTracks',
            'UsedPoolCapacity', 'WPCount'],
        'metrics_kpi': [
            'AllocatedPoolCapacity', 'BEAvgResponseTime', 'BEMBRead',
            'BEMBTransferred', 'BEMBWritten', 'BEReadReqs',
            'BEReadResponseTime', 'BEReqs', 'BEWriteReqs',
            'BEWriteResponseTime', 'EgressTracks', 'EnabledPoolCapacity',
            'IODensity', 'IngressTracks', 'PercentUsedCapacity',
            'TotalPoolCapacity', 'UsedPoolCapacity', 'WPCount']}}
