# DO NOT EDIT! This file is automatically generated

import marshmallow

from commercetools import helpers, types
from commercetools.schemas._common import (
    BaseResourceSchema,
    KeyReferenceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)

__all__ = [
    "StoreDraftSchema",
    "StoreKeyReferenceSchema",
    "StorePagedQueryResponseSchema",
    "StoreReferenceSchema",
    "StoreResourceIdentifierSchema",
    "StoreSchema",
    "StoreSetLanguagesActionSchema",
    "StoreSetNameActionSchema",
    "StoreUpdateActionSchema",
    "StoreUpdateSchema",
    "StoresAddDistributionChannelsActionSchema",
    "StoresRemoveDistributionChannelsActionSchema",
    "StoresSetDistributionChannelsActionSchema",
]


class StoreDraftSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.StoreDraft`."
    key = marshmallow.fields.String(allow_none=True)
    name = LocalizedStringField(allow_none=True)
    languages = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), missing=None
    )
    distribution_channels = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="distributionChannels",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.StoreDraft(**data)


class StoreKeyReferenceSchema(KeyReferenceSchema):
    "Marshmallow schema for :class:`commercetools.types.StoreKeyReference`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.StoreKeyReference(**data)


class StorePagedQueryResponseSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.StorePagedQueryResponse`."
    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = marshmallow.fields.Nested(
        nested="commercetools.schemas._store.StoreSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.StorePagedQueryResponse(**data)


class StoreReferenceSchema(ReferenceSchema):
    "Marshmallow schema for :class:`commercetools.types.StoreReference`."
    obj = marshmallow.fields.Nested(
        nested="commercetools.schemas._store.StoreSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.StoreReference(**data)


class StoreResourceIdentifierSchema(ResourceIdentifierSchema):
    "Marshmallow schema for :class:`commercetools.types.StoreResourceIdentifier`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.StoreResourceIdentifier(**data)


class StoreSchema(BaseResourceSchema):
    "Marshmallow schema for :class:`commercetools.types.Store`."
    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    key = marshmallow.fields.String(allow_none=True)
    name = LocalizedStringField(allow_none=True, missing=None)
    languages = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), missing=None
    )
    distribution_channels = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="distributionChannels",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Store(**data)


class StoreUpdateActionSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.StoreUpdateAction`."
    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StoreUpdateAction(**data)


class StoreUpdateSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.StoreUpdate`."
    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "setLanguages": "commercetools.schemas._store.StoreSetLanguagesActionSchema",
                "setName": "commercetools.schemas._store.StoreSetNameActionSchema",
                "addDistributionChannel": "commercetools.schemas._store.StoresAddDistributionChannelsActionSchema",
                "removeDistributionChannel": "commercetools.schemas._store.StoresRemoveDistributionChannelsActionSchema",
                "setDistributionChannels": "commercetools.schemas._store.StoresSetDistributionChannelsActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.StoreUpdate(**data)


class StoreSetLanguagesActionSchema(StoreUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.StoreSetLanguagesAction`."
    languages = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), missing=None
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StoreSetLanguagesAction(**data)


class StoreSetNameActionSchema(StoreUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.StoreSetNameAction`."
    name = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StoreSetNameAction(**data)


class StoresAddDistributionChannelsActionSchema(StoreUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.StoresAddDistributionChannelsAction`."
    distribution_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StoresAddDistributionChannelsAction(**data)


class StoresRemoveDistributionChannelsActionSchema(StoreUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.StoresRemoveDistributionChannelsAction`."
    distribution_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StoresRemoveDistributionChannelsAction(**data)


class StoresSetDistributionChannelsActionSchema(StoreUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.StoresSetDistributionChannelsAction`."
    distribution_channels = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="distributionChannels",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StoresSetDistributionChannelsAction(**data)
