# Generated by Django 3.2.9 on 2021-12-30 04:49

from django.db import migrations, models

DATAS = [
    {
        "content_char": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut nunc dolor, malesuada in pulvinar et, efficitur non massa. Sed at mi elit. Quisque a dapibus nibh. Nunc ac tristique mi. Nam consectetur lectus ac ipsum euismod ultrices. Interdum et malesuada fames ac ante ipsum primis in faucibus. Mauris condimentum, libero vitae rutrum tristique, nibh urna maximus felis, ac gravida enim velit id erat.",
    },
    {
        "content_text": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut nunc dolor, malesuada in pulvinar et, efficitur non massa. Sed at mi elit. Quisque a dapibus nibh. Nunc ac tristique mi. Nam consectetur lectus ac ipsum euismod ultrices. Interdum et malesuada fames ac ante ipsum primis in faucibus. Mauris condimentum, libero vitae rutrum tristique, nibh urna maximus felis, ac gravida enim velit id erat.",
    },
]


def forwards_func(apps, schema_editor):
    NonQuillPost = apps.get_model("posts", "NonQuillPost")
    db_alias = schema_editor.connection.alias
    for data in DATAS:
        NonQuillPost.objects.using(db_alias).create(**data)


def reverse_func(apps, schema_editor):
    NonQuillPost = apps.get_model("posts", "NonQuillPost")
    db_alias = schema_editor.connection.alias
    NonQuillPost.objects.using(db_alias).all().delete()


class Migration(migrations.Migration):
    dependencies = [
        ("posts", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="NonQuillPost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("content_char", models.CharField(blank=True, max_length=300)),
                ("content_text", models.TextField(blank=True)),
            ],
        ),
        migrations.RunPython(forwards_func, reverse_func),
    ]
