# moai-security-owasp: Reference & Official Documentation

## OWASP Top 10 2021 Standards

### Official Resources
- OWASP Top 10 2021: https://owasp.org/Top10/
- OWASP Top 10 2017: https://owasp.org/www-project-top-ten-2017/
- OWASP Testing Guide: https://owasp.org/www-project-web-security-testing-guide/
- OWASP Cheat Sheet Series: https://cheatsheetseries.owasp.org/

### CWE References
- CWE Top 25: https://cwe.mitre.org/top25/
- CWE-79 (XSS): https://cwe.mitre.org/data/definitions/79.html
- CWE-89 (SQL Injection): https://cwe.mitre.org/data/definitions/89.html
- CWE-352 (CSRF): https://cwe.mitre.org/data/definitions/352.html
- CWE-639 (BOLA): https://cwe.mitre.org/data/definitions/639.html

## Security Frameworks

### NIST Cybersecurity
- NIST CSF: https://www.nist.gov/cyberframework
- NIST SP 800-53: https://csrc.nist.gov/publications/detail/sp/800-53/rev-5/final
- NIST SP 800-63 (Authentication): https://pages.nist.gov/800-63-3/

### CIS Controls
- CIS Controls v8: https://www.cisecurity.org/cis-controls/v8
- CIS Benchmarks: https://www.cisecurity.org/cis-benchmarks/

## Tools & Libraries

### Input Validation
- **express-validator**: https://express-validator.github.io/
- **joi**: https://joi.dev/
- **yup**: https://github.com/jquense/yup
- **zod**: https://zod.dev/

### Output Encoding
- **sanitize-html**: https://github.com/apostrophecms/sanitize-html
- **xss**: https://github.com/leizongmin/js-xss
- **DOMPurify**: https://github.com/cure53/DOMPurify

### Security Headers
- **helmet**: https://helmetjs.github.io/
- **csurf**: https://github.com/expressjs/csurf
- **cors**: https://github.com/expressjs/cors

### Testing & Scanning
- **OWASP ZAP**: https://www.zaproxy.org/
- **Burp Suite**: https://portswigger.net/burp
- **npm audit**: https://docs.npmjs.com/cli/v8/commands/npm-audit

## Related Skills

- **moai-security-api**: API security, rate limiting
- **moai-security-auth**: Authentication security
- **moai-security-encryption**: Cryptographic security
- **moai-domain-database**: SQL injection prevention
