# Official References

## shadcn/ui Core Documentation

- shadcn/ui Official: https://ui.shadcn.com/
- shadcn/ui GitHub: https://github.com/shadcn-ui/ui
- shadcn/ui Components: https://ui.shadcn.com/docs/components/
- shadcn/ui Installation: https://ui.shadcn.com/docs/installation
- shadcn/ui CLI: https://ui.shadcn.com/docs/cli

## Component Documentation

- Button: https://ui.shadcn.com/docs/components/button
- Card: https://ui.shadcn.com/docs/components/card
- Dialog: https://ui.shadcn.com/docs/components/dialog
- Form: https://ui.shadcn.com/docs/components/form
- Input: https://ui.shadcn.com/docs/components/input
- Tabs: https://ui.shadcn.com/docs/components/tabs
- Table: https://ui.shadcn.com/docs/components/table
- Dropdown Menu: https://ui.shadcn.com/docs/components/dropdown-menu
- Navigation Menu: https://ui.shadcn.com/docs/components/navigation-menu
- Tooltip: https://ui.shadcn.com/docs/components/tooltip
- Select: https://ui.shadcn.com/docs/components/select
- Checkbox: https://ui.shadcn.com/docs/components/checkbox
- Radio Group: https://ui.shadcn.com/docs/components/radio-group
- Textarea: https://ui.shadcn.com/docs/components/textarea
- Alert: https://ui.shadcn.com/docs/components/alert
- Badge: https://ui.shadcn.com/docs/components/badge
- Calendar: https://ui.shadcn.com/docs/components/calendar
- Date Picker: https://ui.shadcn.com/docs/components/date-picker
- Popover: https://ui.shadcn.com/docs/components/popover
- Sheet: https://ui.shadcn.com/docs/components/sheet
- Sidebar: https://ui.shadcn.com/docs/components/sidebar
- Drawer: https://ui.shadcn.com/docs/components/drawer
- Alert Dialog: https://ui.shadcn.com/docs/components/alert-dialog
- Toast: https://ui.shadcn.com/docs/components/toast
- Sonner (Toast Alternative): https://sonner.emilkowal.ski/

## Underlying Technologies

- Radix UI: https://www.radix-ui.com/
- Radix UI Docs: https://www.radix-ui.com/docs/primitives
- Tailwind CSS: https://tailwindcss.com/
- Tailwind CSS Docs: https://tailwindcss.com/docs
- Class Variance Authority (CVA): https://cva.style/docs
- clsx: https://github.com/lukeed/clsx

## Theming & Customization

- shadcn/ui Theming: https://ui.shadcn.com/docs/theming
- Tailwind CSS Theme: https://tailwindcss.com/docs/theme
- Dark Mode Support: https://ui.shadcn.com/docs/dark-mode
- Custom Colors: https://ui.shadcn.com/docs/customization/add-custom-colors
- Create Custom Component: https://ui.shadcn.com/docs/custom/button

## Related Libraries & Integrations

- React Hook Form: https://react-hook-form.com/
- React Hook Form + shadcn/ui: https://ui.shadcn.com/docs/components/form
- Zod (Schema Validation): https://zod.dev/
- TanStack React Table: https://tanstack.com/table/v8
- Lucide React Icons: https://lucide.dev/
- Recharts (Charts): https://recharts.org/
- date-fns (Date Library): https://date-fns.org/

## Design System Resources

- shadcn Design Philosophy: https://twitter.com/shadcn
- shadcn/ui Blog: https://ui.shadcn.com/blog
- shadcn/ui Examples: https://github.com/shadcn-ui/ui/tree/main/apps/www
- shadcn/ui Templates: https://ui.shadcn.com/docs/templates

## Accessibility Standards

- WCAG 2.1 Guidelines: https://www.w3.org/WAI/WCAG21/quickref/
- WAI-ARIA: https://www.w3.org/WAI/ARIA/
- Radix UI Accessibility: https://www.radix-ui.com/docs/primitives/overview/accessibility
- Web Accessibility: https://www.w3.org/WAI/

## Learning Resources

- shadcn/ui Discord: https://discord.gg/JCJnpQV
- shadcn/ui Twitter: https://twitter.com/shadcn
- Radix UI Docs: https://www.radix-ui.com/
- Tailwind CSS Community: https://tailwindcss.com/discord
