# Official References

## HTML Standards & Specifications

- W3C HTML Living Standard: https://html.spec.whatwg.org/
- HTML5 Specification: https://www.w3.org/TR/html5/
- MDN HTML Documentation: https://developer.mozilla.org/en-US/docs/Web/HTML
- MDN HTML Elements Reference: https://developer.mozilla.org/en-US/docs/Web/HTML/Element

## CSS Standards & Specifications

- CSS Specification: https://www.w3.org/Style/CSS/
- CSS Working Group Drafts: https://drafts.csswg.org/
- MDN CSS Documentation: https://developer.mozilla.org/en-US/docs/Web/CSS
- MDN CSS Reference: https://developer.mozilla.org/en-US/docs/Web/CSS/Reference
- Can I Use (Browser Compatibility): https://caniuse.com/

## Accessibility & WCAG

- WCAG 2.1 Guidelines: https://www.w3.org/WAI/WCAG21/quickref/
- WCAG 2.1 Full Documentation: https://www.w3.org/TR/WCAG21/
- WAI-ARIA Authoring Practices: https://www.w3.org/WAI/ARIA/apg/
- WAI-ARIA Specification: https://www.w3.org/TR/wai-aria-1.2/
- WebAIM: https://webaim.org/
- WebAIM Contrast Checker: https://webaim.org/resources/contrastchecker/
- Accessibility Guidelines: https://a11y-101.com/

## Semantic HTML

- Semantic HTML5: https://html.spec.whatwg.org/#sections
- MDN Semantic HTML: https://developer.mozilla.org/en-US/docs/Glossary/semantics
- HTML5 Doctor: http://html5doctor.com/
- Structural Elements Guide: https://www.w3.org/TR/html5/grouping-content.html

## Forms & Input

- MDN Form Elements: https://developer.mozilla.org/en-US/docs/Learn/Forms
- HTML Form Best Practices: https://www.smashingmagazine.com/2022/09/inline-validation-web-forms-ux/
- Form Accessibility: https://www.w3.org/TR/WCAG21/#input-assistance
- HTML5 Form Validation: https://html.spec.whatwg.org/#the-constraint-validation-api

## Typography & Fonts

- CSS Font Properties: https://developer.mozilla.org/en-US/docs/Web/CSS/font
- Web Safe Fonts: https://www.w3schools.com/cssref/css_websafe_fonts.asp
- Google Fonts: https://fonts.google.com/
- Font Loading Best Practices: https://www.smashingmagazine.com/2022/09/modern-font-stacks/

## Color & Contrast

- MDN Colors: https://developer.mozilla.org/en-US/docs/Web/CSS/color
- CSS Color Module: https://www.w3.org/TR/css-color-4/
- Color Contrast Analyzer: https://www.tpgi.com/color-contrast-checker/
- WCAG Color Contrast Guidelines: https://www.w3.org/WAI/WCAG21/Understanding/contrast-minimum.html

## Responsive Design

- Responsive Web Design: https://www.w3.org/TR/css-mobile/
- MDN Responsive Design: https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Responsive_Design
- Mobile First Approach: https://www.w3schools.com/css/css_rwd_intro.asp
- Media Queries: https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries

## Tools & Resources

- CSS Validator: https://jigsaw.w3.org/css-validator/
- HTML Validator: https://validator.w3.org/
- Lighthouse (Performance & Accessibility): https://developers.google.com/web/tools/lighthouse
- WebAIM Screen Reader Testing: https://webaim.org/articles/screenreader_testing/
