---
name: moai-lang-c
version: 4.0.0
updated: '2025-11-19'
status: stable
stability: stable
description: C programming language patterns, memory management, and systems programming
allowed-tools:
- Read
- Bash
- WebSearch
- WebFetch
---



# C Programming Language Skill

## Skill Metadata

| Field | Value |
| ----- | ----- |
| **Skill Name** | moai-lang-c |
| **Version** | 2.0.0 (2025-11-11) |
| **Allowed tools** | Read, Bash, Glob |
| **Auto-load** | On demand when C patterns detected |
| **Tier** | Language (Foundation) |

---

## What It Does

C programming language patterns, memory management, and systems programming best practices.

**Key capabilities**:
- ✅ Memory management patterns
- ✅ Systems programming techniques
- ✅ Performance optimization
- ✅ Low-level data structures
- ✅ Cross-platform compatibility

---

## When to Use

- ✅ Writing C applications
- ✅ Managing memory manually
- ✅ Implementing low-level optimizations
- ✅ Creating system software

---

## Core C Patterns

### Memory Management
1. **Dynamic Allocation**: malloc, calloc, realloc patterns
2. **Memory Safety**: Buffer overflow prevention
3. **Resource Management**: RAII-like patterns in C
4. **Memory Profiling**: Leak detection and optimization
5. **Stack vs Heap**: Appropriate usage scenarios

### Systems Programming
- **File I/O**: Robust file handling patterns
- **Process Management**: Process creation and communication
- **Network Programming**: Socket programming patterns
- **System Calls**: Proper system call usage
- **Error Handling**: Robust error management

---

## Dependencies

- C compiler (GCC, Clang)
- Build systems (Make, CMake)
- Debugging tools (GDB, Valgrind)
- Standard C library

---

## Works Well With

- `moai-lang-cpp` (C++ integration)
- `moai-essentials-debug` (Debugging patterns)
- `moai-essentials-perf` (Performance optimization)

---

## Changelog

- **v2.0.0** (2025-11-11): Added complete metadata, C programming patterns
- **v1.0.0** (2025-10-22): Initial C language support

---

**End of Skill** | Updated 2025-11-11
