---
name: moai-cc-claude-md
version: 4.0.0
created: 2025-10-22
updated: '2025-11-18'
status: stable
description: Claude Code Markdown integration, documentation generation, and structured
  content patterns. Use when generating documentation, managing markdown content,
  or creating structured reports.
keywords:
- markdown
- documentation
- content-generation
- structured-content
- claude-md
allowed-tools:
- Read
- Bash
- WebFetch
stability: stable
---


# Claude Code Markdown Integration

## Skill Metadata

| Field | Value |
| ----- | ----- |
| **Skill Name** | moai-cc-claude-md |
| **Version** | 2.0.0 (2025-11-11) |
| **Allowed tools** | Read, Bash, WebFetch |
| **Auto-load** | On demand when markdown processing detected |
| **Tier** | Claude Code (Core) |

---

## What It Does

Claude Code Markdown integration, documentation generation, and structured content patterns.

**Key capabilities**:
- ✅ Markdown content generation
- ✅ Documentation structuring
- ✅ Content template management
- ✅ Cross-referencing systems
- ✅ Publication workflows

---

## When to Use

- ✅ Generating documentation
- ✅ Managing markdown content
- ✅ Creating structured reports
- ✅ Implementing documentation systems

---

## Core Markdown Patterns

### Content Architecture
1. **Structured Templates**: Reusable content patterns
2. **Cross-Reference Systems**: Link and reference management
3. **Content Validation**: Markdown quality checks
4. **Publication Workflows**: Automated content deployment
5. **Version Control**: Documentation change tracking

### Document Types
- **Technical Documentation**: API docs, guides, tutorials
- **Project Documentation**: README, CHANGELOG, CONTRIBUTING
- **Process Documentation**: Workflows, policies, procedures
- **Knowledge Base**: FAQ, best practices, patterns
- **Reports**: Analysis, status, summary documents

---

## Dependencies

- Markdown processing tools
- Content templates
- Documentation frameworks
- Publication platforms

---

## Works Well With

- `moai-docs-generation` (Document generation)
- `moai-docs-validation` (Content validation)
- `moai-project-documentation` (Project docs)

---

## Changelog

- **v2.0.0** (2025-11-11): Added complete metadata, markdown patterns
- **v1.0.0** (2025-10-22): Initial markdown integration

---

**End of Skill** | Updated 2025-11-11
