---
name: moai-cc-agents
version: 4.0.0
created: 2025-10-22
updated: '2025-11-18'
status: stable
description: Claude Code Agents system, task delegation patterns, and multi-agent
  coordination. Use when creating custom agents, managing agent workflows, or implementing
  task delegation.
keywords:
- agents
- task-delegation
- coordination
- workflows
- automation
allowed-tools:
- Read
- Bash
- Task
stability: stable
---


# Claude Code Agents System

## Skill Metadata

| Field | Value |
| ----- | ----- |
| **Skill Name** | moai-cc-agents |
| **Version** | 2.0.0 (2025-11-11) |
| **Allowed tools** | Read, Bash, Task |
| **Auto-load** | On demand when agent patterns detected |
| **Tier** | Claude Code (Core) |

---

## What It Does

Claude Code Agents system, task delegation patterns, and multi-agent coordination.

**Key capabilities**:
- ✅ Agent creation and management
- ✅ Task delegation patterns
- ✅ Multi-agent coordination
- ✅ Workflow orchestration
- ✅ Agent communication protocols

---

## When to Use

- ✅ Creating custom agents
- ✅ Managing agent workflows
- ✅ Implementing task delegation
- ✅ Coordinating multi-agent systems

---

## Core Agent Patterns

### Agent Architecture
1. **Task Delegation**: Specialized task assignment
2. **Agent Communication**: Inter-agent messaging
3. **Workflow Coordination**: Multi-agent orchestration
4. **Resource Management**: Agent resource allocation
5. **Performance Monitoring**: Agent effectiveness tracking

### Agent Types
- **Specialist Agents**: Domain-specific expertise
- **General Agents**: Broad capability coverage
- **Coordinator Agents**: Workflow management
- **Automation Agents**: Repetitive task handling
- **Validation Agents**: Quality and compliance checking

---

## Dependencies

- Claude Code agents system
- Task delegation framework
- Agent communication protocols
- Workflow orchestration tools

---

## Works Well With

- `moai-cc-skills` (Agent knowledge)
- `moai-cc-hooks` (Agent event handling)
- `moai-core-agent-guide` (Agent selection patterns)

---

## Changelog

- **v2.0.0** (2025-11-11): Added complete metadata, agent architecture patterns
- **v1.0.0** (2025-10-22): Initial agents system

---

**End of Skill** | Updated 2025-11-11
