---
id: SPEC-FIX-001
version: "1.0.0"
status: draft
created: "2025-11-18"
updated: "2025-11-18"
author: Claude Code
priority: high
---

# SPEC-FIX-001: 구현 계획 및 기술 전략

## 1. 문제 분석 요약

### 근본 원인
- **스크립트 마이그레이션**: `.moai/scripts/statusline.py` → `uvx moai-adk statusline`
- **환경 이슈**: uvx 캐시, config.json 경로 해석, 패키지 import 실패
- **증상**: Claude Code 상태표시줄에 "Ver unknown" 표시

### 영향 범위
- **대상**: 모든 MoAI-ADK 사용자 (Personal/Team 모드)
- **심각도**: HIGH (개발 생산성 직접 영향)
- **배포 환경**: Claude Code SessionStart 훅

### 긴급도 분류
- **빠른 수정 필요**: 2-3시간 이내 해결 권장
- **영향 미루기 비용**: 하루에 최소 2-3시간 개발 시간 낭비 가능

---

## 2. 해결 전략 (4단계)

### Phase 1: 환경 진단
**목표**: 정확한 원인 특정 및 진단 결과 문서화

#### Phase 1-1: uvx 명령어 테스트
```bash
# 테스트 1: 직접 실행
uvx moai-adk statusline

# 예상 출력: 🤖 Haiku 4.5 | 🗿 Ver 0.26.0 | 📊 +0 M26 ?9 | 🔀 release/0.26.0
# 문제 증상: 🤖 Haiku 4.5 | 🗿 Ver unknown | ...
```

**진단 항목**:
- uvx 명령어 존재 여부
- 패키지 로드 성공 여부
- 출력 형식 및 버전 정보

#### Phase 1-2: config.json 검증
```bash
# 테스트 2: 파일 존재 확인
cat .moai/config/config.json | jq '.moai.version'

# 예상 출력: "0.26.0"
# 문제 증상: null, error, 또는 파일 없음
```

**진단 항목**:
- 파일 위치: `.moai/config/config.json`
- 필드 존재: `moai.version`
- 값의 정확성: "0.26.0"

#### Phase 1-3: 패키지 버전 확인
```bash
# 테스트 3: 설치된 버전 확인
uvx moai-adk --version

# 테스트 4: 패키지 경로 확인
python -c "import moai_adk; print(moai_adk.__file__)"

# 테스트 5: 직접 모듈 로드
python -c "from moai_adk.statusline.main import get_version; print(get_version())"
```

**진단 항목**:
- 설치된 모듈 위치
- 패키지 버전
- import 성공 여부

### Phase 2: 캐시 클리어 및 재설치
**목표**: 오염된 캐시 제거 및 최신 버전 설치

#### Phase 2-1: uvx 캐시 제거
```bash
# Step 1: moai-adk 패키지 캐시만 삭제
uvx cache clean moai-adk

# Step 2: 전체 uvx 캐시 초기화 (필요시)
rm -rf ~/.cache/uv/

# Step 3: 검증
uvx --version
```

**효과**:
- 오래된 패키지 버전 제거
- 다음 실행 시 PyPI에서 최신 버전 다운로드

#### Phase 2-2: 패키지 재동기화
```bash
# Step 1: 프로젝트 의존성 강제 재설치
uv sync --force

# Step 2: 잠금 파일 재생성 확인
ls -la uv.lock

# Step 3: 패키지 설치 상태 확인
uv pip list | grep moai-adk
```

**효과**:
- 모든 의존성 최신 상태로 동기화
- 손상된 설치 파일 재구성

#### Phase 2-3: 검증
```bash
# 재설치 후 다시 테스트
uvx moai-adk statusline

# 예상 결과: "Ver unknown" 해결 여부 확인
```

### Phase 3: 설정 파일 검증
**목표**: Claude Code 및 statusline 설정이 올바르게 구성되었는지 확인

#### Phase 3-1: Claude Code 설정 확인
```bash
# 1. settings.json에서 statusLine 섹션 확인
cat .claude/settings.json | jq '.statusLine'

# 2. 기본 설정 확인
jq '.statusLine' .claude/settings.json | grep -E "enabled|format"

# 예상:
# {
#   "enabled": true,
#   "format": "{{model}} | {{version}} | {{git}} | {{branch}}"
# }
```

**검증 항목**:
- statusLine.enabled = true
- format 필드 포함
- 올바른 자리 표시자

#### Phase 3-2: statusline 설정 파일
```bash
# 1. 설정 파일 존재 확인
ls -la .moai/config/statusline-config.yaml

# 2. 내용 확인
cat .moai/config/statusline-config.yaml
```

**검증 항목**:
- 파일 존재 여부
- 올바른 YAML 형식
- 필수 필드 포함

#### Phase 3-3: 필요한 설정 추가
```bash
# 1. 누락된 설정 항목 추가
cat >> .moai/config/statusline-config.yaml <<EOF
# statusline 설정
version_field: moai.version
config_path: .moai/config/config.json
timeout_seconds: 3
cache_enabled: true
cache_ttl_seconds: 3600
EOF

# 2. 검증
uv run .moai/scripts/validate-config.py
```

### Phase 4: 테스트 및 검증
**목표**: 모든 요구사항이 충족되었는지 최종 검증

#### Phase 4-1: 수동 테스트
```bash
# Test 1: 직접 실행
echo "=== Direct execution test ==="
uvx moai-adk statusline
# 기대: 🤖 Haiku 4.5 | 🗿 Ver 0.26.0 | 📊 +0 M26 ?9 | 🔀 release/0.26.0

# Test 2: 반복 실행 (캐시 히트)
echo "=== Cache hit test ==="
time uvx moai-adk statusline
# 기대: 1초 이내 응답

# Test 3: 환경 변수 테스트
echo "=== Environment variable test ==="
DEBUG=1 uvx moai-adk statusline
# 기대: 디버그 정보 출력 가능
```

**검증 기준**:
- "Ver unknown" 미표시 ✓
- 정확한 버전 번호 표시 ✓
- 응답 시간 2초 이내 ✓

#### Phase 4-2: Claude Code 검증
```bash
# Test 1: Claude Code 재시작
# → bottom statusline에 Ver 0.26.0 표시 확인

# Test 2: 여러 세션 생성
# → 각 세션에서 정상 표시 확인

# Test 3: 장시간 유지
# → 세션 유지 중 지속적 정상 동작 확인
```

**검증 항목**:
- SessionStart 훅 정상 작동
- 멀티 세션 동시성
- 지속성 (여러 시간 유지)

#### Phase 4-3: 지속성 검증
```bash
# Test 1: 세션 재시작
# → Claude Code 종료 후 재시작
# → statusline 정상 표시 확인

# Test 2: 패키지 업데이트 시뮬레이션
# → config.json 버전 변경 (0.26.0 → 0.26.1)
# → statusline 재실행
# → 새 버전 반영 확인

# Test 3: 캐시 제거 후 실행
# → uvx cache clean moai-adk
# → statusline 정상 작동 확인
```

---

## 3. 상세 구현 계획

### 구현 우선순위
| 우선순위 | 작업 | 예상 시간 | 담당 |
|---------|------|---------|------|
| P0 (Critical) | Phase 1: 환경 진단 | 5분 | QA/개발자 |
| P1 (High) | Phase 2: 캐시 클리어 | 10분 | 시스템 |
| P2 (High) | Phase 3: 설정 검증 | 5분 | 설정 관리 |
| P3 (Medium) | Phase 4: 최종 테스트 | 5분 | QA |

### 병렬 가능 작업
```
Phase 1 (진단) → Phase 2 (캐시)
                    ↓
              Phase 3 (설정 검증)
                    ↓
              Phase 4 (최종 테스트)
```

**총 예상 소요 시간**: 15-20분

---

## 4. 기술 스택 및 의존성

| 항목 | 버전 | 용도 |
|------|------|------|
| Python | 3.13.9+ | 패키지 런타임 |
| moai-adk | 0.26.0+ | statusline 호스트 |
| uvx | 0.5.0+ | 패키지 실행 도구 |
| uv | 최신 | 의존성 관리 |
| Claude Code | v4.0+ | 실행 환경 |
| jq | 1.6+ | JSON 파싱 도구 |

---

## 5. 위험 요소 및 완화 전략

| 위험 | 가능성 | 영향 | 완화 전략 |
|------|--------|------|---------|
| 캐시 클리어 후에도 미작동 | 중간 | 높음 | Phase 3 설정 검증 강화 |
| 패키지 버전 불일치 | 낮음 | 중간 | uv.lock 파일 검증 |
| config.json 경로 문제 | 낮음 | 높음 | 환경 변수 대체 경로 설정 |
| 성능 저하 (타임아웃) | 매우 낮음 | 중간 | 캐시 메커니즘 강화 |

---

## 6. 품질 게이트 (TRUST 5)

### Test Coverage
- [ ] Phase 1-3 각 단계 자동화 테스트
- [ ] Phase 2-3 캐시/설정 테스트
- [ ] Phase 4 통합 테스트

### Readability
- [ ] 진단 출력 명확성
- [ ] 에러 메시지 이해하기 쉬움
- [ ] 문서 완성도 90% 이상

### Unified
- [ ] 모든 단계가 일관된 로깅 형식
- [ ] 에러 처리 표준화
- [ ] 설정 파일 형식 일관성

### Security
- [ ] config.json 파일 권한 확인 (600)
- [ ] 캐시 디렉토리 권한 검증
- [ ] 민감 정보 로깅 안 함

### Trackable
- [ ] 각 단계의 실행 로그 기록
- [ ] 의사결정 포인트 문서화
- [ ] SPEC → 테스트 → 구현 추적

---

## 7. 성공 기준

### 기능적 성공
- ✅ uvx moai-adk statusline 정상 작동
- ✅ Claude Code statusline에 Ver 0.26.0 표시
- ✅ "Ver unknown" 완전 제거

### 성능 성공
- ✅ 초기 실행: 2초 이내
- ✅ 캐시 히트: 1초 이내
- ✅ 메모리 오버헤드 < 50MB

### 안정성 성공
- ✅ 멀티 세션 동시성 보장
- ✅ 캐시 충돌 없음
- ✅ 오류 발생 시 graceful fallback

---

**계획 작성일**: 2025-11-18
**최종 검토**: 예정
**상태**: Draft
