# 최적화 에이전트 활용 계획

## 🎯 에이전트 역할 분담

### 1. **skill-optimizer** (메인 에이전트)
**역할**: 스킬 최적화 전문가
- 스킬 구조 분석 및 최적화 전략 수립
- 중복 제거, 템플릿화, 예제 통합
- 25% 라인 감축 목표

**활용 시점**: 모든 Phase에서 메인으로 활용
```bash
Task(
    subagent_type="skill-optimizer",
    prompt=f"""
    {skill_name} 스킬 최적화:
    - 현재: {current_lines} lines
    - 목표: {target_lines} lines ({reduction}% 감소)
    - 중점: {optimization_focus}
    """
)
```

### 2. **domain-expert** (도메인별 전문성)
**역할**: 특정 도메인 전문 지원
- 보안, 프론트엔드, BaaS 등 도메인별 패턴 통합
- 최신 트렌드 및 베스트 프랙티스 적용

**활용 시점**: 도메인 그룹별 전문성이 필요할 때
```bash
Task(
    subagent_type="security-expert",  # 또는 frontend-expert, backend-expert
    prompt=f"""
    보안 스킬 그룹 최적화:
    - moai-security-compliance (505 lines)
    - moai-security-zero-trust (522 lines)
    - moai-security-api (771 lines)

    통합할 보안 패턴 및 아키텍처 제안
    """
)
```

### 3. **refactor-specialist** (구조 개선)
**역할**: 코드 및 문서 구조 리팩토링
- 가독성 향상, 논리적 재구성
- 표준화 및 일관성 확보

**활용 시점**: 복잡한 스킬 구조 개선 필요시
```bash
Task(
    subagent_type="refactor-specialist",
    prompt=f"""
    {skill_name} 구조 개선:
    - 현재 구조 문제점 분석
    - 논리적 재구성 제안
    - 가독성 향상 방안
    """
)
```

### 4. **quality-gate** (품질 검증)
**역할**: 최종 품질 검증
- 기능 보존 확인
- 문서 품질 검증
- 최적화 효과 측정

**활용 시점**: 각 스킬 최적화 완료 후
```bash
Task(
    subagent_type="quality-gate",
    prompt=f"""
    {skill_name} 최적화 품질 검증:
    - 기능 보존 확인
    - 문서 품질 점검
    - 최적화 효과 측정 ({before} → {after} lines)
    """
)
```

## 🔄 그룹별 에이전트 조합

### 코어 그룹 (6개 스킬)
1. **skill-optimizer** → 전반적 최적화
2. **refactor-specialist** → 구조 개선
3. **quality-gate** → 품질 검증

### 보안 그룹 (5개 스킬)
1. **security-expert** → 보안 패턴 통합
2. **skill-optimizer** → 일반적 최적화
3. **quality-gate** → 보안 표준 검증

### 언어/도메인 그룹 (3개 스킬)
1. **domain-expert** (backend) → 백엔드 패턴
2. **skill-optimizer** → 템플릿화
3. **quality-gate** → 언어 표준 검증

### 클라우드/BaaS 그룹 (4개 스킬)
1. **devops-expert** → 클라우드 패턴
2. **skill-optimizer** → 제공업체 통합
3. **quality-gate** → 배포 가이드 검증

### MCP/설정 그룹 (4개 스킬)
1. **mcp-context7-integrator** → MCP 패턴
2. **skill-optimizer** → 설정 표준화
3. **quality-gate** → 통합 테스트

## ⚡ 효율적인 에이전트 활용 패턴

### 패턴 1: 순차적 처리 (대부분의 경우)
```
skill-optimizer → refactor-specialist → quality-gate
```

### 패턴 2: 병렬 처리 (독립적 스킬들)
```
skill-optimizer (skill A) &
skill-optimizer (skill B) &
skill-optimizer (skill C)
→ quality-gate (batch)
```

### 패턴 3: 전문가 선행 (복잡한 도메인)
```
domain-expert → skill-optimizer → quality-gate
```

## 🎯 에이전트별 시간 예측

### skill-optimizer: 20-30분/스킬
- 분석: 5분
- 최적화: 15-20분
- 검토: 5분

### domain-expert: 15-20분/그룹
- 패턴 분석: 10분
- 통합 제안: 5-10분

### refactor-specialist: 10-15분/스킬
- 구조 분석: 5분
- 재구성 제안: 5-10분

### quality-gate: 5-10분/스킬
- 기능 검증: 3분
- 품질 점검: 2-7분

## 📊 일일 처리 용량

**표준 모드** (90분):
- skill-optimizer: 2-3개 스킬 (40-60분)
- domain-expert: 1개 그룹 (15-20분)
- quality-gate: 2-3개 스킬 (15-20분)

**집중 모드** (120분):
- skill-optimizer: 3-4개 스킬 (60-80분)
- domain-expert: 1개 그룹 (15-20분)
- refactor-specialist: 1개 스킬 (10-15분)
- quality-gate: 3-4개 스킬 (15-25분)