# moai-security-secrets: Reference & Official Documentation

## Secret Management Standards

### Official Resources
- HashiCorp Vault: https://www.vaultproject.io/
- AWS Secrets Manager: https://aws.amazon.com/secrets-manager/
- Azure Key Vault: https://azure.microsoft.com/services/key-vault/
- OWASP Secrets Management: https://cheatsheetseries.owasp.org/cheatsheets/Secrets_Management_Cheat_Sheet.html

### Kubernetes Secrets
- Sealed Secrets: https://github.com/bitnami-labs/sealed-secrets
- External Secrets Operator: https://external-secrets.io/
- Kubernetes Secrets: https://kubernetes.io/docs/concepts/configuration/secret/

## Tools & Libraries

### Vault & Secret Management
- **@hashicorp/vault-client**: https://github.com/hashicorp/vault-client-node
- **aws-sdk**: https://aws.amazon.com/sdk-for-javascript/
- **@azure/keyvault-secrets**: https://github.com/Azure/azure-sdk-for-js

### Environment Variables
- **dotenv**: https://github.com/motdotla/dotenv
- **dotenv-safe**: https://github.com/rolodato/dotenv-safe

## Related Skills

- **moai-security-encryption**: Cryptographic key management
- **moai-security-auth**: Password storage
- **moai-domain-devops**: Deployment secrets

