# Reference: Mermaid Diagram Expert v5.0.0

## Official Documentation

### Core Resources
- [Mermaid Official Website](https://mermaid.js.org/) - Latest documentation
- [Mermaid Introduction](https://mermaid.js.org/intro/) - Getting started guide
- [Syntax Reference](https://mermaid.js.org/syntax/) - Complete syntax for all diagram types
- [Live Editor](https://mermaid.live/) - Interactive testing environment
- [GitHub Repository](https://github.com/mermaid-js/mermaid) - Source code and issues

### CLI Tools
- [Mermaid CLI](https://github.com/mermaid-js/mermaid-cli) - Official Node.js CLI tool
- [Mermaid CLI Docker](https://hub.docker.com/r/minlag/mermaid-cli) - Docker image

### Framework Integration
- [Nextra Mermaid Support](https://nextra.site/) - Documentation site integration
- [Remark Mermaid](https://github.com/remarkjs/remark-mermaid) - Markdown processor plugin
- [Gatsby Plugin](https://www.gatsbyjs.com/plugins/@ramonak/gatsby-plugin-mermaid/) - Gatsby integration

---

## Diagram Type Resources

### Flowchart / Graph
- [Flowchart Syntax](https://mermaid.js.org/syntax/flowchart.html)
- [Node Shapes Reference](https://mermaid.js.org/syntax/flowchart.html#node-shapes)
- [Styling & Colors](https://mermaid.js.org/syntax/flowchart.html#styling-and-classes)

### Sequence Diagram
- [Sequence Diagram Syntax](https://mermaid.js.org/syntax/sequenceDiagram.html)
- [Message Types](https://mermaid.js.org/syntax/sequenceDiagram.html#message-to-self)
- [Autonumbering](https://mermaid.js.org/syntax/sequenceDiagram.html#autonumber)

### Class Diagram
- [Class Diagram Syntax](https://mermaid.js.org/syntax/classDiagram.html)
- [UML Relationships](https://mermaid.js.org/syntax/classDiagram.html#relationship)
- [Visibility Modifiers](https://mermaid.js.org/syntax/classDiagram.html#class-member-visibility)

### State Diagram
- [State Diagram v2 Syntax](https://mermaid.js.org/syntax/stateDiagram.html)
- [Composite States](https://mermaid.js.org/syntax/stateDiagram.html#composite-states)
- [Parallel States](https://mermaid.js.org/syntax/stateDiagram.html#parallel-state)

### Entity Relationship (ER) Diagram
- [ER Diagram Syntax](https://mermaid.js.org/syntax/entityRelationshipDiagram.html)
- [Cardinality Notation](https://mermaid.js.org/syntax/entityRelationshipDiagram.html#cardinality)
- [Relationship Types](https://mermaid.js.org/syntax/entityRelationshipDiagram.html#relationships)

### Gantt Chart
- [Gantt Chart Syntax](https://mermaid.js.org/syntax/gantt.html)
- [Date Formats](https://mermaid.js.org/syntax/gantt.html#date-format)
- [Task Dependencies](https://mermaid.js.org/syntax/gantt.html#dependencies)

### Mindmap
- [Mindmap Syntax](https://mermaid.js.org/syntax/mindmap.html)
- [Icon Support](https://mermaid.js.org/syntax/mindmap.html#icons)

### Timeline
- [Timeline Syntax](https://mermaid.js.org/syntax/timeline.html)
- [Event Formatting](https://mermaid.js.org/syntax/timeline.html)

### Git Graph
- [Git Graph Syntax](https://mermaid.js.org/syntax/gitgraph.html)
- [Commit Types](https://mermaid.js.org/syntax/gitgraph.html#commit-type)
- [Branch Operations](https://mermaid.js.org/syntax/gitgraph.html#branch)

### C4 Diagram
- [C4 Model Syntax](https://mermaid.js.org/syntax/c4Diagram.html)
- [System Context](https://mermaid.js.org/syntax/c4Diagram.html#system-context-diagram)
- [Container Diagram](https://mermaid.js.org/syntax/c4Diagram.html#container-diagram)

### User Journey
- [User Journey Syntax](https://mermaid.js.org/syntax/userJourney.html)
- [Scoring System](https://mermaid.js.org/syntax/userJourney.html#section)

### Requirement Diagram
- [Requirement Diagram Syntax](https://mermaid.js.org/syntax/requirementDiagram.html)
- [Element Types](https://mermaid.js.org/syntax/requirementDiagram.html#elements)

### Pie Chart
- [Pie Chart Syntax](https://mermaid.js.org/syntax/pie.html)
- [Data Format](https://mermaid.js.org/syntax/pie.html#pie-example)

### Quadrant Chart
- [Quadrant Chart Syntax](https://mermaid.js.org/syntax/quadrantChart.html)
- [Axis Configuration](https://mermaid.js.org/syntax/quadrantChart.html#quadrant)

### XY Chart
- [XY Chart Syntax](https://mermaid.js.org/syntax/xychart.html)
- [Data Plotting](https://mermaid.js.org/syntax/xychart.html#scatter-plot)

### Block Diagram
- [Block Diagram Syntax](https://mermaid.js.org/syntax/block.html)
- [Nested Blocks](https://mermaid.js.org/syntax/block.html#nested-blocks)

### Sankey Diagram
- [Sankey Diagram Syntax](https://mermaid.js.org/syntax/sankey.html)
- [Flow Visualization](https://mermaid.js.org/syntax/sankey.html)

### Kanban Board
- [Kanban Syntax](https://mermaid.js.org/syntax/kanban.html)
- [Task Management](https://mermaid.js.org/syntax/kanban.html)

### Packet Diagram
- [Packet Diagram Syntax](https://mermaid.js.org/syntax/packet.html)
- [Protocol Structures](https://mermaid.js.org/syntax/packet.html)

### Radar Chart
- [Radar Chart Syntax](https://mermaid.js.org/syntax/radar.html)
- [Multi-dimensional Data](https://mermaid.js.org/syntax/radar.html)

---

## Configuration & Customization

### Mermaid Initialize Options
- [Theme Configuration](https://mermaid.js.org/config/configuration.html#theming)
- [Theme Variables](https://mermaid.js.org/config/theming.html)
- [Diagram-Specific Config](https://mermaid.js.org/config/configuration.html#diagram-configurations)
- [Accessibility Options](https://mermaid.js.org/config/accessibility.html)

### Styling
- [CSS Classes](https://mermaid.js.org/syntax/flowchart.html#styling-and-classes)
- [Color Themes](https://mermaid.js.org/config/theming.html)
- [SVG Classes](https://mermaid.js.org/syntax/flowchart.html#styling-with-css-classes)

---

## Troubleshooting

### Common Issues

**Rendering Issues**
- [Mermaid Rendering Troubleshooting](https://mermaid.js.org/ecosystem/integrations.html#troubleshooting)
- [Security Level Configuration](https://mermaid.js.org/config/configuration.html#security-level)

**Performance**
- [Large Diagram Optimization](https://mermaid.js.org/config/configuration.html#performance)
- [Lazy Loading](https://mermaid.js.org/config/configuration.html#lazy-load-example)

**Browser Compatibility**
- [Supported Browsers](https://mermaid.js.org/intro/index.html#browser-support)
- [IE11 Polyfills](https://mermaid.js.org/ecosystem/integrations.html)

---

## Python Integration

### PyPI Packages
- [mermaid-py](https://pypi.org/project/mermaid-py/) - Python wrapper
- [pypyrus](https://pypi.org/project/pypyrus/) - Diagram generation library
- [diagrams](https://diagrams.mingrammer.com/) - AWS/infrastructure diagrams

### Browser Automation
- [Playwright Documentation](https://playwright.dev/) - Cross-browser automation
- [Playwright Python](https://playwright.dev/python/) - Python bindings

---

## Tools & Services

### Online Tools
- [Mermaid Live Editor](https://mermaid.live) - Official editor
- [Mermaid Editor Pro](https://mermaid.ink/) - Enhanced editor

### VS Code Extensions
- [Mermaid Markdown Syntax Highlighting](https://marketplace.visualstudio.com/items?itemName=bpruitt-goddard.mermaid-markdown-syntax-highlighting)
- [Markdown Preview Mermaid](https://marketplace.visualstudio.com/items?itemName=bierner.markdown-mermaid)
- [Mermaid Chart](https://marketplace.visualstudio.com/items?itemName=mermaid-js.mermaid-chart)

### GitHub Integration
- [GitHub Mermaid Support](https://docs.github.com/en/get-started/writing-on-github/working-with-advanced-formatting/creating-diagrams) - Native support in markdown

### CI/CD
- [GitHub Actions Mermaid](https://github.com/marketplace/actions/mermaid-cli-action) - Action for diagram generation
- [GitLab Mermaid Support](https://docs.gitlab.com/ee/user/markdown.html#diagrams) - Native support

---

## Best Practices

### Design Principles
- **Clarity**: Keep diagrams simple and focused
- **Hierarchy**: Use subgraphs to organize complex flows
- **Consistency**: Use same styling and notation throughout
- **Documentation**: Add notes and comments for clarity

### Performance Tips
1. Limit diagram complexity (max 100 nodes for flowcharts)
2. Use lazy loading for web applications
3. Cache rendered diagrams when possible
4. Validate syntax before rendering in production

### Accessibility
1. Add descriptive text and labels
2. Use high contrast colors
3. Provide alternative descriptions
4. Test with screen readers

---

## Version History

### v5.0.0 (Current)
- Added Python CLI tool (mermaid-to-svg-png.py)
- Support for all 21 diagram types
- Batch processing and automation
- GitHub Actions integration examples
- Comprehensive validation and error handling

### v4.0.0
- Foundation of Mermaid diagram support
- Nextra integration
- Auto-generation from source code

---

## Support & Community

- **GitHub Issues**: [mermaid-js/mermaid/issues](https://github.com/mermaid-js/mermaid/issues)
- **Discussions**: [mermaid-js/mermaid/discussions](https://github.com/mermaid-js/mermaid/discussions)
- **Community Chat**: [Mermaid Discord](https://discord.gg/mermaid)
- **Stack Overflow**: [mermaid tag](https://stackoverflow.com/questions/tagged/mermaid)

---

**Last Updated**: 2025-11-20
