# Official References

## Tailwind CSS Core Documentation

- Tailwind CSS Official Docs: https://tailwindcss.com/docs
- Tailwind CSS GitHub: https://github.com/tailwindlabs/tailwindcss
- Tailwind CSS Changelog: https://github.com/tailwindlabs/tailwindcss/releases
- Tailwind CSS Installation: https://tailwindcss.com/docs/installation
- Tailwind CSS Core Concepts: https://tailwindcss.com/docs/utility-first

## Tailwind CSS Features

- Responsive Design: https://tailwindcss.com/docs/responsive-design
- Dark Mode: https://tailwindcss.com/docs/dark-mode
- Hover, Focus & Other States: https://tailwindcss.com/docs/hover-focus-and-other-states
- Adding Custom Styles: https://tailwindcss.com/docs/adding-custom-styles
- Configuring Tailwind: https://tailwindcss.com/docs/configuration
- Plugins: https://tailwindcss.com/docs/plugins
- Theme Configuration: https://tailwindcss.com/docs/theme

## Tailwind UI & Components

- Tailwind UI: https://tailwindui.com/
- Tailwind UI Components Library: https://tailwindui.com/components
- Headless UI: https://headlessui.com/
- Radix UI (with Tailwind): https://www.radix-ui.com/

## Tailwind Ecosystem & Tools

- Tailwind CSS IntelliSense: https://marketplace.visualstudio.com/items?itemName=bradlc.vscode-tailwindcss
- Prettier Plugin (Tailwind): https://github.com/tailwindlabs/prettier-plugin-tailwindcss
- Tailwind CSS Cheat Sheet: https://nerdcave.com/tailwind-cheat-sheet
- Tailwind UI Kit: https://www.tailwind-kit.com/

## Design Systems & Patterns

- Tailwind CSS Design System: https://tailwindcss.com/docs/theme
- Design Tokens: https://designtokens.org/
- Utility-First CSS: https://tailwindcss.com/docs/utility-first
- Component Patterns: https://tailwindcss.com/docs/extracting-components

## Performance & Optimization

- Optimizing Bundle Size: https://tailwindcss.com/docs/optimizing-for-production
- Content Configuration: https://tailwindcss.com/docs/content-configuration
- Tree-shaking: https://webpack.js.org/guides/tree-shaking/
- PurgeCSS: https://purgecss.com/

## Related Technologies

- PostCSS: https://postcss.org/
- Webpack: https://webpack.js.org/
- Vite: https://vitejs.dev/
- Next.js Tailwind CSS: https://nextjs.org/docs/advanced-features/using-tailwind-css

## Learning Resources

- Tailwind CSS Official Blog: https://blog.tailwindcss.com/
- Tailwind CSS YouTube Channel: https://www.youtube.com/tailwindlabs
- Tailwind CSS Discord Community: https://discord.gg/7NF8GNe
- Tailwind CSS Twitter: https://twitter.com/tailwindcss
