---
name: moai-alfred-feedback-templates
version: 1.0.0
created: 2025-11-12
updated: 2025-11-12
status: stable
language: ko
description: |
  GitHub 이슈 라벨별 구조화된 템플릿. 버그, 기능 요청, 개선 사항, 리팩토링, 문서, 질문 등
  각 이슈 타입에 맞는 한국어 템플릿 제공. /alfred:9-feedback에서 사용.
keywords: ['feedback', 'templates', 'issue-creation', 'korean', 'structured-templates', 'bug-report', 'feature-request']
allowed-tools:
  - Read
---

# GitHub 이슈 작성 템플릿 모음 v1.0.0

## 개요

GitHub 이슈를 일관되고 명확하게 작성하기 위한 라벨별 구조화된 템플릿입니다.

각 라벨에 맞는 템플릿을 사용하면:
- ✅ **명확성**: 이슈 내용이 명확하고 구조화됨
- ✅ **효율성**: 누락된 정보가 줄어듦
- ✅ **일관성**: 팀 전체의 이슈 형식이 통일됨
- ✅ **추적성**: 모든 중요 정보가 기록됨

---

## 🐛 버그 리포트 템플릿

### 언제 사용?
- 예상하지 못한 동작이나 오류 발생
- 기능이 정상적으로 작동하지 않음
- 성능 저하 또는 비정상적인 동작

### 템플릿

```
## 버그 설명

[버그가 무엇인지 간단하게 설명하세요]

## 재현 단계

1. [첫 번째 단계]
2. [두 번째 단계]
3. [버그 발생하는 단계]

## 예상 동작

[정상적으로 동작해야 하는 내용 설명]

## 실제 동작

[실제로 일어나는 내용 설명]

## 환경 정보

- MoAI-ADK 버전: [버전]
- Python 버전: [버전]
- OS: [Windows/macOS/Linux]
- 브라우저: [선택사항]

## 추가 정보

[스크린샷, 에러 메시지, 로그 등]
```

### 예시

```
## 버그 설명

/alfred:1-plan 명령어 실행 시 스펙 생성이 안 됩니다.

## 재현 단계

1. `/alfred:1-plan "새로운 기능 추가"` 명령 실행
2. 단계 1~4를 모두 진행
3. 최종 확인 후 생성 버튼 클릭

## 예상 동작

새로운 SPEC 문서가 .moai/specs/SPEC-XXX/ 폴더에 생성되어야 함

## 실제 동작

"스펙 생성 실패" 에러 메시지만 출력되고 폴더 생성 안 됨

## 환경 정보

- MoAI-ADK 버전: 0.22.5
- Python 버전: 3.11.5
- OS: macOS 14.2
```

---

## ✨ 기능 요청 템플릿

### 언제 사용?
- 새로운 기능이 필요함
- 기존 기능의 개선 방안을 제안하고 싶음
- 새로운 명령어나 도구 추가를 요청

### 템플릿

```
## 기능 설명

[어떤 기능이 필요한지 설명하세요]

## 사용 시나리오

[이 기능이 언제/어떻게 사용될지 설명하세요]

예: 사용자가 X를 하려고 할 때, Y 기능이 있으면 Z를 쉽게 할 수 있습니다.

## 기대 효과

- [효과 1]
- [효과 2]
- [효과 3]

## 구현 아이디어 (선택사항)

[이 기능을 어떻게 구현할 수 있을지 아이디어가 있으면 제시하세요]

## 우선순위

- 🔴 긴급: 즉시 필요
- 🟠 높음: 곧 필요
- 🟡 중간: 적당히 필요 (기본값)
- 🟢 낮음: 나중에 괜찮음
```

### 예시

```
## 기능 설명

/alfred:9-feedback 명령어에 자동 정보 수집 기능이 필요합니다.
버그 리포트 시 환경 정보(버전, OS, Git 상태)를 자동으로 수집하면 좋을 것 같습니다.

## 사용 시나리오

버그를 발견한 사용자가 /alfred:9-feedback을 실행하면,
자동으로 MoAI-ADK 버전, Python 버전, 현재 Git 상태, 최근 에러 로그를 수집해서
이슈 본문에 포함시켜줍니다.

## 기대 효과

- 버그 리포팅 시간 단축 (수동 입력 제거)
- 환경 정보 누락 방지
- 버그 분석 시 필요한 정보를 처음부터 갖춤
```

---

## ⚡ 개선 사항 템플릿

### 언제 사용?
- 코드 품질 개선 제안
- 성능 최적화 아이디어
- 사용자 경험(UX) 개선
- 문서화 개선

### 템플릿

```
## 개선 내용

[무엇을 개선하고 싶은지 설명하세요]

## 현재 상태

[현재 어떻게 되어 있는지 설명하세요]

## 개선 후 상태

[개선되면 어떻게 달라질지 설명하세요]

## 성능/품질 영향

- 성능: [향상도, 예: 응답 시간 50% 단축]
- 사용성: [개선도, 예: 단계 2단계 감소]
- 유지보수성: [효과, 예: 코드 복잡도 30% 감소]

## 구현 복잡도

- ⚪ 낮음: 1-2시간
- 🟡 중간: 반나절
- 🔴 높음: 1일 이상
```

### 예시

```
## 개선 내용

AskUserQuestion의 단계를 줄여서 사용 편의성 개선

## 현재 상태

/alfred:9-feedback 실행 시 4단계 질문 (이슈 타입 → 제목 → 설명 → 우선순위)

## 개선 후 상태

1단계로 통합: 한 번에 필수 정보(타입, 우선순위) + 자동 템플릿 생성

## 성능/품질 영향

- 사용성: 4단계 → 1-2단계 (50% 단축)
- 시간: ~90초 → ~30초 (67% 단축)
```

---

## 🔄 리팩토링 템플릿

### 언제 사용?
- 기존 코드 재구성
- 설계 패턴 개선
- 기술 부채 해결
- 모듈 분리 또는 통합

### 템플릿

```
## 리팩토링 범위

[어떤 부분을 리팩토링할지 명확히 하세요]

예: src/moai_adk/core/template_engine.py 의 Template 클래스

## 현재 구조

[현재 코드의 구조나 문제점]

## 개선된 구조

[리팩토링 후 어떻게 바뀔지]

## 개선 이유

- [이유 1]
- [이유 2]
- [이유 3]

## 영향 분석

- 변경되는 모듈: [모듈 목록]
- 영향받는 테스트: [테스트 목록]
- 호환성: [호환성 유지 여부]
```

### 예시

```
## 리팩토링 범위

.claude/commands/alfred/ 의 명령어 파일들의 frontmatter 통일

## 현재 구조

각 명령어마다 frontmatter 형식이 다름:
- allowed-tools 리스트 형식 다름
- skills 섹션 있는 파일/없는 파일 혼재

## 개선된 구조

모든 명령어가 동일한 frontmatter 표준:
```
---
name: alfred:X
allowed-tools: [...]
skills: [...]
---
```

## 개선 이유

- 일관성: frontmatter 형식 통일
- 유지보수성: 스킬 추가/제거 명확화
- 자동화: 파싱 스크립트 단순화
```

---

## 📚 문서 템플릿

### 언제 사용?
- README, CLAUDE.md 같은 문서 개선
- 새로운 가이드/튜토리얼 작성
- 기존 문서의 명확성 개선
- 코드 주석/docstring 개선

### 템플릿

```
## 문서 내용

[무엇에 대한 문서인지 설명하세요]

## 대상 독자

[이 문서를 읽을 주요 독자는 누구인가요?]

예: 새 개발자, 팀 리더, API 사용자

## 문서 구조

[문서의 구조를 스케치하세요]

예:
1. 개요
2. 설치/설정
3. 사용법
4. FAQ
5. 참고자료

## 포함할 내용

- [내용 1]
- [내용 2]
- [내용 3]

## 관련 문서

[참고할 기존 문서들]
```

### 예시

```
## 문서 내용

/alfred:9-feedback 사용 가이드

## 대상 독자

MoAI-ADK 개발자, 버그/기능 리포팅이 처음인 팀원

## 문서 구조

1. 소개 (무엇인가)
2. 단계별 사용법 (어떻게 사용)
3. 라벨 설명 (어떤 라벨 사용)
4. 팁과 주의사항
5. FAQ

## 포함할 내용

- 명령어 실행 방법
- 각 단계별 화면
- 라벨 선택 가이드
- 환경 정보 자동 수집 설명
```

---

## ❓ 질문/토론 템플릿

### 언제 사용?
- 팀에게 물어볼 질문
- 의사결정이 필요한 사안
- 기술적 고민이나 제안

### 템플릿

```
## 배경

[이 질문/논의의 배경을 설명하세요]

## 질문 또는 제안

[핵심 질문을 명확하게 제시하세요]

## 선택지

- [ ] 선택지 1
- [ ] 선택지 2
- [ ] 선택지 3
- [ ] 기타

## 의사결정 기준

[어떤 기준으로 결정할지 설명하세요]

예: 개발 시간, 성능 영향, 팀 학습 곡선 등

## 추가 정보

[관련된 추가 정보나 참고자료]
```

### 예시

```
## 배경

/alfred:9-feedback의 AskUserQuestion 디자인 개선을 검토중입니다.
현재 4단계 질문이 많다는 피드백을 받았습니다.

## 질문 또는 제안

단계를 줄이기 위해 다음 중 어떤 방식이 좋을까요?

## 선택지

- [ ] multiSelect로 한 번에 필수 정보 수집 후 자동 템플릿 생성
- [ ] 기본값 최대화 (우선순위 기본값 medium, 설명 선택사항)
- [ ] Step 1에서 요약 정보만, Step 2에서 자세한 입력 받기
- [ ] 스크립트로 cli 형태로 변경 (예: `alfred:9-feedback bug "제목" -d "설명"`)

## 의사결정 기준

- 사용 편의성 (단계 최소화)
- 정보 수집 정확성 (필수 정보 누락 방지)
- 한국어 지원 일관성
```

---

## 📊 템플릿 비교

| 라벨 | 핵심 요소 | 최소 필드 | 추가 정보 |
|------|---------|---------|---------|
| **bug** | 재현 단계, 예상 vs 실제 | 설명, 환경 | 스크린샷, 로그 |
| **feature** | 시나리오, 효과 | 설명, 사용 경우 | 구현 아이디어 |
| **improvement** | 개선 전후, 이유 | 설명, 기대 효과 | 복잡도, 영향도 |
| **refactor** | 범위, 이유 | 현재 vs 개선 | 영향 분석 |
| **docs** | 대상 독자, 구조 | 내용 개요 | 포함 항목 목록 |
| **question** | 배경, 선택지 | 기준 | 관련 정보 |

---

## 🎯 템플릿 활용 팁

### DO ✅

- ✅ 템플릿의 모든 섹션을 채우세요
- ✅ 구체적이고 상세하게 작성하세요
- ✅ 환경/버전 정보를 정확하게 입력하세요
- ✅ 재현 단계를 단계별로 명확하게 기술하세요
- ✅ 스크린샷이나 에러 메시지를 첨부하세요

### DON'T ❌

- ❌ 템플릿의 섹션을 건너뛰지 마세요
- ❌ "작동 안 함" 같은 모호한 설명을 하지 마세요
- ❌ 환경 정보를 생략하지 마세요
- ❌ 여러 문제를 한 이슈에 섞지 마세요

---

## 🔗 참고

- **명령어**: `/alfred:9-feedback`
- **라벨 분류법**: `Skill("moai-core-issue-labels")`
- **이전 버전**: v0.22.5+부터 지원

---

**Last Updated**: 2025-11-12
**Status**: Production Ready (v1.0.0)
**Language**: Korean (한국어)
