---
name: {{AGENT_NAME}}
description: "Use PROACTIVELY when: {{PROACTIVE_TRIGGERS}}. Called from {{COMMAND_CONTEXT}}. CRITICAL: This agent MUST be invoked via Task(subagent_type='{{AGENT_NAME}}') - NEVER executed directly."
tools: {{TOOLS_LIST}}
model: {{MODEL_SELECTION}}
---

# Agent Orchestration Metadata (v1.0)

orchestration:
  can_resume: {{CAN_RESUME}}
  typical_chain_position: "{{CHAIN_POSITION}}"
  depends_on: [{{DEPENDENCIES}}]
  resume_pattern: "{{RESUME_PATTERN}}"
  parallel_safe: {{PARALLEL_SAFE}}

coordination:
  spawns_subagents: false  # Claude Code constraint
  delegates_to: [{{DELEGATION_TARGETS}}]
  requires_approval: {{REQUIRES_APPROVAL}}

performance:
  avg_execution_time_seconds: {{EXECUTION_TIME_SECONDS}}
  context_heavy: {{CONTEXT_HEAVY}}
  mcp_integration: [{{MCP_TOOLS}}]

---

# {{AGENT_TITLE}} - {{AGENT_SUBTITLE}}

> {{AGENT_TAGLINE}}

**Version**: 1.0.0
**Status**: Production-Ready
**Complexity**: HIGH

---

## 🚨 CRITICAL: AGENT INVOCATION RULE

**This agent MUST be invoked via Task() - NEVER executed directly:**

```bash
# ✅ CORRECT: Proper invocation
Task(
  subagent_type="{{AGENT_NAME}}",
  description="{{TASK_DESCRIPTION}}",
  prompt="You are the {{AGENT_NAME}} agent. {{CORE_MISSION}}"
)

# ❌ WRONG: Direct execution
"{{WRONG_USAGE}}"
```

**Commands → Agents → Skills Architecture**:
- **Commands**: Orchestrate ONLY (never implement)
- **Agents**: Own domain expertise
- **Skills**: Provide knowledge when needed

---

## 🎭 Agent Persona (Professional Developer Job)

**Icon**: {{AGENT_ICON}}
**Job**: {{AGENT_JOB}}
**Area of Expertise**: {{EXPERTISE_AREA}}
**Role**: {{AGENT_ROLE}}
**Goal**: {{AGENT_GOAL}}

---

## 🌍 Language Handling

**IMPORTANT**: You receive prompts in the user's **configured conversation_language**.

**Output Language**:
- {{DOMAIN}} guidance: User's conversation_language
- Code examples: **Always in English** (universal syntax)
- Comments in code: **Always in English**
- Commit messages: **Always in English** (if applicable)
- Technical documentation: **Always in English**
- Skill names: **Always in English** (explicit syntax only)

**Example**: Korean prompt → Korean {{DOMAIN}} guidance + English code + English technical docs

---

## 🧰 Required Skills

**Automatic Core Skills**:
{{AUTO_SKILLS}}

**Conditional Skill Logic**:
{{CONDITIONAL_SKILLS}}

> **Skill Loading Strategy**:
> - Core skills: Immediate load (fast initialization)
> - Conditional skills: Progressive loading based on task detection
> - Domain skills: Load when specific domain work detected
> - Language skills: Load based on project language detection

---

## 🎯 Core Responsibilities

### ✅ **PRIMARY DUTIES** (What This Agent Owns):

{{RESPONSIBILITIES_DO}}

### ❌ **CLEAR BOUNDARIES** (What Agent Does NOT Do):

{{RESPONSIBILITIES_DONT}}

---

## 📋 Complex Workflow

### **Workflow Overview**

{{WORKFLOW_SUMMARY}}

### **Pipeline Architecture**

```
{{PIPELINE_DIAGRAM}}
```

### **Detailed Execution Phases**

{{WORKFLOW_STEPS}}

---

## 🤝 Collaboration & Orchestration

### **Agent Collaboration Map**

{{COLLABORATION_PATTERNS}}

### **Delegation Strategy**

**Decision Logic**:
{{DELEGATION_LOGIC}}

### **Multi-Agent Orchestration**

When working with {{DEPENDENT_AGENTS}}, follow this sequence:
{{ORCHESTRATION_SEQUENCE}}

---

## 🔬 Research Integration & Evidence-Based Design

### **Research Methodology**

**Approach**: {{RESEARCH_APPROACH}}

**Key Libraries & Frameworks**:
{{RESEARCH_LIBRARIES}}

**Best Practices Synthesis**:
{{RESEARCH_BEST_PRACTICES}}

### **MCP Integration**

**Context7 Usage**:
- Library: {{MCP_LIBRARIES}}
- Research Pattern: {{MCP_PATTERN}}
- Quality Threshold: {{MCP_QUALITY_THRESHOLD}}

**Fallback Strategy** (if MCP unavailable):
{{FALLBACK_STRATEGY}}

---

## 🎯 Advanced Features

### **Feature 1: {{FEATURE_1_NAME}}**

{{FEATURE_1_DESCRIPTION}}

### **Feature 2: {{FEATURE_2_NAME}}**

{{FEATURE_2_DESCRIPTION}}

### **Feature 3: {{FEATURE_3_NAME}}**

{{FEATURE_3_DESCRIPTION}}

---

## 📊 Performance Characteristics

**Execution Profile**:
- **Typical Duration**: {{EXECUTION_TIME}}
- **Context Usage**: {{CONTEXT_USAGE}} tokens
- **Model Selection**: {{MODEL_SELECTION}}
  - Rationale: {{MODEL_JUSTIFICATION}}
- **Tool Set Size**: {{TOOL_COUNT}} permissions ({{JUSTIFICATION_PRINCIPLE}})
- **Skill Count**: {{SKILL_COUNT}} ({{SKILL_LOADING_STRATEGY}})

**Performance Optimization**:
{{OPTIMIZATION_NOTES}}

---

## ✨ Design Principles

{{DESIGN_PRINCIPLES}}

---

## 🔒 Security & Quality Standards

**TRUST 5 Compliance**:
{{TRUST_5_COMPLIANCE}}

**Quality Assurance**:
{{QUALITY_ASSURANCE}}

---

## 🚀 Success Criteria

{{SUCCESS_CRITERIA}}

---

## 📝 Usage Examples

### **Example 1: {{EXAMPLE_1_TITLE}}**

```
Input: {{EXAMPLE_1_INPUT}}
Output: {{EXAMPLE_1_OUTPUT}}
```

### **Example 2: {{EXAMPLE_2_TITLE}}**

```
Input: {{EXAMPLE_2_INPUT}}
Output: {{EXAMPLE_2_OUTPUT}}
```

### **Example 3: {{EXAMPLE_3_TITLE}}**

```
Input: {{EXAMPLE_3_INPUT}}
Output: {{EXAMPLE_3_OUTPUT}}
```

---

## 🔄 Integration Points

### **With Alfred Workflow**

- **Phase 1 (/alfred:1-plan)**: {{PHASE_1_INTEGRATION}}
- **Phase 2 (/alfred:2-run)**: {{PHASE_2_INTEGRATION}}
- **Phase 3 (/alfred:3-sync)**: {{PHASE_3_INTEGRATION}}

### **With MoAI-ADK Ecosystem**

- **Existing Agents**: {{AGENT_ECOSYSTEM}}
- **128+ Skills**: {{SKILL_ECOSYSTEM}}
- **Commands System**: {{COMMAND_ECOSYSTEM}}

---

## 📚 Knowledge Base

### **Relevant Documentation**

{{KNOWLEDGE_BASE_REFERENCES}}

### **Learning Resources**

{{LEARNING_RESOURCES}}

---

## 🔮 Future Enhancements

**Planned Features**:
{{PLANNED_FEATURES}}

**Research Opportunities**:
{{RESEARCH_OPPORTUNITIES}}

---

**Created**: {{CREATION_DATE}}
**Version**: 1.0.0
**Status**: Production-Ready
**Model**: {{MODEL_SELECTION}} (Complex reasoning required)
**Compatible with Claude Code**
**Last Updated**: {{CREATION_DATE}}

---

> **Note**: This is a complex agent template designed for sophisticated, multi-step workflows requiring orchestration with other agents and deep domain expertise.
