---
name: "moai-cc-skills"
version: "2.0.0"
created: 2025-10-22
updated: 2025-11-11
status: stable
description: Claude Code Skills management, skill creation patterns, and knowledge capsule architecture. Use when creating custom Skills, managing skill libraries, or designing knowledge systems.
keywords: ['skills', 'knowledge-capsules', 'claude-code', 'skill-creation', 'management']
allowed-tools: 
  - Read
  - Bash
  - Glob
---

# Claude Code Skills Management

## Skill Metadata

| Field | Value |
| ----- | ----- |
| **Skill Name** | moai-cc-skills |
| **Version** | 2.0.0 (2025-11-11) |
| **Allowed tools** | Read, Bash, Glob |
| **Auto-load** | On demand when skill management detected |
| **Tier** | Claude Code (Core) |

---

## What It Does

Claude Code Skills management, skill creation patterns, and knowledge capsule architecture.

**Key capabilities**:
- ✅ Skill creation guidelines
- ✅ Knowledge capsule architecture
- ✅ Skill library management
- ✅ Progressive disclosure patterns
- ✅ Metadata standards

---

## When to Use

- ✅ Creating custom Skills
- ✅ Managing skill libraries
- ✅ Designing knowledge systems
- ✅ Optimizing skill loading

---

## Core Skill Patterns

### Skill Architecture
1. **Knowledge Capsules**: <500-word focused content
2. **Progressive Disclosure**: Load on-demand based on keywords
3. **Metadata Standards**: Consistent skill identification
4. **Template System**: Reusable skill patterns
5. **Quality Gates**: Validation and review processes

### Creation Workflow
- **Problem Definition**: Clear skill purpose
- **Content Design**: Structured knowledge delivery
- **Metadata Assignment**: Proper categorization
- **Quality Review**: Content validation
- **Integration Testing**: Skill activation verification

---

## Dependencies

- Claude Code environment
- Skill template system
- Metadata standards
- Quality validation processes

---

## Works Well With

- `moai-cc-skill-factory` (Skill creation)
- `moai-cc-memory` (Knowledge management)
- `moai-cc-settings` (Configuration)

---

## Changelog

- **v2.0.0** (2025-11-11): Added complete metadata, skill architecture patterns
- **v1.0.0** (2025-10-22): Initial skills management

---

**End of Skill** | Updated 2025-11-11
