# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawTasksClient, RawTasksClient
from .types.tasks_create_response import TasksCreateResponse
from .types.tasks_get_response import TasksGetResponse
from .types.tasks_list_response import TasksListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TasksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTasksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTasksClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TasksListResponse:
        """
        Retrieves a paginated list of all tasks for the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TasksListResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.tasks.list()
        """
        _response = self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> TasksCreateResponse:
        """
        Creates a new task item. See [Tasks](/docs/tasks) for detailed coverage of all available props and values.

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TasksCreateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.tasks.create(
            request={
                "file_id": "file_abcdefgh1234",
                "kind": "image",
                "width": 320,
                "format": "png",
                "ref": "thumbnail",
            },
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> TasksGetResponse:
        """
        Retrieves the task object for a task with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TasksGetResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.tasks.get(
            id="task_abcdefgh1234",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def get_task_config(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Retrieves available task kinds and their configuration options.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Task configuration details.

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.tasks.get_task_config()
        """
        _response = self._raw_client.get_task_config(request_options=request_options)
        return _response.data


class AsyncTasksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTasksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTasksClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TasksListResponse:
        """
        Retrieves a paginated list of all tasks for the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TasksListResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tasks.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> TasksCreateResponse:
        """
        Creates a new task item. See [Tasks](/docs/tasks) for detailed coverage of all available props and values.

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TasksCreateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tasks.create(
                request={
                    "file_id": "file_abcdefgh1234",
                    "kind": "image",
                    "width": 320,
                    "format": "png",
                    "ref": "thumbnail",
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> TasksGetResponse:
        """
        Retrieves the task object for a task with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TasksGetResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tasks.get(
                id="task_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def get_task_config(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Retrieves available task kinds and their configuration options.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Task configuration details.

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tasks.get_task_config()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_task_config(request_options=request_options)
        return _response.data
