# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from .types.signatures_create_request_method import SignaturesCreateRequestMethod
from .types.signatures_create_response import SignaturesCreateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSignaturesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        filename: str,
        folder: typing.Optional[str] = OMIT,
        expiry: typing.Optional[int] = OMIT,
        method: typing.Optional[SignaturesCreateRequestMethod] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SignaturesCreateResponse]:
        """
        You can use signatures to create signed URLs which grant access to your project's resources, without revealing your project's API key. URLs can expire after a specified time and be limited to HTTP `GET` method for read-only access, or HTTP `PUT` method for client-side uploads.

        Parameters
        ----------
        filename : str

        folder : typing.Optional[str]

        expiry : typing.Optional[int]

        method : typing.Optional[SignaturesCreateRequestMethod]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SignaturesCreateResponse]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            "signatures",
            method="POST",
            json={
                "filename": filename,
                "folder": folder,
                "expiry": expiry,
                "method": method,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SignaturesCreateResponse,
                    construct_type(
                        type_=SignaturesCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSignaturesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        filename: str,
        folder: typing.Optional[str] = OMIT,
        expiry: typing.Optional[int] = OMIT,
        method: typing.Optional[SignaturesCreateRequestMethod] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SignaturesCreateResponse]:
        """
        You can use signatures to create signed URLs which grant access to your project's resources, without revealing your project's API key. URLs can expire after a specified time and be limited to HTTP `GET` method for read-only access, or HTTP `PUT` method for client-side uploads.

        Parameters
        ----------
        filename : str

        folder : typing.Optional[str]

        expiry : typing.Optional[int]

        method : typing.Optional[SignaturesCreateRequestMethod]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SignaturesCreateResponse]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "signatures",
            method="POST",
            json={
                "filename": filename,
                "folder": folder,
                "expiry": expiry,
                "method": method,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SignaturesCreateResponse,
                    construct_type(
                        type_=SignaturesCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
