# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawSignaturesClient, RawSignaturesClient
from .types.signatures_create_request_method import SignaturesCreateRequestMethod
from .types.signatures_create_response import SignaturesCreateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SignaturesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSignaturesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSignaturesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSignaturesClient
        """
        return self._raw_client

    def create(
        self,
        *,
        filename: str,
        folder: typing.Optional[str] = OMIT,
        expiry: typing.Optional[int] = OMIT,
        method: typing.Optional[SignaturesCreateRequestMethod] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SignaturesCreateResponse:
        """
        You can use signatures to create signed URLs which grant access to your project's resources, without revealing your project's API key. URLs can expire after a specified time and be limited to HTTP `GET` method for read-only access, or HTTP `PUT` method for client-side uploads.

        Parameters
        ----------
        filename : str

        folder : typing.Optional[str]

        expiry : typing.Optional[int]

        method : typing.Optional[SignaturesCreateRequestMethod]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SignaturesCreateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.signatures.create(
            filename="video.mp4",
            folder="example",
            expiry=1735689600,
            method="put",
        )
        """
        _response = self._raw_client.create(
            filename=filename, folder=folder, expiry=expiry, method=method, request_options=request_options
        )
        return _response.data


class AsyncSignaturesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSignaturesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSignaturesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSignaturesClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        filename: str,
        folder: typing.Optional[str] = OMIT,
        expiry: typing.Optional[int] = OMIT,
        method: typing.Optional[SignaturesCreateRequestMethod] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SignaturesCreateResponse:
        """
        You can use signatures to create signed URLs which grant access to your project's resources, without revealing your project's API key. URLs can expire after a specified time and be limited to HTTP `GET` method for read-only access, or HTTP `PUT` method for client-side uploads.

        Parameters
        ----------
        filename : str

        folder : typing.Optional[str]

        expiry : typing.Optional[int]

        method : typing.Optional[SignaturesCreateRequestMethod]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SignaturesCreateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.signatures.create(
                filename="video.mp4",
                folder="example",
                expiry=1735689600,
                method="put",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            filename=filename, folder=folder, expiry=expiry, method=method, request_options=request_options
        )
        return _response.data
