# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.media_list_response import MediaListResponse
from .raw_client import AsyncRawMediaClient, RawMediaClient
from .types.media_create_response import MediaCreateResponse
from .types.media_delete_response import MediaDeleteResponse
from .types.media_get_response import MediaGetResponse
from .types.media_update_response import MediaUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MediaClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMediaClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMediaClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMediaClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MediaListResponse:
        """
        Retrieves a paginated list of all media for the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaListResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.media.list()
        """
        _response = self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        title: typing.Optional[str] = OMIT,
        alt: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MediaCreateResponse:
        """
        Creates a new media item. See [Media Object](/docs/media) for more details.

        Parameters
        ----------
        title : typing.Optional[str]

        alt : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaCreateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.media.create(
            title="My Video Example",
            alt="An example video used to demonstrate the ittybit API",
            metadata={"customKey2": "a different custom value"},
        )
        """
        _response = self._raw_client.create(title=title, alt=alt, metadata=metadata, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MediaGetResponse:
        """
        Retrieves the media object for a media with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaGetResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.media.get(
            id="med_abcdefgh1234",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MediaDeleteResponse:
        """
        Permanently removes a media object from the system. This action cannot be undone.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaDeleteResponse
            Accepted

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.media.delete(
            id="med_abcdefgh1234",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        title: typing.Optional[str] = OMIT,
        alt: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MediaUpdateResponse:
        """
        Updates a media object's `title`, `alt`, or `metadata`. Only the specified fields will be updated.

        Parameters
        ----------
        id : str

        title : typing.Optional[str]

        alt : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaUpdateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.media.update(
            id="med_abcdefgh1234",
            title="Updated Video Example",
            alt="An updated example video used to demonstrate the ittybit API",
            metadata={"customKey2": "a different custom value"},
        )
        """
        _response = self._raw_client.update(
            id, title=title, alt=alt, metadata=metadata, request_options=request_options
        )
        return _response.data


class AsyncMediaClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMediaClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMediaClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMediaClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MediaListResponse:
        """
        Retrieves a paginated list of all media for the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaListResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.media.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        title: typing.Optional[str] = OMIT,
        alt: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MediaCreateResponse:
        """
        Creates a new media item. See [Media Object](/docs/media) for more details.

        Parameters
        ----------
        title : typing.Optional[str]

        alt : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaCreateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.media.create(
                title="My Video Example",
                alt="An example video used to demonstrate the ittybit API",
                metadata={"customKey2": "a different custom value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            title=title, alt=alt, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MediaGetResponse:
        """
        Retrieves the media object for a media with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaGetResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.media.get(
                id="med_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MediaDeleteResponse:
        """
        Permanently removes a media object from the system. This action cannot be undone.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaDeleteResponse
            Accepted

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.media.delete(
                id="med_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        title: typing.Optional[str] = OMIT,
        alt: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MediaUpdateResponse:
        """
        Updates a media object's `title`, `alt`, or `metadata`. Only the specified fields will be updated.

        Parameters
        ----------
        id : str

        title : typing.Optional[str]

        alt : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MediaUpdateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.media.update(
                id="med_abcdefgh1234",
                title="Updated Video Example",
                alt="An updated example video used to demonstrate the ittybit API",
                metadata={"customKey2": "a different custom value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, title=title, alt=alt, metadata=metadata, request_options=request_options
        )
        return _response.data
