# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawFilesClient, RawFilesClient
from .types.files_create_response import FilesCreateResponse
from .types.files_delete_response import FilesDeleteResponse
from .types.files_get_response import FilesGetResponse
from .types.files_list_response import FilesListResponse
from .types.files_update_response import FilesUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFilesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesListResponse:
        """
        Retrieves a paginated list of all files associated with the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesListResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.files.list()
        """
        _response = self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        url: str,
        media_id: typing.Optional[str] = OMIT,
        folder: typing.Optional[str] = OMIT,
        filename: typing.Optional[str] = OMIT,
        ref: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesCreateResponse:
        """
        Creates a new file from a publicly accessible or signed URL.

        Parameters
        ----------
        url : str

        media_id : typing.Optional[str]

        folder : typing.Optional[str]

        filename : typing.Optional[str]

        ref : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesCreateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.files.create(
            url="https://ittyb.it/sample.mp4",
            folder="ittybit/samples",
            filename="video.mp4",
            metadata={"customKey": "your custom value"},
        )
        """
        _response = self._raw_client.create(
            url=url,
            media_id=media_id,
            folder=folder,
            filename=filename,
            ref=ref,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FilesGetResponse:
        """
        Retrieve the file object for a file with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesGetResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.files.get(
            id="file_abcdefgh1234",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FilesDeleteResponse:
        """
        Permanently removes a file from the system. This action cannot be undone.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesDeleteResponse
            Accepted

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.files.delete(
            id="file_abcdefgh1234",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        folder: typing.Optional[str] = OMIT,
        filename: typing.Optional[str] = OMIT,
        ref: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesUpdateResponse:
        """
        Update a file's `filename`, `folder`, `ref`, or `metadata`. Only the specified fields will be updated.

        Parameters
        ----------
        id : str

        folder : typing.Optional[str]

        filename : typing.Optional[str]

        ref : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesUpdateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.files.update(
            id="file_abcdefgh1234",
            folder="updated/folder",
            filename="new_filename.mp4",
            metadata={"customKey2": "a different custom value"},
        )
        """
        _response = self._raw_client.update(
            id, folder=folder, filename=filename, ref=ref, metadata=metadata, request_options=request_options
        )
        return _response.data


class AsyncFilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFilesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesListResponse:
        """
        Retrieves a paginated list of all files associated with the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesListResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.files.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        url: str,
        media_id: typing.Optional[str] = OMIT,
        folder: typing.Optional[str] = OMIT,
        filename: typing.Optional[str] = OMIT,
        ref: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesCreateResponse:
        """
        Creates a new file from a publicly accessible or signed URL.

        Parameters
        ----------
        url : str

        media_id : typing.Optional[str]

        folder : typing.Optional[str]

        filename : typing.Optional[str]

        ref : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesCreateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.files.create(
                url="https://ittyb.it/sample.mp4",
                folder="ittybit/samples",
                filename="video.mp4",
                metadata={"customKey": "your custom value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            url=url,
            media_id=media_id,
            folder=folder,
            filename=filename,
            ref=ref,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FilesGetResponse:
        """
        Retrieve the file object for a file with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesGetResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.files.get(
                id="file_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FilesDeleteResponse:
        """
        Permanently removes a file from the system. This action cannot be undone.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesDeleteResponse
            Accepted

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.files.delete(
                id="file_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        folder: typing.Optional[str] = OMIT,
        filename: typing.Optional[str] = OMIT,
        ref: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesUpdateResponse:
        """
        Update a file's `filename`, `folder`, `ref`, or `metadata`. Only the specified fields will be updated.

        Parameters
        ----------
        id : str

        folder : typing.Optional[str]

        filename : typing.Optional[str]

        ref : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesUpdateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.files.update(
                id="file_abcdefgh1234",
                folder="updated/folder",
                filename="new_filename.mp4",
                metadata={"customKey2": "a different custom value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, folder=folder, filename=filename, ref=ref, metadata=metadata, request_options=request_options
        )
        return _response.data
