# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAutomationsClient, RawAutomationsClient
from .requests.automations_create_request_trigger import AutomationsCreateRequestTriggerParams
from .requests.automations_create_request_workflow_item import AutomationsCreateRequestWorkflowItemParams
from .requests.automations_update_request_trigger import AutomationsUpdateRequestTriggerParams
from .requests.automations_update_request_workflow_item import AutomationsUpdateRequestWorkflowItemParams
from .types.automations_create_request_status import AutomationsCreateRequestStatus
from .types.automations_create_response import AutomationsCreateResponse
from .types.automations_delete_response import AutomationsDeleteResponse
from .types.automations_get_response import AutomationsGetResponse
from .types.automations_list_response import AutomationsListResponse
from .types.automations_update_request_status import AutomationsUpdateRequestStatus
from .types.automations_update_response import AutomationsUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AutomationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAutomationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAutomationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAutomationsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationsListResponse:
        """
        Retrieves a paginated list of all automations for the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsListResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.automations.list()
        """
        _response = self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        trigger: AutomationsCreateRequestTriggerParams,
        workflow: typing.Sequence[AutomationsCreateRequestWorkflowItemParams],
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[AutomationsCreateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationsCreateResponse:
        """
        Creates a new automation.

        Parameters
        ----------
        trigger : AutomationsCreateRequestTriggerParams

        workflow : typing.Sequence[AutomationsCreateRequestWorkflowItemParams]

        name : typing.Optional[str]

        description : typing.Optional[str]

        status : typing.Optional[AutomationsCreateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsCreateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.automations.create(
            name="My Example Automation",
            description="This workflow will run whenever new media is created.",
            trigger={"kind": "event", "event": "media.created"},
            workflow=[
                {"kind": "description"},
                {"kind": "image", "ref": "thumbnail"},
                {"kind": "video", "next": [{"kind": "subtitles", "ref": "subtitles"}]},
            ],
            status="active",
        )
        """
        _response = self._raw_client.create(
            trigger=trigger,
            workflow=workflow,
            name=name,
            description=description,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AutomationsGetResponse:
        """
        Retrieve the automation object for a automation with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsGetResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.automations.get(
            id="auto_abcdefgh1234",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AutomationsDeleteResponse:
        """
        Permanently removes an automation from the system. This action cannot be undone.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsDeleteResponse
            Accepted

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.automations.delete(
            id="auto_abcdefgh1234",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        trigger: typing.Optional[AutomationsUpdateRequestTriggerParams] = OMIT,
        workflow: typing.Optional[typing.Sequence[AutomationsUpdateRequestWorkflowItemParams]] = OMIT,
        status: typing.Optional[AutomationsUpdateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationsUpdateResponse:
        """
        Updates an automation's `name`, `description`, `trigger`, `workflow`, or `status`. Only the specified fields will be updated.

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        trigger : typing.Optional[AutomationsUpdateRequestTriggerParams]

        workflow : typing.Optional[typing.Sequence[AutomationsUpdateRequestWorkflowItemParams]]

        status : typing.Optional[AutomationsUpdateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsUpdateResponse
            Success

        Examples
        --------
        from ittybit import Ittybit

        client = Ittybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.automations.update(
            id="auto_abcdefgh1234",
            name="My Updated Automation",
            workflow=[
                {"kind": "nsfw"},
                {"kind": "description"},
                {"kind": "image", "ref": "big_thumbnail"},
                {"kind": "video", "next": [{"kind": "subtitle", "ref": "subtitle"}]},
            ],
            status="active",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            description=description,
            trigger=trigger,
            workflow=workflow,
            status=status,
            request_options=request_options,
        )
        return _response.data


class AsyncAutomationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAutomationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAutomationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAutomationsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationsListResponse:
        """
        Retrieves a paginated list of all automations for the current project.

        Parameters
        ----------
        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsListResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.automations.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(page=page, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        trigger: AutomationsCreateRequestTriggerParams,
        workflow: typing.Sequence[AutomationsCreateRequestWorkflowItemParams],
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        status: typing.Optional[AutomationsCreateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationsCreateResponse:
        """
        Creates a new automation.

        Parameters
        ----------
        trigger : AutomationsCreateRequestTriggerParams

        workflow : typing.Sequence[AutomationsCreateRequestWorkflowItemParams]

        name : typing.Optional[str]

        description : typing.Optional[str]

        status : typing.Optional[AutomationsCreateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsCreateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.automations.create(
                name="My Example Automation",
                description="This workflow will run whenever new media is created.",
                trigger={"kind": "event", "event": "media.created"},
                workflow=[
                    {"kind": "description"},
                    {"kind": "image", "ref": "thumbnail"},
                    {
                        "kind": "video",
                        "next": [{"kind": "subtitles", "ref": "subtitles"}],
                    },
                ],
                status="active",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            trigger=trigger,
            workflow=workflow,
            name=name,
            description=description,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AutomationsGetResponse:
        """
        Retrieve the automation object for a automation with the given ID.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsGetResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.automations.get(
                id="auto_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AutomationsDeleteResponse:
        """
        Permanently removes an automation from the system. This action cannot be undone.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsDeleteResponse
            Accepted

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.automations.delete(
                id="auto_abcdefgh1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        trigger: typing.Optional[AutomationsUpdateRequestTriggerParams] = OMIT,
        workflow: typing.Optional[typing.Sequence[AutomationsUpdateRequestWorkflowItemParams]] = OMIT,
        status: typing.Optional[AutomationsUpdateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutomationsUpdateResponse:
        """
        Updates an automation's `name`, `description`, `trigger`, `workflow`, or `status`. Only the specified fields will be updated.

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        trigger : typing.Optional[AutomationsUpdateRequestTriggerParams]

        workflow : typing.Optional[typing.Sequence[AutomationsUpdateRequestWorkflowItemParams]]

        status : typing.Optional[AutomationsUpdateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutomationsUpdateResponse
            Success

        Examples
        --------
        import asyncio

        from ittybit import AsyncIttybit

        client = AsyncIttybit(
            version="YOUR_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.automations.update(
                id="auto_abcdefgh1234",
                name="My Updated Automation",
                workflow=[
                    {"kind": "nsfw"},
                    {"kind": "description"},
                    {"kind": "image", "ref": "big_thumbnail"},
                    {
                        "kind": "video",
                        "next": [{"kind": "subtitle", "ref": "subtitle"}],
                    },
                ],
                status="active",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            description=description,
            trigger=trigger,
            workflow=workflow,
            status=status,
            request_options=request_options,
        )
        return _response.data
