/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * @summary The properties for the CloudFrontToS3 Construct
 */
export interface CloudFrontToS3Props {
    /**
     * Existing instance of S3 Bucket object, providing both this and `bucketProps` will cause an error.
     *
     * @default - None
     */
    readonly existingBucketObj?: s3.IBucket;
    /**
     * Optional user provided props to override the default props for the S3 Bucket.
     *
     * @default - Default props are used
     */
    readonly bucketProps?: s3.BucketProps;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly cloudFrontDistributionProps?: cloudfront.DistributionProps | any;
    /**
     * Optional user provided props to turn on/off the automatic injection of best practice HTTP security headers in all responses from cloudfront.
     *
     * @default - true
     */
    readonly insertHttpSecurityHeaders?: boolean;
    /**
     * Optional user provided props to provide an originPath that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
     *
     * The string should start with a `/`, for example `/production`.
     *
     * @dafault = '/'
     */
    readonly originPath?: string;
    /**
     * Optional user provided props to override the default props for the S3 Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly loggingBucketProps?: s3.BucketProps;
    /**
     * Optional user provided props to override the default props for the CloudFront Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly cloudFrontLoggingBucketProps?: s3.BucketProps;
    /**
     * Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
     *
     * Enabling Access Logging is a best practice.
     *
     * @default - true
     */
    readonly logS3AccessLogs?: boolean;
}
export declare class CloudFrontToS3 extends Construct {
    readonly cloudFrontWebDistribution: cloudfront.Distribution;
    readonly cloudFrontFunction?: cloudfront.Function;
    readonly cloudFrontLoggingBucket?: s3.Bucket;
    readonly s3BucketInterface: s3.IBucket;
    readonly s3Bucket?: s3.Bucket;
    readonly s3LoggingBucket?: s3.Bucket;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the CloudFrontToS3 class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: CloudFrontToS3Props);
}
