(self["webpackChunkauthor_ide_extension"] = self["webpackChunkauthor_ide_extension"] || []).push([["lib_index_js"],{

/***/ "./lib/button/index.js":
/*!*****************************!*\
  !*** ./lib/button/index.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ButtonExtension": () => (/* binding */ ButtonExtension),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/disposable */ "webpack/sharing/consume/default/@lumino/disposable");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/mainmenu */ "webpack/sharing/consume/default/@jupyterlab/mainmenu");
/* harmony import */ var _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../tools */ "./lib/tools.js");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../handler */ "./lib/handler.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../config */ "./lib/config.js");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4__);









/**
 * The plugin registration information.
 */
const plugin = {
    activate,
    id: 'author-ide-extension:plugin',
    autoStart: true,
    requires: [_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_4__.INotebookTracker, _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_0__.IDocumentManager, _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_3__.IMainMenu]
};
/**
 * A notebook widget extension that adds a button to the toolbar.
 */
class ButtonExtension {
    /**
     * Create a new extension for the notebook panel widget.
     *
     * @param panel Notebook panel
     * @param context Notebook context
     * @returns Disposable on the added button
     */
    createNew(panel, context) {
        const start = async () => {
            // Get the current file contents
            const file = await (0,_tools__WEBPACK_IMPORTED_MODULE_5__.getFileContents)(panel, context);
            console.log(file);
            // POST to Atlas the file contents/lab model
            (0,_handler__WEBPACK_IMPORTED_MODULE_6__.postLabModel)((0,_handler__WEBPACK_IMPORTED_MODULE_6__.axiosHandler)(_config__WEBPACK_IMPORTED_MODULE_7__.Globals.token), file);
        };
        const button = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton({
            className: 'publish-lab-button',
            label: 'Publish',
            onClick: start,
            tooltip: 'Publish Lab'
        });
        panel.toolbar.insertItem(10, 'publish', button);
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__.DisposableDelegate(() => {
            button.dispose();
        });
    }
}
/**
 * Activate the extension.
 *
 * @param app Main application object
 */
async function activate(app, mainMenu) {
    console.log("Activated Author-ide-extension button plugin!");
    // Add the Publish widget to the lab environment
    app.docRegistry.addWidgetExtension('Notebook', new ButtonExtension());
    // TO DO: Change logic so that we check if the file exists first before trying to open it...
    // TO DO: Add logic to rename the default file opened to lab's name
    // Attempt to open the lab
    await app.commands.execute('docmanager:open', {
        path: 'Untitled.ipynb',
        kernel: { name: 'python' }
    })
        // The lab was created in a previous session, open up the existing lab
        .then(async (widget) => {
        console.log('Successfully got existing file');
        // Only try to load up lab when author is not in local authoring env
        // TODO: Refactor this and make it better :')
        let token = (0,_config__WEBPACK_IMPORTED_MODULE_7__.ATLAS_TOKEN)();
        if (token !== null || token !== 'NO_TOKEN') {
            // Load the contents of the lab into the notebook
            await (0,_tools__WEBPACK_IMPORTED_MODULE_5__.loadLabContents)(widget, (0,_handler__WEBPACK_IMPORTED_MODULE_6__.axiosHandler)(), _config__WEBPACK_IMPORTED_MODULE_7__.Globals.author_env)
                .then(() => widget.show())
                .catch();
        }
    })
        // This is the user's first session, create the lab first and open it for them
        .catch(async () => {
        console.log('Could not open file. Creating new file.');
        // Create a new notebook with Panel
        const nbPanel = await app.commands.execute('notebook:create-new', { kernelName: 'python', activate: true });
        console.log('Created a new file!');
        let token = (0,_config__WEBPACK_IMPORTED_MODULE_7__.ATLAS_TOKEN)();
        // Load the contents of the lab into the notebook
        if (token !== null || token !== 'NO_TOKEN') {
            await (0,_tools__WEBPACK_IMPORTED_MODULE_5__.loadLabContents)(nbPanel, (0,_handler__WEBPACK_IMPORTED_MODULE_6__.axiosHandler)(), _config__WEBPACK_IMPORTED_MODULE_7__.Globals.author_env)
                .then(() => nbPanel.show());
            //bPanel.revealed;
        }
    });
}
/**
 * Export the plugin as default.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);


/***/ }),

/***/ "./lib/config.js":
/*!***********************!*\
  !*** ./lib/config.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ATLAS_BASE_URL": () => (/* binding */ ATLAS_BASE_URL),
/* harmony export */   "ATLAS_TOKEN": () => (/* binding */ ATLAS_TOKEN),
/* harmony export */   "Globals": () => (/* binding */ Globals)
/* harmony export */ });
/* provided dependency */ var process = __webpack_require__(/*! process/browser */ "./node_modules/process/browser.js");
const ATLAS_BASE_URL = () => {
    var _a;
    const currentURL = window.location.href;
    const params = new URL(currentURL).searchParams;
    const base_url = params.get('atlas_base_url');
    if (base_url === null) {
        return (_a = process.env.ATLAS_BASE_URL) !== null && _a !== void 0 ? _a : 
        //'https://author.skills.network/atlas'
        'https://author.staging.skills.network/atlas';
    }
    return base_url;
};
/**
 * Extracts the session token. Will first try to get a token via the URL, if none was found then try to get the token via cookie.
 *
 * @returns token
 */
const ATLAS_TOKEN = () => {
    var _a;
    const currentURL = window.location.href;
    console.log('hi the current URL is ', currentURL);
    const params = new URL(currentURL).searchParams;
    let token = params.get('token');
    console.log('Tried to get token from URL param - found:', token);
    if (token === null) {
        // Try getting it from cookie
        const COOKIE_NAME = (_a = process.env.ATLAS_TOKEN_COOKIE_NAME) !== null && _a !== void 0 ? _a : 'atlas_token';
        const reg = new RegExp(`(^| )${COOKIE_NAME}=([^;]+)`);
        let match = reg.exec(document.cookie);
        // If found then set that as our token o/w set it as empty str for now
        (match !== null) ? token = match[2] : token = 'NO_TOKEN';
    }
    console.log('Tried to get token from cookies - found:', token);
    if (token === null || token === 'NO_TOKEN') {
        // If no token was found in the URL or cookies, the author is in their local env (hopefully...)
        Globals.author_env = 'local';
        // Persist this token
        Globals.token = token;
    }
    return token;
};
// Global token variable that will store the
class Globals {
}


/***/ }),

/***/ "./lib/dialog.js":
/*!***********************!*\
  !*** ./lib/dialog.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SpinnerDialog": () => (/* binding */ SpinnerDialog),
/* harmony export */   "showFailureImportLabDialog": () => (/* binding */ showFailureImportLabDialog),
/* harmony export */   "showFailurePublishDialog": () => (/* binding */ showFailurePublishDialog),
/* harmony export */   "showSuccessPublishDialog": () => (/* binding */ showSuccessPublishDialog),
/* harmony export */   "show_spinner": () => (/* binding */ show_spinner)
/* harmony export */ });
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* eslint-disable @typescript-eslint/no-empty-function */


/**
 * A widget that holds the loading spinner
 */
class SpinnerDialog extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    constructor() {
        const body = document.createElement('div');
        const spinner = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Spinner();
        body.appendChild(spinner.node);
        body.style.padding = '15px';
        super({ node: body });
    }
}
/**
 * Shows the Loading dialog
 */
const show_spinner = (message) => {
    const spinWidget = new SpinnerDialog();
    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
        title: message,
        body: spinWidget,
        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton()]
    })
        .then(result => { })
        .catch(error => { });
};
/**
 * Shows the Success dialog
 */
const showSuccessPublishDialog = () => {
    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
        title: 'Success!',
        body: 'This lab was successfully submitted for publishing!',
        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton()]
    })
        .then(result => { })
        .catch(error => { });
};
/**
 * Shows the Failed to publish dialog
 */
const showFailurePublishDialog = () => {
    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
        title: 'Failed to Publish',
        body: 'This lab failed to publish.',
        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton()]
    })
        .then(result => { })
        .catch(error => { });
};
/**
 * Shows the Failed to load lab dialog
 */
const showFailureImportLabDialog = () => {
    (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
        title: 'Failed to Load Lab',
        body: 'This lab failed to load.',
        buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton()]
    })
        .then(result => { })
        .catch(error => { });
};


/***/ }),

/***/ "./lib/handler.js":
/*!************************!*\
  !*** ./lib/handler.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "axiosHandler": () => (/* binding */ axiosHandler),
/* harmony export */   "getLabModel": () => (/* binding */ getLabModel),
/* harmony export */   "postLabModel": () => (/* binding */ postLabModel)
/* harmony export */ });
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dialog */ "./lib/dialog.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./config */ "./lib/config.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "webpack/sharing/consume/default/axios/axios");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);





const axiosHandler = (lab_token) => {
    if (lab_token)
        _config__WEBPACK_IMPORTED_MODULE_2__.Globals.token = lab_token;
    let auth_token;
    lab_token !== undefined ? auth_token = lab_token : auth_token = (0,_config__WEBPACK_IMPORTED_MODULE_2__.ATLAS_TOKEN)();
    const atlasClient = axios__WEBPACK_IMPORTED_MODULE_1___default().create({
        baseURL: (0,_config__WEBPACK_IMPORTED_MODULE_2__.ATLAS_BASE_URL)(),
        headers: {
            Authorization: `Bearer ${auth_token}`,
            'Content-Type': 'application/json',
            'Access-Control-Allow-Origin': '*'
        }
    });
    return atlasClient;
};
/**
 * GET the lab model / JSON that represents a .ipynb file/notebook from ATLAS
 *
 * @param axiosHandler Axios client that contains a JWT Bearer token
 * @returns Promise<void>
 */
const getLabModel = (axiosHandler) => {
    // GET the lab model
    return axiosHandler
        .get('v1/labs')
        .then(result => {
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.flush(); //remove spinner
        console.log(result.data);
        return JSON.parse(result.data.body);
    })
        .catch(error => {
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.flush(); //remove spinner
        (0,_dialog__WEBPACK_IMPORTED_MODULE_3__.showFailureImportLabDialog)();
        console.log(error);
        return 0;
    });
};
/**
 * POST the lab model / JSON from the .ipynb file/notebook to ATLAS
 *
 * @param axiosHandler Axios client that contains a JWT Bearer token
 * @returns Promise<void>
 */
const postLabModel = async (axiosHandler, labModel) => {
    (0,_dialog__WEBPACK_IMPORTED_MODULE_3__.show_spinner)('Publishing...');
    return new Promise(async (resolve, reject) => {
        await axiosHandler
            .post('v1/labs', {
            body: labModel
        })
            .then(res => {
            console.log('SUCCESSFULLY PUSHED', res);
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.flush(); //remove spinner
            (0,_dialog__WEBPACK_IMPORTED_MODULE_3__.showSuccessPublishDialog)();
            resolve;
        })
            .catch((error) => {
            console.log(error);
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.flush(); // remove spinner
            (0,_dialog__WEBPACK_IMPORTED_MODULE_3__.showFailurePublishDialog)();
            reject;
        });
    });
};


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _menu__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./menu */ "./lib/menu/index.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./button */ "./lib/button/index.js");


const main = [
    _button__WEBPACK_IMPORTED_MODULE_0__["default"],
    _menu__WEBPACK_IMPORTED_MODULE_1__.menu
];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (main);


/***/ }),

/***/ "./lib/menu/index.js":
/*!***************************!*\
  !*** ./lib/menu/index.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "menu": () => (/* binding */ menu)
/* harmony export */ });
/* harmony import */ var _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/mainmenu */ "webpack/sharing/consume/default/@jupyterlab/mainmenu");
/* harmony import */ var _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dialog */ "./lib/dialog.js");
/* harmony import */ var _tools__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../tools */ "./lib/tools.js");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../handler */ "./lib/handler.js");







const menu = {
    id: 'author-ide-extension:menu',
    autoStart: true,
    requires: [_jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_0__.IMainMenu, _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__.INotebookTracker],
    activate: (app, mainMenu, notebookTracker) => {
        console.log('Activated Author-ide-extension menu plugin!');
        const editLabFromToken = 'edit-lab-from-token';
        app.commands.addCommand(editLabFromToken, {
            label: 'Edit a Lab',
            execute: () => {
                showTokenDialog(notebookTracker);
            }
        });
        const { commands } = app;
        // Create a new menu
        const menu = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Menu({ commands });
        menu.title.label = 'Skills Network';
        mainMenu.addMenu(menu, { rank: 80 });
        // Add command to menu
        menu.addItem({
            command: editLabFromToken,
            args: {}
        });
        const showTokenDialog = (notebookTracker) => {
            // Generate Dialog body
            let bodyDialog = document.createElement('div');
            let nameLabel = document.createElement('label');
            nameLabel.textContent = "Enter your authorization token: ";
            let tokenInput = document.createElement('input');
            tokenInput.className = "jp-mod-styled";
            bodyDialog.appendChild(nameLabel);
            bodyDialog.appendChild(tokenInput);
            (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showDialog)({
                title: "Edit a Lab",
                body: new _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget({ node: bodyDialog }),
                buttons: [_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.cancelButton(), _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.okButton()]
            }).then(async (result) => {
                if (result.button.accept) {
                    (0,_dialog__WEBPACK_IMPORTED_MODULE_4__.show_spinner)('Loading up your lab...');
                    let panel = notebookTracker.currentWidget;
                    if (panel === null) {
                        throw Error('Error loading lab');
                    }
                    await (0,_tools__WEBPACK_IMPORTED_MODULE_5__.loadLabContents)(panel, (0,_handler__WEBPACK_IMPORTED_MODULE_6__.axiosHandler)(tokenInput.value));
                }
            })
                .catch();
        };
    }
};


/***/ }),

/***/ "./lib/tools.js":
/*!**********************!*\
  !*** ./lib/tools.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_CONTENT": () => (/* binding */ DEFAULT_CONTENT),
/* harmony export */   "getCellContents": () => (/* binding */ getCellContents),
/* harmony export */   "getFileContents": () => (/* binding */ getFileContents),
/* harmony export */   "loadLabContents": () => (/* binding */ loadLabContents)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./handler */ "./lib/handler.js");


/**
 * Extracts the relevant data from the cells of the notebook
 *
 * @param cell Cell model
 * @returns ICellData object
 */
const getCellContents = (cell) => {
    const cellData = {
        cell_type: cell.model.type,
        id: cell.model.id,
        metadata: {},
        outputs: [],
        source: [cell.model.value.text]
    };
    return cellData;
};
/**
 * Gets the raw data (cell models and content, notebook configurations) from the .ipynb file
 *
 * @param panel Notebook panel
 * @param context Notebook context
 */
const getFileContents = (panel, context) => {
    // Cell types: "code" | "markdown" | "raw"
    const allCells = [];
    panel.content.widgets.forEach((cell) => {
        const cellData = getCellContents(cell);
        allCells.push(cellData);
    });
    // Get the configs from the notebook model
    const config_meta = context.model.metadata.toJSON();
    const config_nbmajor = context.model.nbformat;
    const config_nbminor = context.model.nbformatMinor;
    // Put all data into IPynbRaw object
    const rawFile = {
        cells: allCells,
        metadata: config_meta,
        nbformat: config_nbmajor,
        nbformat_minor: config_nbminor
    };
    return JSON.stringify(rawFile, null, 2);
};
const loadLabContents = async (widget, axiosHandlers, author_env) => {
    const model = new _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookModel();
    // Only try to load the initial lab notebook if the author is not coming from their local env
    if (author_env !== 'local') {
        try {
            const lab_model = (await (0,_handler__WEBPACK_IMPORTED_MODULE_1__.getLabModel)(axiosHandlers));
            console.log('heres the model: ', lab_model);
            model.fromJSON(lab_model);
        }
        catch (_a) {
            throw 'something went wrong';
        }
        // testing purposes
        //model.fromJSON(DEFAULT_CONTENT);
    }
    // testing purposes:
    // model.fromJSON(DEFAULT_CONTENT);
    widget.content.model = model;
};
// eslint-disable-next-line @typescript-eslint/quotes
const DEFAULT_CONTENT = {
    cells: [
        {
            cell_type: 'code',
            id: 'c852569f-bf26-4994-88e7-3b94874d3853',
            metadata: {},
            source: ['print("hello world again")']
        },
        {
            cell_type: 'markdown',
            id: '5a2dc856-763a-4f12-b675-481ed971178a',
            metadata: {},
            source: ['this is markdown']
        },
        {
            cell_type: 'raw',
            id: '492a02e8-ec75-49f7-8560-b30256bca6af',
            metadata: {},
            source: ['this is raw']
        }
    ],
    metadata: {
        kernelspec: {
            display_name: 'Python 3 (ipykernel)',
            language: 'python',
            name: 'python3'
        },
        language_info: {
            codemirror_mode: { name: 'ipython', version: 3 },
            file_extension: '.py',
            mimetype: 'text/x-python',
            name: 'python',
            nbconvert_exporter: 'python',
            pygments_lexer: 'ipython3',
            version: '3.10.4'
        }
    },
    nbformat: 4,
    nbformat_minor: 5
};


/***/ }),

/***/ "./node_modules/process/browser.js":
/*!*****************************************!*\
  !*** ./node_modules/process/browser.js ***!
  \*****************************************/
/***/ ((module) => {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ })

}]);
//# sourceMappingURL=lib_index_js.f08ac516b2b00efa1805.js.map