from airflow.providers.cncf.kubernetes.operators.kubernetes_pod import KubernetesPodOperator
from airflow.utils.context import Context

from pathlib import Path
import json


# Ref: https://github.com/apache/airflow/blob/main/airflow/providers/cncf/kubernetes/operators/kubernetes_pod.py
class FlowuiKubernetesPodOperator(KubernetesPodOperator):

    def execute(self, context: Context):
        # Fetch upstream tasks XCOM data and save it in a json file
        upstream_task_ids = [t.task_id for t in self.get_direct_relatives(upstream=True)]
        upstream_xcoms = dict()
        for tid in upstream_task_ids:
            upstream_xcoms[tid] = context['ti'].xcom_pull(task_ids=tid) 
        
        xcom_in_file = Path("/opt/airflow/flowui/xcom/xcom_input.json")
        with open(xcom_in_file, "w") as f:
            json.dump(upstream_xcoms, f, indent=4)
        
        return super().execute(context=context)